/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.net.server;

import com.teacode.bml.BML;
import com.teacode.bml.LoadMode;
import com.teacode.util.Base64;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ontobox.net.server.BoxContext;
import org.ontobox.net.server.HttpErrorException;
import org.ontobox.storage.StorageBox;

public class OntoboxServlet
extends HttpServlet {
    private static final String KEY = "org.ontobox.net.Server";
    private static final Logger logger = Logger.getLogger(OntoboxServlet.class.getName());

    public void init() throws ServletException {
        logger.info("Init servlet");
        super.init();
        String user = this.getInitParameter("user");
        String password = this.getInitParameter("password");
        String mask = "";
        for (int t = 0; t < password.length(); ++t) {
            mask = mask + '*';
        }
        String box = this.getInitParameter("box");
        logger.info(user + ":" + mask + ":" + box);
        StorageBox b = box == null ? new StorageBox() : new StorageBox(new File(box));
        BoxContext ctx = new BoxContext(user, password, b);
        this.getServletContext().setAttribute(KEY, (Object)ctx);
    }

    public void destroy() {
        logger.info("Closing servlet");
        super.destroy();
        try {
            BoxContext ctx = (BoxContext)this.getServletContext().getAttribute(KEY);
            ctx.getBox().close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "closing error", e);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.info("Processing...");
        try {
            int t;
            byte[] decoded;
            String BASIC;
            request.setCharacterEncoding("UTF-8");
            String s = request.getHeader("Authorization");
            if (s != null && s.startsWith(BASIC = "Basic ") && (decoded = Base64.decode((String)(s = s.substring(BASIC.length())))) != null && (t = (s = new String(decoded, "ASCII")).indexOf(58)) != -1) {
                String login = s.substring(0, t);
                String password = s.substring(t + 1);
                String name = request.getPathInfo();
                if (name == null || name.length() == 1 || name.charAt(0) != '/') {
                    throw new HttpErrorException(404);
                }
                name = name.substring(1);
                System.out.println(login + ":" + password + ":" + name);
                Object param = BML.load((InputStream)request.getInputStream(), (LoadMode)LoadMode.LIST_AS_ARRAY);
                System.out.println("Param: " + param);
                response.setContentType("application/x-bml");
                ServletOutputStream out = response.getOutputStream();
                BML.save((Object)1, (OutputStream)out);
                out.close();
                return;
            }
            throw new HttpErrorException(401);
        }
        catch (HttpErrorException e) {
            int code = e.getCode();
            if (code == 401 || code == 403) {
                response.setHeader("WWW-Authenticate", "Basic realm=\"ontobox server\"");
            }
            response.sendError(code);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "ontobox server error", e);
            response.setHeader("X-Error", e.toString());
            response.sendError(500, e.toString());
        }
    }
}

