/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.play.java;

import com.teacode.code.java.JavaString;
import com.teacode.file.FileUtil;
import java.io.File;
import play.Play;
import play.libs.IO;
import play.vfs.VirtualFile;

public class JavaGenerator {
    private File controllersDir;
    private static final String CONTROLLERS = "controllers";

    public JavaGenerator() {
        File dir = Play.tmpDir;
        if (dir == null) {
            throw new IllegalStateException("A temporary directory is not detected.");
        }
        if (Play.readOnlyTmp) {
            throw new IllegalStateException("A temporary directory is read-only.");
        }
        File javaPath = new File(new File(dir, "libretto"), "java");
        javaPath.mkdirs();
        this.controllersDir = new File(javaPath, CONTROLLERS);
        this.cleanUp();
        Play.javaPath.add(VirtualFile.open((File)javaPath));
    }

    public static String generateImport(String ... packages) {
        StringBuilder sb = new StringBuilder();
        for (String p : packages) {
            sb.append("import ").append(p).append(";\n");
        }
        return sb.toString();
    }

    public void generateJava(String name, String body) {
        File f = new File(this.controllersDir, name + ".java");
        StringBuilder sb = new StringBuilder("package controllers;\n\n");
        sb.append(JavaGenerator.generateImport("java.io.File", "org.ontobox.play.*", "play.mvc.*", "play.mvc.results.*"));
        sb.append("\npublic class ").append(name).append(" extends LibrettoController {\n");
        sb.append(body);
        sb.append("}\n");
        IO.writeContent((CharSequence)sb, (File)f);
    }

    public static String generateMethod(String name, String body) {
        StringBuilder sb = new StringBuilder();
        sb.append("\tpublic static void ").append(name).append("() {\n");
        sb.append(body);
        sb.append("\t}\n");
        return sb.toString();
    }

    public static String generateMethodQuery(String name, File queryFile) {
        return JavaGenerator.generateMethod(name, String.format("\t\tdoQuery(new File(%s));\n", JavaString.javaString((String)queryFile.getAbsolutePath())));
    }

    public void cleanUp() {
        FileUtil.deleteFile((File)this.controllersDir);
        this.controllersDir.mkdirs();
    }
}

