/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.play.var;

import com.teacode.collection.IntArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.play.var.ObjectsVar;
import org.ontobox.play.var.StringsVar;
import org.ontobox.play.var.TemplateVar;
import play.classloading.enhancers.LocalvariablesNamesEnhancer;

public class LTTData {
    private final Map<String, TemplateVar> data = new HashMap<String, TemplateVar>();

    public LTTData(Object ... args) {
        for (Object arg : args) {
            for (String s : LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.getAllLocalVariableNames((Object)arg)) {
                if (arg instanceof String) {
                    this.putString(s, (String)arg);
                    continue;
                }
                if (arg instanceof Integer) {
                    this.putObject(s, (Integer)arg);
                    continue;
                }
                if (arg instanceof List) {
                    List col = (List)arg;
                    if (col.isEmpty()) {
                        this.putObjects(s, Collections.<Integer>emptyList());
                        continue;
                    }
                    Object o = col.get(0);
                    if (o instanceof Integer) {
                        this.putObjects(s, col);
                        continue;
                    }
                    if (o instanceof String) {
                        this.putStrings(s, col);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported list element type [" + o.getClass() + "] for " + s);
                }
                throw new IllegalArgumentException("Unsupported data type [" + arg.getClass() + "] for " + s);
            }
        }
    }

    public LTTData putString(String name, String string) {
        this.data.put(name, new StringsVar(Collections.singletonList(string)));
        return this;
    }

    public LTTData putStrings(String name, List<String> strings) {
        this.data.put(name, new StringsVar(strings));
        return this;
    }

    public LTTData putObject(String name, int integer) {
        this.putObjects(name, Collections.singletonList(integer));
        return this;
    }

    public LTTData putObjects(String name, int[] integer) {
        this.putObjects(name, (List<Integer>)new IntArrayList(integer));
        return this;
    }

    public LTTData putObjects(String name, List<Integer> ids) {
        this.data.put(name, new ObjectsVar(ids));
        return this;
    }

    public int createC(BoxWorker worker) {
        BoxWriter writer = worker.write();
        int c = writer.newLWObject();
        for (Map.Entry<String, TemplateVar> entry : this.data.entrySet()) {
            String name = entry.getKey();
            TemplateVar var = entry.getValue();
            var.setKey(worker, c, name);
        }
        writer.annotate(c, "http://ontobox.org/#Lock", "http://ontobox.org/#Lock");
        return c;
    }
}

