/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.query.QContext;
import org.ontobox.exchange.MVX;
import org.ontobox.storage.StorageBox;

public class LargeTransactionsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int secs = 12012;
        System.out.println(String.format("%02d:%02d:%02d", TimeUnit.SECONDS.toHours(secs), TimeUnit.SECONDS.toMinutes(secs), TimeUnit.SECONDS.toSeconds(secs) - TimeUnit.MINUTES.toSeconds(TimeUnit.SECONDS.toMinutes(secs))));
        int SECS_IN_HOUR = 3600;
        int SECS_IN_MIN = 60;
        System.out.println(String.format("%02d:%02d:%02d", secs / SECS_IN_HOUR, secs % SECS_IN_HOUR / SECS_IN_MIN, secs % SECS_IN_MIN));
        File mvx = new File("m2v1", "server.m2v1");
        File out = new File("m2v1", "out.mvx");
        File ontobase = new File("onto", "testOntobase");
        File mvx1 = LargeTransactionsTest.chars(mvx);
        StorageBox box = new StorageBox(ontobase, false);
        try {
            BoxWorker worker = box.work();
            try {
                worker.q(new QContext(), "require\u00a0x\u00a0\"http://xml.ontobox.org/\";");
                MVX.importFile(mvx1, worker);
                LargeTransactionsTest.card(worker);
                LargeTransactionsTest.renameOntology(worker);
                LargeTransactionsTest.addSections(worker);
                MVX.exportFile(out, worker);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                worker.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            box.close();
        }
        ontobase.delete();
        StorageBox testbox = new StorageBox();
        try {
            BoxWorker worker = testbox.work();
            try {
                MVX.importFile(out, worker);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                worker.close();
            }
        }
        finally {
            testbox.close();
        }
        mvx1.delete();
    }

    private static File chars(File mvx) throws Exception {
        String s;
        System.out.println("Converting...");
        File newFile = new File("1.mvx");
        ZipFile zip = new ZipFile(mvx);
        InputStream in = zip.getInputStream(zip.getEntry("ontobase/ontobase.xml"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(newFile));
        ZipEntry entry = new ZipEntry("ontobox.xml");
        zout.putNextEntry(entry);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)zout, "UTF-8"));
        while ((s = reader.readLine()) != null) {
            int i = s.indexOf("&#x16;");
            if (i > 0) {
                while (i > 0) {
                    s = s.substring(0, i) + s.substring(i + 6);
                    i = s.indexOf("&#x16;");
                }
            }
            writer.write(s);
            writer.write("\n");
        }
        ((Writer)writer).close();
        reader.close();
        return newFile;
    }

    private static void card(BoxWorker worker) {
        String[] tprops = new String[]{"http://journal.meta2project.org#series", "http://journal.meta2project.org#cover", "http://journal.meta2project.org#number", "http://journal.meta2project.org#year", "http://journal.meta2project.org#openDate", "http://journal.meta2project.org#rus", "http://journal.meta2project.org#eng", "http://journal.meta2project.org#isBlocked"};
        BoxWriter writer = worker.write();
        writer.annotate(worker.resolve("http://journal.meta2project.org#editors"), "http://ontobox.org/#maxcard", null);
        for (String tp : tprops) {
            int t = worker.resolve(tp, Entity.TPROPERTY);
            for (int obj : worker.objects(worker.domain(t))) {
                String[] vals = worker.strings(obj, t);
                if (vals.length <= 0) continue;
                String val = vals[0];
                worker.name(worker.range(t));
                writer.removeValues(obj, t);
                writer.addString(obj, t, val);
            }
        }
    }

    private static void renameOntology(BoxWorker worker) {
        int ont = worker.resolve("http://journal.meta2project.org", Entity.ONTOLOGY);
        worker.write().rename(ont, "http://journal.isu.ru");
    }

    private static void addSections(BoxWorker worker) {
        QContext context = new QContext();
        context.setDefaultPrefix("http://journal.isu.ru");
        String q1 = "class Section extends MultilanguagedClass;";
        String q2 = "class HasSection{section Section;};";
        String q3 = "class Article extends HasSection;";
        String q4 = "class Journal extends HasSection;";
        worker.q(context, q1);
        worker.q(context, q2);
        worker.q(context, q3);
        worker.q(context, q4);
    }

    @Deprecated
    private static void chStructure(BoxWorker worker) {
        String oldURI = "http://journal.meta2project.org";
        String newURI = "http://journal.isu.ru";
        int ont = worker.resolve("http://journal.meta2project.org");
        BoxWriter writer = worker.write();
        QContext context = new QContext();
        writer.rename(ont, "http://journal.isu.ru");
        worker.commit();
        String q = "prefix . \"http://journal.isu.ru\"; class Series extends MultilanguagedClass; Journal/series/v:distinct()/Series &_{rus := .}; class Journal {tmp v:string}; Journal/. {tmp := series}; Journal/. {series --};";
        worker.q(context, "prefix . \"http://journal.isu.ru\"; class Series extends MultilanguagedClass; Journal/series/v:distinct()/Series &_{rus := .}; class Journal {tmp v:string}; Journal/. {tmp := series}; Journal/. {series --};");
        writer.delete(worker.resolve("http://journal.isu.ru#series", Entity.TPROPERTY));
        String q1 = "class Journal { series Series }; Journal as $j {series := //Series[rus = $j/tmp]}; Journal/. {tmp --};";
        worker.q(context, "class Journal { series Series }; Journal as $j {series := //Series[rus = $j/tmp]}; Journal/. {tmp --};");
        writer.delete(worker.resolve("http://journal.isu.ru#tmp", Entity.TPROPERTY));
        worker.commit();
        writer.rename(worker.resolve("http://journal.isu.ru#articles", Entity.OPROPERTY), "http://journal.isu.ru#articles1");
        int sect = writer.newClass("http://journal.isu.ru#Section");
        int part = writer.newClass("http://journal.isu.ru#PartOfJournal");
        int journ = worker.resolve("http://journal.isu.ru#Journal", Entity.ONTCLASS);
        int art = worker.resolve("http://journal.isu.ru#Article", Entity.ONTCLASS);
        int titled = worker.resolve("http://journal.isu.ru#TitledItem", Entity.ONTCLASS);
        int op = writer.newOProperty("http://journal.isu.ru#articles");
        writer.setDomain(op, sect);
        writer.setRange(op, art);
        writer.addSubclass(titled, sect);
        writer.addSubclass(part, sect);
        writer.addSubclass(part, art);
        int items = writer.newOProperty("http://journal.isu.ru#items");
        writer.setDomain(items, journ);
        writer.setRange(items, part);
        worker.commit();
        String q3 = "Journal/. {items := articles1}; Journal/. {articles1 --};";
        worker.q(context, q3);
        writer.delete(worker.resolve("http://journal.isu.ru#articles1", Entity.OPROPERTY));
        worker.commit();
    }
}

