/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.test;

import java.io.File;
import java.io.IOException;
import org.ontobox.box.BoxClient;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.OntologyHelper;
import org.ontobox.exchange.MVX;
import org.ontobox.storage.StorageBox;

public class RequireTest {
    public static void generatePacks(BoxWorker worker) throws IOException {
        MVX.importFile(new File("d:\\_.mvx"), worker);
        String uri = "http://test1";
        MVX.exportOntology(worker, new File(OntologyHelper.sha(uri) + ".mvx"), worker.resolve(uri), true);
        uri = "http://test2";
        MVX.exportOntology(worker, new File(OntologyHelper.sha(uri) + ".mvx"), worker.resolve(uri), true);
    }

    public static void testRequire(BoxWorker worker) {
        worker.write().require("http://test1");
        worker.write().require("http://test2");
        for (int i : worker.ontologies()) {
            System.out.println(worker.name(i) + ": " + (Object)((Object)worker.isRequired(i)));
        }
        int o = worker.resolve("http://test2#test");
        for (String s : worker.strings(o, worker.resolve("http://test2#title"))) {
            System.out.println("title: " + s);
        }
        for (String s : worker.strings(o, worker.resolve("http://test1#text"))) {
            System.out.println("text: " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        StorageBox box = new StorageBox();
        try {
            box.client(new BoxClient<Object>(){

                @Override
                public Object process(BoxWorker worker) throws Exception {
                    RequireTest.testRequire(worker);
                    return null;
                }
            });
        }
        finally {
            box.close();
        }
    }
}

