/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.examples.fb2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.meta2project.examples.fb2.FB2;
import org.meta2project.examples.fb2.FB2ZipProcessor;
import org.meta2project.examples.fb2.FB2ZipScanner;

public class FB2Extractor {
    private static String RUS = "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f";
    private static String LAT = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static String SPEC = "0123456789-!,. ";
    private static String ALL = RUS + LAT + SPEC;
    private static String LETTERS = RUS + LAT;
    private static byte[] buf = new byte[100000];

    private static String escape(String text) {
        if (text == null) {
            return "_";
        }
        text = text.replace('\u0401', '\u0435');
        text = text.replace('\u0451', '\u0435');
        StringBuilder sb = new StringBuilder(text.length());
        for (int t = 0; t < text.length(); ++t) {
            char ch = text.charAt(t);
            if (ALL.indexOf(Character.toUpperCase(ch)) != -1) {
                sb.append(ch);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private static char first(String text) {
        text = text.replace('\u0401', '\u0435');
        text = text.replace('\u0451', '\u0435');
        StringBuilder sb = new StringBuilder(text.length());
        for (int t = 0; t < text.length(); ++t) {
            char ch = Character.toUpperCase(text.charAt(t));
            if (LETTERS.indexOf(ch) == -1) continue;
            return ch;
        }
        return '_';
    }

    private static String all(String[] strings) {
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            if (s == null || (s = s.trim()).isEmpty()) continue;
            sb.append(' ');
            sb.append(s);
        }
        return sb.toString().trim();
    }

    private static String one(String[] strings) {
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            if (s == null || (s = s.trim()).isEmpty()) continue;
            return s;
        }
        return "";
    }

    public static void main(String[] args) throws IOException {
        File baseDir = new File(args[0]);
        final File outDir = new File(args[1]);
        System.out.println(baseDir + " -> " + outDir);
        FB2ZipScanner scanner = new FB2ZipScanner(baseDir, true);
        scanner.scan(new FB2ZipProcessor(){

            @Override
            public void processZip(ZipFile zip, String name, FB2 fb2) throws Exception {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (String[] names : fb2.getAuthors()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(FB2Extractor.one(names));
                }
                for (String[] names : fb2.getAuthors()) {
                    String author = FB2Extractor.all(names);
                    File dir = new File(new File(outDir, String.valueOf(FB2Extractor.first(author))), FB2Extractor.escape(author));
                    dir.mkdirs();
                    File f = new File(dir, FB2Extractor.escape(sb + " - " + fb2.getTitle() + ".fb2"));
                    String text = name + " -> " + f.toString();
                    System.out.println(text);
                    FB2Extractor.addLog(text);
                    FB2Extractor.extract(zip, name, f);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addLog(String text) throws IOException {
        FileWriter writer = new FileWriter("out.log", true);
        try {
            writer.write(text + '\n');
        }
        finally {
            ((Writer)writer).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extract(ZipFile zip, String entryName, File outFile) throws IOException {
        ZipEntry zipEntry = zip.getEntry(entryName);
        InputStream in = zip.getInputStream(zipEntry);
        try {
            FileOutputStream out = new FileOutputStream(outFile);
            try {
                int read;
                while ((read = in.read(buf)) != -1) {
                    ((OutputStream)out).write(buf, 0, read);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            in.close();
        }
    }
}

