/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.examples.fb2;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.meta2project.examples.fb2.FB2;
import org.meta2project.examples.fb2.FB2Processor;

class FB2Scanner {
    private static final Logger logger = Logger.getLogger(FB2Scanner.class.getName());
    private final File baseDir;
    private final boolean verbose;

    public FB2Scanner(File dir, boolean v) {
        this.baseDir = dir;
        this.verbose = v;
    }

    public void scan(FB2Processor processor) throws IOException {
        this.scanDir(this.baseDir, processor);
    }

    private void scanDir(File dir, FB2Processor processor) throws IOException {
        if (this.verbose) {
            System.out.println(dir);
        }
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                String name = file.getName().toLowerCase();
                if (name.endsWith(".zip")) {
                    this.scanZip(file, processor);
                    continue;
                }
                if (!name.endsWith(".fb2")) continue;
                this.scanFB2(file, processor);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.scanDir(file, processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanZip(File file, FB2Processor processor) {
        try {
            ZipFile zFile = new ZipFile(file, "Cp866");
            Enumeration entries = zFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String name = entry.getName();
                if (!name.toLowerCase().endsWith(".fb2")) continue;
                InputStream in = zFile.getInputStream(entry);
                try {
                    this.process(file, name, in, processor);
                }
                finally {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, file.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFB2(File file, FB2Processor processor) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            this.process(file, file.getName(), in, processor);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private void process(File file, String name, InputStream in, FB2Processor processor) {
        try {
            if (this.verbose) {
                System.out.println(file + " -> " + name);
            }
            FB2 fb2 = new FB2(in);
            processor.process(file, name, fb2);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, file.getAbsolutePath(), e);
        }
    }
}

