/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.examples.fb2;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.meta2project.examples.fb2.FB2;
import org.meta2project.examples.fb2.FB2Processor;
import org.meta2project.examples.fb2.FB2Scanner;
import org.meta2project.fast.adapter.FastSession;
import org.meta2project.model.Connection;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.ontobox.exchange.MVX;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        FastSession session = new FastSession();
        try {
            Connection con = session.openConnection();
            try {
                final Ontology ont = con.createOntology("http://meta2project.org/fb2");
                final OntClass bookClass = ont.createOntClass("Book", new OntClass[0]);
                final OntClass personClass = ont.createOntClass("Person", new OntClass[0]);
                final TProperty firstProp = ont.createTProperty("firstName", personClass, "http://ontobox.org/#string", 0, 1);
                final TProperty middleProp = ont.createTProperty("middleName", personClass, "http://ontobox.org/#string", 0, 1);
                final TProperty lastProp = ont.createTProperty("lastName", personClass, "http://ontobox.org/#string", 0, 1);
                final OProperty books = ont.createOProperty("book", personClass, bookClass, 0, null);
                final TProperty nameProp = ont.createTProperty("name", bookClass, "http://ontobox.org/#string", 1, 1);
                final TProperty pathProp = ont.createTProperty("path", bookClass, "http://ontobox.org/#string", 1, 1);
                final TProperty titleProp = ont.createTProperty("title", bookClass, "http://ontobox.org/#string", 0, 1);
                final TProperty srcTitleProp = ont.createTProperty("srcTitle", bookClass, "http://ontobox.org/#string", 0, 1);
                final OProperty authorProp = ont.createOProperty("author", bookClass, personClass, 0, null);
                final OProperty srcAuthorProp = ont.createOProperty("srcAuthor", bookClass, personClass, 0, null);
                final TProperty genreProp = ont.createTProperty("genre", bookClass, "http://ontobox.org/#string", 0, null);
                final TProperty keywordsProp = ont.createTProperty("keywords", bookClass, "http://ontobox.org/#string", 0, 1);
                final TProperty bookNameProp = ont.createTProperty("bookaName", bookClass, "http://ontobox.org/#string", 0, 1);
                final TProperty publisherProp = ont.createTProperty("publisher", bookClass, "http://ontobox.org/#string", 0, 1);
                final TProperty cityProp = ont.createTProperty("city", bookClass, "http://ontobox.org/#string", 0, 1);
                final TProperty dateProp = ont.createTProperty("date", bookClass, "http://ontobox.org/#string", 0, 1);
                final TProperty yearProp = ont.createTProperty("year", bookClass, "http://ontobox.org/#string", 0, 1);
                final TProperty isbnProp = ont.createTProperty("isbn", bookClass, "http://ontobox.org/#string", 0, 1);
                final TProperty annoProp = ont.createTProperty("annotation", bookClass, "http://ontobox.org/#string", 0, 1);
                final OProperty translatorProp = ont.createOProperty("translator", bookClass, personClass, 0, null);
                final TProperty langProp = ont.createTProperty("lang", bookClass, "http://ontobox.org/#string", 0, 1);
                final TProperty srcLangProp = ont.createTProperty("scrLang", bookClass, "http://ontobox.org/#string", 0, 1);
                bookClass.putAnnotation("http://meta2project.org/meta2#mask", "{title}");
                personClass.putAnnotation("http://meta2project.org/meta2#mask", "{lastName} {firstName} {middleName}");
                long t1 = System.currentTimeMillis();
                File baseDir = new File(args[0]);
                final String baseDirPath = baseDir.getCanonicalPath();
                FB2Scanner scanner = new FB2Scanner(baseDir, true);
                scanner.scan(new FB2Processor(){

                    private boolean equals(String s1, String s2) {
                        if (s1 == null) {
                            return s2 == null;
                        }
                        return s1.equals(s2);
                    }

                    private OntObject getPerson(String[] data, TProperty tprop, String value) {
                        Collection<OntObject> persons = tprop == null ? personClass.getAllOntObjects() : tprop.getOwners(value);
                        for (OntObject person : persons) {
                            if (!this.equals(data[0], person.getTPropertyString(lastProp)) || !this.equals(data[1], person.getTPropertyString(firstProp)) || !this.equals(data[2], person.getTPropertyString(middleProp))) continue;
                            return person;
                        }
                        OntObject ret = ont.createOntObject(personClass);
                        this.addTValue(ret, lastProp, data[0]);
                        this.addTValue(ret, firstProp, data[1]);
                        this.addTValue(ret, middleProp, data[2]);
                        return ret;
                    }

                    private OntObject getPerson(String[] data) {
                        if (data[0] != null) {
                            return this.getPerson(data, lastProp, data[0]);
                        }
                        if (data[1] != null) {
                            return this.getPerson(data, firstProp, data[1]);
                        }
                        if (data[2] != null) {
                            return this.getPerson(data, middleProp, data[2]);
                        }
                        return this.getPerson(data, null, null);
                    }

                    private void addTValue(OntObject obj, TProperty tprop, String value) {
                        if (value != null) {
                            obj.addTPropertyString(tprop, value);
                        }
                    }

                    @Override
                    public void process(File file, String name, FB2 fb2) throws IOException {
                        String filePath = file.getCanonicalPath();
                        if (filePath.startsWith(baseDirPath)) {
                            filePath = filePath.substring(baseDirPath.length());
                        }
                        if ((filePath = filePath.replace(File.separator, "/")).startsWith("/")) {
                            filePath = filePath.substring(1);
                        }
                        OntObject book = ont.createOntObject(bookClass);
                        book.addTPropertyString(nameProp, name);
                        book.addTPropertyString(pathProp, filePath);
                        this.addTValue(book, titleProp, fb2.getTitle());
                        this.addTValue(book, srcTitleProp, fb2.getSrcTitle());
                        for (String[] translator : fb2.getTranslators()) {
                            book.addOPropertyValue(translatorProp, this.getPerson(translator));
                        }
                        for (String[] author : fb2.getAuthors()) {
                            book.addOPropertyValue(authorProp, this.getPerson(author));
                        }
                        for (String[] author : fb2.getSrcAuthors()) {
                            book.addOPropertyValue(srcAuthorProp, this.getPerson(author));
                        }
                        for (String genre : fb2.getGenres()) {
                            book.addTPropertyString(genreProp, genre);
                        }
                        this.addTValue(book, keywordsProp, fb2.getKeywords());
                        this.addTValue(book, bookNameProp, fb2.getBookName());
                        this.addTValue(book, publisherProp, fb2.getPublisher());
                        this.addTValue(book, cityProp, fb2.getCity());
                        this.addTValue(book, yearProp, fb2.getYear());
                        this.addTValue(book, dateProp, fb2.getDate());
                        this.addTValue(book, isbnProp, fb2.getISBN());
                        this.addTValue(book, annoProp, fb2.getAnno());
                        this.addTValue(book, langProp, fb2.getLang());
                        this.addTValue(book, srcLangProp, fb2.getSrcLang());
                        for (String[] author : fb2.getAuthors()) {
                            OntObject person = this.getPerson(author);
                            person.addOPropertyValue(books, book);
                        }
                    }
                });
                long t2 = System.currentTimeMillis();
                System.out.println("Loaded " + bookClass.getOntObjects().size() + " books. " + (t2 - t1) + " ms.");
                MVX.exportFile(new File("fb2.m2v1"), con.getWorker());
                long t3 = System.currentTimeMillis();
                System.out.println("Exported. " + (t3 - t2) + " ms.");
            }
            finally {
                con.close();
            }
        }
        finally {
            session.close();
        }
    }
}

