/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.meta2project.model.Connection;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.test.support.SessionTestCase;
import org.meta2project.model.test.support.WorkerCleaner;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.exception.AlreadyExistsException;
import org.ontobox.box.exception.NotFoundException;

public class OntClassTestCase
extends SessionTestCase {
    private static final String NAME = "testclass";
    private Connection con;
    private Ontology ont;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://meta2.teacode.com/testcase");
    }

    protected void tearDown() throws Exception {
        try {
            this.ont.delete();
            this.con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateOntClass() throws Exception {
        OntClass cl = this.ont.createOntClass(NAME, new OntClass[0]);
        try {
            OntClassTestCase.assertEquals((String)"http://meta2.teacode.com/testcase#testclass", (String)cl.getFullName());
            OntClass cl2 = this.ont.getOntClass(NAME);
            OntClassTestCase.assertEquals((String)cl.getFullName(), (String)cl2.getFullName());
            cl2 = this.con.getOntClassByFullName(cl.getFullName());
            OntClassTestCase.assertEquals((String)cl.getFullName(), (String)cl2.getFullName());
        }
        finally {
            cl.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateOntClassVargs() throws Exception {
        OntClass c1 = this.ont.createOntClass("c1", new OntClass[0]);
        OntClass c2 = this.ont.createOntClass("c2", c1);
        OntClass c3 = this.ont.createOntClass("c3", c2);
        try {
            OntClassTestCase.assertTrue((boolean)c3.isSubclassOf(c1));
            OntClassTestCase.assertTrue((boolean)c3.isSubclassOf(c2));
            OntClassTestCase.assertTrue((boolean)c2.isSubclassOf(c1));
            OntClassTestCase.assertFalse((boolean)c1.isSubclassOf(c3));
            OntClassTestCase.assertFalse((boolean)c2.isSubclassOf(c3));
            OntClassTestCase.assertFalse((boolean)c1.isSubclassOf(c2));
        }
        finally {
            c3.delete();
            c2.delete();
            c1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateOntClassDub() throws Exception {
        OntClass cl = this.ont.createOntClass(NAME, new OntClass[0]);
        try {
            this.ont.createOntClass(NAME, new OntClass[0]);
            OntClassTestCase.fail((String)"should raise AlreadyExistsException exception");
        }
        catch (AlreadyExistsException alreadyExistsException) {
        }
        finally {
            cl.delete();
        }
    }

    public void testDeleteOntClass() throws Exception {
        OntClass cl = this.ont.createOntClass(NAME, new OntClass[0]);
        cl.delete();
        try {
            this.ont.getOntClass("http://meta2.teacode.com/testcase");
            OntClassTestCase.fail((String)"should raise NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubClass7() {
        BoxWorker worker = this.con.getWorker();
        String name = this.ont.getURI();
        int o = worker.id(name);
        WorkerCleaner cl = new WorkerCleaner(worker);
        try {
            BoxWriter writer = worker.write();
            int resource = writer.newClass(name + "#Resource");
            cl.add(resource);
            int cl1 = writer.newClass(name + "#cl1");
            cl.add(cl1);
            writer.addSubclass(resource, cl1);
            int cl2 = writer.newClass(name + "#cl2");
            cl.add(cl2);
            writer.addSubclass(cl1, cl2);
            writer.addSubclass(resource, cl2);
            worker.classes(cl2);
            try {
                writer.addSubclass(cl1, cl1);
                OntClassTestCase.fail((String)"should fail");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                writer.addSubclass(cl2, cl1);
                OntClassTestCase.fail((String)"should fail");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        finally {
            cl.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubClass() throws Exception {
        OntClass baseCl = this.ont.createOntClass("baseClass", new OntClass[0]);
        OntClass child1 = this.ont.createOntClass("child1", new OntClass[0]);
        OntClass child2 = this.ont.createOntClass("child2", new OntClass[0]);
        OntClass child3 = this.ont.createOntClass("child3", new OntClass[0]);
        try {
            baseCl.addSubClass(child1);
            baseCl.addSubClass(child2);
            child2.addSubClass(child3);
            OntClassTestCase.assertTrue((boolean)child3.isSubclassOf(child2));
            OntClassTestCase.assertTrue((boolean)child3.isSubclassOf(baseCl));
            OntClassTestCase.assertTrue((boolean)child2.isSubclassOf(baseCl));
            OntClassTestCase.assertTrue((boolean)child1.isSubclassOf(baseCl));
            OntClassTestCase.assertFalse((boolean)child3.isSubclassOf(child1));
            OntObject obj = this.ont.createOntObject(new Object[0]);
            try {
                OntClassTestCase.assertFalse((boolean)obj.isInstanceOf(baseCl));
                OntClassTestCase.assertFalse((boolean)obj.isInstanceOf(child1));
                OntClassTestCase.assertFalse((boolean)obj.isInstanceOf(child2));
                OntClassTestCase.assertFalse((boolean)obj.isInstanceOf(child3));
                obj.addOntClass(child3);
                OntClassTestCase.assertTrue((boolean)obj.isInstanceOf(baseCl));
                OntClassTestCase.assertFalse((boolean)obj.isInstanceOf(child1));
                OntClassTestCase.assertTrue((boolean)obj.isInstanceOf(child2));
                OntClassTestCase.assertTrue((boolean)obj.isInstanceOf(child3));
                obj.addOntClass(child1);
                OntClassTestCase.assertTrue((boolean)obj.isInstanceOf(baseCl));
                OntClassTestCase.assertTrue((boolean)obj.isInstanceOf(child1));
                OntClassTestCase.assertTrue((boolean)obj.isInstanceOf(child2));
                OntClassTestCase.assertTrue((boolean)obj.isInstanceOf(child3));
            }
            finally {
                obj.delete();
            }
        }
        finally {
            child3.delete();
            child2.delete();
            child1.delete();
            baseCl.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubClass2() throws Exception {
        OntClass baseCl = this.ont.createOntClass("baseClass", new OntClass[0]);
        OntClass child1 = this.ont.createOntClass("child1", new OntClass[0]);
        OntClass child2 = this.ont.createOntClass("child2", new OntClass[0]);
        OntClass child3 = this.ont.createOntClass("child3", new OntClass[0]);
        try {
            baseCl.addSubClass(child1);
            baseCl.addSubClass(child2);
            child1.addSubClass(child3);
            int count = 0;
            ArrayList<OntClass> cls = new ArrayList<OntClass>();
            for (OntClass ontClass : baseCl.getSubClasses()) {
                if (ontClass.getSubClasses().isEmpty()) {
                    cls.add(ontClass);
                }
                ++count;
            }
            OntClassTestCase.assertEquals((int)2, (int)count);
            OntClassTestCase.assertEquals((int)1, (int)cls.size());
            OntClassTestCase.assertEquals((Object)child2, cls.get(0));
            OntClassTestCase.assertEquals((String)"child2", (String)((OntClass)cls.get(0)).getName());
            Collection<OntClass> c = child3.getAllSuperClasses();
            OntClassTestCase.assertEquals((int)2, (int)c.size());
            OntClassTestCase.assertTrue((boolean)c.contains(child1));
            OntClassTestCase.assertTrue((boolean)c.contains(baseCl));
            c = child3.getSuperClasses();
            OntClassTestCase.assertEquals((int)1, (int)c.size());
            OntClassTestCase.assertTrue((boolean)c.contains(child1));
            c = child2.getAllSuperClasses();
            OntClassTestCase.assertEquals((int)1, (int)c.size());
            OntClassTestCase.assertTrue((boolean)c.contains(baseCl));
            c = child2.getSuperClasses();
            OntClassTestCase.assertEquals((int)1, (int)c.size());
            OntClassTestCase.assertTrue((boolean)c.contains(baseCl));
            c = baseCl.getAllSuperClasses();
            OntClassTestCase.assertTrue((boolean)c.isEmpty());
            c = baseCl.getSuperClasses();
            OntClassTestCase.assertTrue((boolean)c.isEmpty());
        }
        finally {
            child3.delete();
            child2.delete();
            child1.delete();
            baseCl.delete();
        }
    }

    private static void getLeafClasses(List<OntClass> cls, OntClass baseCl) throws Exception {
        boolean empty = true;
        for (OntClass ontClass : baseCl.getSubClasses()) {
            empty = false;
            OntClassTestCase.getLeafClasses(cls, ontClass);
        }
        if (empty) {
            cls.add(baseCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubClass3() throws Exception {
        OntClass baseCl = this.ont.createOntClass("baseClass", new OntClass[0]);
        OntClass child1 = this.ont.createOntClass("child1", new OntClass[0]);
        OntClass child2 = this.ont.createOntClass("child2", new OntClass[0]);
        OntClass child3 = this.ont.createOntClass("child3", new OntClass[0]);
        try {
            child2.addSubClass(child3);
            baseCl.addSubClass(child1);
            child1.addSubClass(child2);
            OntClassTestCase.assertTrue((boolean)child1.isSubclassOf(baseCl));
            OntClassTestCase.assertTrue((boolean)child2.isSubclassOf(baseCl));
            OntClassTestCase.assertTrue((boolean)child3.isSubclassOf(baseCl));
            OntClassTestCase.assertTrue((boolean)child2.isSubclassOf(child1));
            OntClassTestCase.assertTrue((boolean)child3.isSubclassOf(child1));
            OntClassTestCase.assertTrue((boolean)child3.isSubclassOf(child2));
        }
        finally {
            child3.delete();
            child2.delete();
            child1.delete();
            baseCl.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubClass4() throws Exception {
        OntClass baseCl = this.ont.createOntClass("baseClass", new OntClass[0]);
        OntClass child1 = this.ont.createOntClass("child1", new OntClass[0]);
        OntClass child2 = this.ont.createOntClass("child2", new OntClass[0]);
        OntClass child3 = this.ont.createOntClass("child3", new OntClass[0]);
        try {
            baseCl.addSubClass(child1);
            baseCl.addSubClass(child2);
            child1.addSubClass(child3);
            ArrayList<OntClass> cls = new ArrayList<OntClass>();
            OntClassTestCase.getLeafClasses(cls, baseCl);
            OntClassTestCase.assertEquals((int)2, (int)cls.size());
            OntClassTestCase.assertTrue((boolean)cls.contains(child2));
            OntClassTestCase.assertTrue((boolean)cls.contains(child3));
        }
        finally {
            child3.delete();
            child2.delete();
            child1.delete();
            baseCl.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubClass5() throws Exception {
        OntClass baseCl = null;
        OntClass child1 = null;
        OntClass child2 = null;
        OntClass child3 = null;
        try {
            OntClassTestCase.assertEquals((int)0, (int)this.ont.getOntClasses().size());
            OntClassTestCase.assertEquals((int)0, (int)this.ont.getBasicOntClasses().size());
            baseCl = this.ont.createOntClass("baseClass", new OntClass[0]);
            OntClassTestCase.assertEquals((int)1, (int)this.ont.getOntClasses().size());
            OntClassTestCase.assertEquals((int)1, (int)this.ont.getBasicOntClasses().size());
            child1 = this.ont.createOntClass("child1", new OntClass[0]);
            OntClassTestCase.assertEquals((int)2, (int)this.ont.getOntClasses().size());
            OntClassTestCase.assertEquals((int)2, (int)this.ont.getBasicOntClasses().size());
            child2 = this.ont.createOntClass("child2", new OntClass[0]);
            OntClassTestCase.assertEquals((int)3, (int)this.ont.getOntClasses().size());
            OntClassTestCase.assertEquals((int)3, (int)this.ont.getBasicOntClasses().size());
            child3 = this.ont.createOntClass("child3", new OntClass[0]);
            OntClassTestCase.assertEquals((int)4, (int)this.ont.getOntClasses().size());
            OntClassTestCase.assertEquals((int)4, (int)this.ont.getBasicOntClasses().size());
            baseCl.addSubClass(child1);
            OntClassTestCase.assertEquals((int)4, (int)this.ont.getOntClasses().size());
            OntClassTestCase.assertEquals((int)3, (int)this.ont.getBasicOntClasses().size());
            baseCl.addSubClass(child2);
            OntClassTestCase.assertEquals((int)4, (int)this.ont.getOntClasses().size());
            OntClassTestCase.assertEquals((int)2, (int)this.ont.getBasicOntClasses().size());
            child1.addSubClass(child3);
            OntClassTestCase.assertEquals((int)4, (int)this.ont.getOntClasses().size());
            OntClassTestCase.assertEquals((int)1, (int)this.ont.getBasicOntClasses().size());
        }
        finally {
            if (child3 != null) {
                child3.delete();
            }
            if (child2 != null) {
                child2.delete();
            }
            if (child1 != null) {
                child1.delete();
            }
            if (baseCl != null) {
                baseCl.delete();
            }
        }
    }
}

