/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import org.meta2project.model.Connection;
import org.meta2project.model.NamedEntity;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.event.NamedEntityListener;
import org.meta2project.model.event.NamedEntityRenamedEvent;
import org.meta2project.model.event.OntoListener;
import org.meta2project.model.event.OntologyEvent;
import org.meta2project.model.event.OntologyRenamedEvent;
import org.meta2project.model.test.support.SessionTestCase;

public class RenameListenerTestCase
extends SessionTestCase {
    protected static final int LISTENERS = 20;
    private Connection con;
    private Ontology ont;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://meta2.teacode.com/testcaserename");
    }

    protected void tearDown() throws Exception {
        try {
            this.ont.delete();
            this.con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOntoRename() throws Exception {
        MyOntoListener l = new MyOntoListener();
        this.session.getListenerManager().addOntoListener(l);
        RenameListenerTestCase.assertEquals(null, (String)l.getNewURI());
        RenameListenerTestCase.assertEquals(null, (String)l.getOldURI());
        String oldURI = this.ont.getURI();
        this.ont.setURI("http://another-long-uri");
        String newURI = this.ont.getURI();
        RenameListenerTestCase.assertEquals((String)oldURI, (String)l.getOldURI());
        RenameListenerTestCase.assertEquals((String)newURI, (String)l.getNewURI());
        Ontology ont2 = this.con.getOntology(newURI);
        RenameListenerTestCase.assertEquals((Object)this.ont, (Object)ont2);
        RenameListenerTestCase.assertEquals((String)this.ont.getURI(), (String)ont2.getURI());
        l.reset();
        RenameListenerTestCase.assertEquals(null, (String)l.getNewURI());
        RenameListenerTestCase.assertEquals(null, (String)l.getOldURI());
        this.ont.setURI("http://another-long-uri");
        RenameListenerTestCase.assertEquals(null, (String)l.getNewURI());
        RenameListenerTestCase.assertEquals(null, (String)l.getOldURI());
        this.session.getListenerManager().removeOntoListener(l);
        OntClass cl = this.ont.createOntClass("2333", new OntClass[0]);
        try {
            String n = this.ont.getURI();
            this.con.getEntity(n + "#2333");
            this.ont.setURI("http://34555");
            RenameListenerTestCase.assertNotNull((Object)this.con.getEntity("http://34555#2333"));
            this.con.getOntClassByFullName("http://34555#2333");
        }
        finally {
            cl.delete();
        }
    }

    void testNamedEntity(NamedEntity ent) throws Exception {
        MyNamedEntityListener l = new MyNamedEntityListener();
        this.session.getListenerManager().addNamedEntityListener(l);
        RenameListenerTestCase.assertEquals(null, (String)l.getNewName());
        RenameListenerTestCase.assertEquals(null, (String)l.getOldName());
        String oldName = ent.getName();
        ent.setName("very-long-name");
        RenameListenerTestCase.assertEquals((String)ent.getName(), (String)l.getNewName());
        RenameListenerTestCase.assertEquals((String)oldName, (String)l.getOldName());
        l.reset();
        RenameListenerTestCase.assertEquals(null, (String)l.getNewName());
        RenameListenerTestCase.assertEquals(null, (String)l.getOldName());
        ent.setName("very-long-name");
        RenameListenerTestCase.assertEquals(null, (String)l.getNewName());
        RenameListenerTestCase.assertEquals(null, (String)l.getOldName());
        this.session.getListenerManager().removeNamedEntityListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOntClass() throws Exception {
        OntClass cl = this.ont.createOntClass("test", new OntClass[0]);
        try {
            this.testNamedEntity(cl);
        }
        finally {
            cl.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOntObject() throws Exception {
        OntObject object = this.ont.createOntObject("test", new Object[0]);
        try {
            this.testNamedEntity(object);
        }
        finally {
            object.delete();
        }
    }

    protected static class MyNamedEntityListener
    implements NamedEntityListener {
        String oldName;
        String newName;

        public void reset() {
            this.oldName = null;
            this.newName = null;
        }

        @Override
        public void namedEntityRenamed(NamedEntityRenamedEvent event) {
            this.oldName = event.getOldName();
            this.newName = event.getNewName();
        }

        public String getOldName() {
            return this.oldName;
        }

        public String getNewName() {
            return this.newName;
        }
    }

    protected static class MyOntoListener
    implements OntoListener {
        String oldURI;
        String newURI;

        protected MyOntoListener() {
        }

        @Override
        public void ontologyCreated(OntologyEvent event) {
        }

        @Override
        public void ontologyRenamed(OntologyRenamedEvent event) {
            this.oldURI = event.getOldURI();
            this.newURI = event.getNewURI();
        }

        @Override
        public void ontologyDeleted(OntologyEvent event) {
        }

        public void reset() {
            this.oldURI = null;
            this.newURI = null;
        }

        public String getOldURI() {
            return this.oldURI;
        }

        public String getNewURI() {
            return this.newURI;
        }
    }
}

