/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.module.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.meta2project.module.ModuleLoader;

public class ChainModuleLoader
implements ModuleLoader {
    protected static Logger logger = Logger.getLogger(ChainModuleLoader.class.getName());
    private final List<ModuleLoader> loaders = new ArrayList<ModuleLoader>();

    public void addModuleLoader(ModuleLoader loader) {
        this.loaders.add(loader);
    }

    @Override
    public <T> List<T> getModules(Class<T> moduleClass) {
        ArrayList<T> modules = new ArrayList<T>();
        for (ModuleLoader loader : this.loaders) {
            List<T> m = loader.getModules(moduleClass);
            if (m == null) continue;
            for (T o : m) {
                modules.add(moduleClass.cast(o));
            }
        }
        return modules;
    }

    @Override
    public boolean remove(Object moduleObject) {
        for (ModuleLoader loader : this.loaders) {
            if (!loader.remove(moduleObject)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("<node title=\"\u0417\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a\u0438\">");
        for (ModuleLoader loader : this.loaders) {
            sb.append(loader.getInfo());
        }
        sb.append("</node>");
        return sb.toString();
    }
}

