/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.ontobox.client;

import com.teacode.swing.component.PreviewArea;
import java.util.Collection;
import org.meta2project.ontobox.client.ClientResult;
import org.meta2project.ontobox.client.Screen;

public class SimpleScreen
extends PreviewArea
implements Screen {
    private static final int LIMIT = 40;

    public SimpleScreen() {
        super("");
        this.setLineWrap(true);
        this.clear();
    }

    @Override
    public void clear() {
        this.setText("Ready\n");
    }

    private void addMessage(String message) {
        String t = this.getText();
        this.setText(t + message);
    }

    @Override
    public void connect(String query, String host) {
        this.addMessage('>' + query + '\n' + host + "...");
    }

    @Override
    public void done(long time, ClientResult result) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(" (").append(time).append(" ms)\n");
        int resultCount = 1;
        for (Collection<String> line : result.getResult()) {
            sb.append('#').append(resultCount).append(" (").append(line.size()).append("): ");
            int count = 0;
            for (String s : line) {
                sb.append(s);
                sb.append(' ');
                if (++count < 40) continue;
                sb.append("...and ").append(line.size() - 40).append(" more...");
                break;
            }
            sb.append('\n');
            ++resultCount;
        }
        sb.append('\n');
        this.addMessage(sb.toString());
    }

    @Override
    public void error(String error) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("\nError: ").append(error).append("\n\n");
        this.addMessage(sb.toString());
    }
}

