/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.box2model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.meta2project.model.Connection;
import org.meta2project.model.NamedEntity;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.Type;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.box.box2model.BoxOProperty;
import org.ontobox.box.box2model.BoxOntClass;
import org.ontobox.box.box2model.BoxOntObject;
import org.ontobox.box.box2model.BoxOntology;
import org.ontobox.box.box2model.BoxTProperty;
import org.ontobox.box.box2model.BoxType;
import org.ontobox.box.exception.NotFoundException;

public class BoxConnection
implements Connection {
    public BoxWorker worker;

    public BoxConnection(BoxWorker worker) {
        this.worker = worker;
    }

    @Override
    public Ontology getOntology(String uri) {
        return this.wrapOntology(this.worker.resolve(uri, Entity.ONTOLOGY));
    }

    @Override
    public Collection<Ontology> getOntologies() {
        return this.wrapOntologies(this.worker.ontologies());
    }

    @Override
    public boolean isClosed() {
        return this.worker == null;
    }

    @Override
    public void close() {
        this.worker.commit();
        this.worker.close();
        this.worker = null;
    }

    @Override
    public void closeRollback() {
        this.worker.close();
        this.worker = null;
    }

    @Override
    public OntClass getOntClassByFullName(String fullName) {
        return this.wrapOntClass(this.worker.resolve(fullName, Entity.ONTCLASS));
    }

    @Override
    public OProperty getOPropertyByFullName(String fullName) {
        return this.wrapOProperty(this.worker.resolve(fullName, Entity.OPROPERTY));
    }

    @Override
    public TProperty getTPropertyByFullName(String fullName) {
        return this.wrapTProperty(this.worker.resolve(fullName, Entity.TPROPERTY));
    }

    @Override
    public OntObject getOntObjectByFullName(String fullName) {
        return this.wrapOntObject(this.worker.resolve(fullName, Entity.ONTOBJECT));
    }

    @Override
    public Type getTypeByFullName(String fullName) {
        return this.wrapType(this.worker.resolve(fullName, Entity.TYPE));
    }

    @Override
    public NamedEntity getEntity(String fullName) {
        try {
            return this.getOntObjectByFullName(fullName);
        }
        catch (NotFoundException e) {
            try {
                return this.getOntClassByFullName(fullName);
            }
            catch (NotFoundException e2) {
                try {
                    return this.getTPropertyByFullName(fullName);
                }
                catch (NotFoundException e3) {
                    try {
                        return this.getOPropertyByFullName(fullName);
                    }
                    catch (NotFoundException e4) {
                        try {
                            return this.getTypeByFullName(fullName);
                        }
                        catch (NotFoundException notFoundException) {
                            return null;
                        }
                    }
                }
            }
        }
    }

    @Override
    public Ontology createOntology(String uri) {
        int id = this.worker.write().newOntology(uri);
        return new BoxOntology(this, id);
    }

    @Override
    public BoxWorker getWorker() {
        return this.worker;
    }

    final Ontology wrapOntology(int uri) {
        return new BoxOntology(this, uri);
    }

    final Collection<Ontology> wrapOntologies(int[] uris) {
        ArrayList<Ontology> ret = new ArrayList<Ontology>(uris.length);
        for (int uri : uris) {
            ret.add(this.wrapOntology(uri));
        }
        return ret;
    }

    final OntClass wrapOntClass(Integer name) {
        if (name == null) {
            return null;
        }
        return new BoxOntClass(this, name);
    }

    final Collection<OntClass> wrapOntClasses(int[] names) {
        ArrayList<OntClass> ret = new ArrayList<OntClass>(names.length);
        for (int name : names) {
            ret.add(this.wrapOntClass(name));
        }
        return ret;
    }

    final OntObject wrapOntObject(int name) {
        return new BoxOntObject(this, name);
    }

    final List<OntObject> wrapOntObjects(int[] names) {
        ArrayList<OntObject> ret = new ArrayList<OntObject>(names.length);
        for (int name : names) {
            ret.add(this.wrapOntObject(name));
        }
        return ret;
    }

    final OProperty wrapOProperty(int name) {
        return new BoxOProperty(this, name);
    }

    final BoxTProperty wrapTProperty(int name) {
        return new BoxTProperty(this, name);
    }

    final Collection<OProperty> wrapOProperties(int[] properties) {
        ArrayList<OProperty> ret = new ArrayList<OProperty>(properties.length);
        for (int property : properties) {
            ret.add(this.wrapOProperty(property));
        }
        return ret;
    }

    final Collection<TProperty> wrapTProperties(int[] properties) {
        ArrayList<TProperty> ret = new ArrayList<TProperty>(properties.length);
        for (int property : properties) {
            ret.add(this.wrapTProperty(property));
        }
        return ret;
    }

    final Type wrapType(Integer fn) {
        if (fn == null) {
            return null;
        }
        return new BoxType(this, fn);
    }

    final List<Type> wrapTypes(int[] types) {
        ArrayList<Type> ret = new ArrayList<Type>(types.length);
        for (int type : types) {
            ret.add(this.wrapType(type));
        }
        return ret;
    }

    static boolean contains(int[] ids, int id) {
        for (int i : ids) {
            if (i != id) continue;
            return true;
        }
        return false;
    }
}

