/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.box2model;

import java.util.List;
import org.meta2project.model.impl.DefaultListenerManager;
import org.ontobox.box.BoxEventListener;
import org.ontobox.box.BoxListenerManager;
import org.ontobox.box.event.BoxEvent;
import org.ontobox.box.event.CreateClassEvent;
import org.ontobox.box.event.CreateOPropertyEvent;
import org.ontobox.box.event.CreateObjectEvent;
import org.ontobox.box.event.CreateOntologyEvent;
import org.ontobox.box.event.CreateTPropertyEvent;
import org.ontobox.box.event.DeleteClassEvent;
import org.ontobox.box.event.DeleteOPropertyEvent;
import org.ontobox.box.event.DeleteObjectEvent;
import org.ontobox.box.event.DeleteOntologyEvent;
import org.ontobox.box.event.DeleteTPropertyEvent;
import org.ontobox.box.event.SetNameEvent;
import org.ontobox.box.event.SetURIEvent;
import org.ontobox.box.helper.NameHelper;
import org.ontobox.box.helper.SplittedName;

public class BoxListenerAdapter
extends DefaultListenerManager
implements BoxEventListener {
    private final BoxListenerManager listener;

    public BoxListenerAdapter(BoxListenerManager listener) {
        this.listener = listener;
        listener.addActionListener(this);
    }

    @Override
    public void process(List<BoxEvent> events) {
        for (BoxEvent event : events) {
            this.processAction(event);
        }
    }

    public void close() {
        this.listener.removeActionListener(this);
    }

    void processAction(BoxEvent action) {
        if (action instanceof CreateOntologyEvent) {
            this.fireOntologyCreate(((CreateOntologyEvent)action).getURI());
        } else if (action instanceof DeleteOntologyEvent) {
            this.fireOntologyDeleted(((DeleteOntologyEvent)action).getURI());
        } else if (action instanceof CreateObjectEvent) {
            String fullName = ((CreateObjectEvent)action).getObjectName();
            SplittedName data = NameHelper.splitName(fullName);
            this.fireOntObjectCreated(data.ontology(), data.local());
        } else if (action instanceof DeleteObjectEvent) {
            String fullName = ((DeleteObjectEvent)action).getObjectName();
            SplittedName data = NameHelper.splitName(fullName);
            this.fireOntObjectDeleted(data.ontology(), data.local());
        } else if (action instanceof CreateClassEvent) {
            String fullName = ((CreateClassEvent)action).getClassName();
            SplittedName data = NameHelper.splitName(fullName);
            this.fireOntClassCreated(data.ontology(), data.local());
        } else if (action instanceof DeleteClassEvent) {
            SplittedName data = NameHelper.splitName(((DeleteClassEvent)action).getClassName());
            this.fireOntClassDeleted(data.ontology(), data.local());
        } else if (action instanceof CreateTPropertyEvent) {
            String fullName = ((CreateTPropertyEvent)action).getPropertyName();
            SplittedName data = NameHelper.splitName(fullName);
            this.fireTPropertyCreated(data.ontology(), data.local());
        } else if (action instanceof DeleteTPropertyEvent) {
            SplittedName data = NameHelper.splitName(((DeleteTPropertyEvent)action).getPropertyName());
            this.fireTPropertyDeleted(data.ontology(), data.local());
        } else if (action instanceof CreateOPropertyEvent) {
            String fullName = ((CreateOPropertyEvent)action).getPropertyName();
            SplittedName data = NameHelper.splitName(fullName);
            this.fireOPropertyCreated(data.ontology(), data.local());
        } else if (action instanceof DeleteOPropertyEvent) {
            SplittedName data = NameHelper.splitName(((DeleteOPropertyEvent)action).getPropertyName());
            this.fireOPropertyDeleted(data.ontology(), data.local());
        } else if (action instanceof SetNameEvent) {
            SetNameEvent s = (SetNameEvent)action;
            SplittedName data = NameHelper.splitName(s.getOldName());
            SplittedName data2 = NameHelper.splitName(s.getNewName());
            this.fireNamedEntityRenamed(data.ontology(), data.local(), data2.local());
        } else if (action instanceof SetURIEvent) {
            SetURIEvent u = (SetURIEvent)action;
            this.fireOntologyRenamed(u.getOldURI(), u.getNewURI());
        }
    }
}

