/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.helper;

import java.util.ArrayList;
import java.util.Collections;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.RHelper;
import org.ontobox.box.helper.SortMode;

public class Sorter {
    public static int[] sortTyped(int[] objects, SortMode mode, ValueGenerator generator) {
        ArrayList<ObjectValue<Comparable>> r = new ArrayList<ObjectValue<Comparable>>(objects.length);
        for (int n : objects) {
            r.add(new ObjectValue<Comparable>(n, generator.value(n)));
        }
        if (mode == SortMode.ASC) {
            Collections.sort(r);
        } else {
            Collections.sort(r, Collections.reverseOrder());
        }
        int[] ret = new int[r.size()];
        int a = 0;
        for (ObjectValue objectValue : r) {
            ret[a++] = objectValue.object;
        }
        return ret;
    }

    public static int[] sort(final BoxWorker worker, int[] objects, SortMode mode, final int tprop) {
        String rangeName;
        Integer range = worker.range(tprop);
        if (range != null && (rangeName = worker.name(range)).equals("http://ontobox.org/#int")) {
            return Sorter.sortTyped(objects, mode, new ValueGenerator(){

                @Override
                public Comparable value(int objectId) {
                    return RHelper.intValue(worker, objectId, tprop);
                }
            });
        }
        return Sorter.sortTyped(objects, mode, new ValueGenerator(){

            @Override
            public Comparable value(int objectId) {
                return RHelper.stringValue(worker, objectId, tprop);
            }
        });
    }

    public static int[] sortIgnoreCase(final BoxWorker worker, int[] objects, SortMode mode, final int tprop) {
        String rangeName;
        Integer range = worker.range(tprop);
        if (range != null && (rangeName = worker.name(range)).equals("http://ontobox.org/#int")) {
            return Sorter.sortTyped(objects, mode, new ValueGenerator(){

                @Override
                public Comparable value(int objectId) {
                    return RHelper.intValue(worker, objectId, tprop);
                }
            });
        }
        return Sorter.sortTyped(objects, mode, new ValueGenerator(){

            @Override
            public Comparable value(int objectId) {
                return RHelper.stringValue(worker, objectId, tprop).toLowerCase();
            }
        });
    }

    private static class ObjectValue<T extends Comparable>
    implements Comparable<ObjectValue<T>> {
        private int object;
        private final T value;

        public ObjectValue(int object, T value) {
            this.object = object;
            this.value = value;
        }

        @Override
        public int compareTo(ObjectValue<T> o) {
            T v1 = this.value;
            T v2 = o.value;
            if (v1 == null) {
                if (v2 == null) {
                    return 0;
                }
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            return v1.compareTo(v2);
        }

        public boolean equals(Object obj) {
            return this.compareTo((ObjectValue)obj) == 0;
        }
    }

    public static interface ValueGenerator {
        public Comparable value(int var1);
    }
}

