/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.exchange.mvx.xml;

import java.io.InputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLPullParser {
    private XMLStreamReader parser;

    public XMLPullParser(InputStream in) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        this.parser = factory.createXMLStreamReader(in);
    }

    public String parseElementContent(String tag) throws Exception {
        this.startTag(tag);
        return this.endTagDirect(tag);
    }

    public String getPosition() {
        Location location = this.parser.getLocation();
        if (location == null) {
            return "<unknown location>";
        }
        return "Line: " + location.getLineNumber() + ", column: " + location.getColumnNumber();
    }

    public void startTag(String tag) throws Exception {
        while (true) {
            switch (this.parser.next()) {
                case 1: {
                    if (this.parser.getLocalName().equals(tag)) {
                        return;
                    }
                }
                case 2: 
                case 8: {
                    throw new IllegalStateException("Missing expected start tag " + tag);
                }
            }
        }
    }

    public void startTag(String tag, String tag2) throws Exception {
        while (true) {
            switch (this.parser.next()) {
                case 1: {
                    String localName = this.parser.getLocalName();
                    if (localName.equals(tag) || localName.equals(tag2)) {
                        return;
                    }
                }
                case 2: 
                case 8: {
                    throw new IllegalStateException("Missing expected start tag " + tag);
                }
            }
        }
    }

    public String startAnyTag(String endTag) throws Exception {
        while (true) {
            switch (this.parser.next()) {
                case 1: {
                    return this.parser.getLocalName();
                }
                case 2: {
                    if (this.parser.getLocalName().equals(endTag)) {
                        return null;
                    }
                    throw new IllegalStateException("Missing expected end tag " + endTag);
                }
                case 8: {
                    throw new IllegalStateException("Missing expected end tag " + endTag);
                }
            }
        }
    }

    public String startAnyTag(String endTag, String endTag2) throws Exception {
        while (true) {
            switch (this.parser.next()) {
                case 1: {
                    return this.parser.getLocalName();
                }
                case 2: {
                    String localName = this.parser.getLocalName();
                    if (localName.equals(endTag) || localName.equals(endTag2)) {
                        return null;
                    }
                    throw new IllegalStateException("Missing expected end tag " + endTag);
                }
                case 8: {
                    throw new IllegalStateException("Missing expected end tag " + endTag);
                }
            }
        }
    }

    public void endTag(String endTag) throws Exception {
        String tag;
        while ((tag = this.startAnyTag(endTag)) != null) {
            this.endTag(tag);
        }
    }

    public String endTagDirect(String tag) throws Exception {
        String text = null;
        while (true) {
            switch (this.parser.next()) {
                case 4: {
                    text = this.parser.getText().trim();
                    break;
                }
                case 2: {
                    if (this.parser.getLocalName().equals(tag)) {
                        return text;
                    }
                }
                case 1: 
                case 8: {
                    throw new IllegalStateException("Missing expected end tag " + tag);
                }
            }
        }
    }

    public String getAttribute(String name) throws Exception {
        String value = this.parser.getAttributeValue(null, name);
        if (value == null) {
            throw new IllegalStateException("Missing attribute " + name);
        }
        return value;
    }

    public String getAttribute(String name, String defValue) {
        String value = this.parser.getAttributeValue(null, name);
        if (value == null) {
            return defValue;
        }
        return value;
    }
}

