/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import java.util.HashMap;
import org.ontobox.box.Entity;
import org.ontobox.box.event.SetAnnotationEvent;
import org.ontobox.box.exception.NotFoundException;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.AnnoNameVerifier;
import org.ontobox.fast.util.mapmany.BMapInt;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;

public class SetAnnotation
implements WriteAction,
SetAnnotationEvent {
    private final String name;
    private final String annoName;
    private final String annoValue;
    private String oldAnnoValue;

    public SetAnnotation(String[] data) {
        this(data[0], data[1], data.length > 2 ? data[2] : "");
    }

    public SetAnnotation(String name, String annoName, String annoValue) {
        this.name = name;
        this.annoName = AnnoNameVerifier.getNewName(annoName);
        this.annoValue = annoValue;
    }

    @Override
    public final void preverify(Storage storage) {
        Integer id = storage.id(this.name);
        if (id == null) {
            throw new NotFoundException("entity", this.name);
        }
        if (this.annoName == null) {
            throw new IllegalArgumentException("annotation name is null");
        }
        Storage.verifyAnnoName(this.annoName);
        if (this.annoName.equals("http://ontobox.org/#maxcard") && this.annoValue != null) {
            int card = Integer.parseInt(this.annoValue);
            Entity type = storage.getType(id);
            if (type == Entity.TPROPERTY) {
                BMapInt tints;
                if (storage.useCard && (tints = storage.getValueMap(id)) != null) {
                    for (int i : tints.keys()) {
                        int size = tints.getDirectSize(i);
                        if (size <= card) continue;
                        throw new IllegalArgumentException("Property " + this.name + " has more than " + card + " integer values (" + size + ")");
                    }
                }
            } else if (type == Entity.OPROPERTY) {
                BMapIntIntLazy ovals;
                if (storage.useCard && (ovals = (BMapIntIntLazy)storage.ovalues.get(id.intValue())) != null) {
                    for (int i : ovals.keys()) {
                        int size = ovals.getDirect(i).size();
                        if (size <= card) continue;
                        throw new IllegalArgumentException("Property " + this.name + " has more than " + card + " object values (" + size + ")");
                    }
                }
            } else {
                throw new IllegalArgumentException("Cardinality can be set only for properties (" + (Object)((Object)type) + ")");
            }
        }
    }

    @Override
    public final void doAction(Storage storage) {
        int id = storage.id(this.name);
        HashMap<String, String> anno = (HashMap<String, String>)storage.annotations.get(id);
        if (anno == null) {
            anno = new HashMap<String, String>();
            storage.annotations.put(id, anno);
        }
        this.oldAnnoValue = (String)anno.get(this.annoName);
        if (this.annoValue == null) {
            anno.remove(this.annoName);
        } else {
            anno.put(this.annoName, this.annoValue);
        }
        if (this.annoName.equals("http://ontobox.org/#maxcard")) {
            if (this.annoValue != null) {
                storage.propMaxCard.put(id, Integer.parseInt(this.annoValue));
            } else {
                storage.propMaxCard.removeKey(id);
            }
        }
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name, this.annoName, this.annoValue};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new SetAnnotation(this.name, this.annoName, this.oldAnnoValue);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getAnnoName() {
        return this.annoName;
    }

    @Override
    public final String getAnnoValue() {
        return this.annoValue;
    }

    @Override
    public final String getOldAnnoValue() {
        return this.oldAnnoValue;
    }
}

