/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.box;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.ontobox.box.BoxEventListener;
import org.ontobox.box.base.BaseBoxListenerManager;
import org.ontobox.box.event.BoxEvent;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.event.ActionListener;
import org.ontobox.fast.queue.ActionsQueue;
import org.ontobox.fast.queue.QueueProcessor;

public class FastListenerManager
extends BaseBoxListenerManager
implements ActionListener {
    private static Logger logger = Logger.getLogger(FastListenerManager.class.getName());
    private final ActionsQueue actionsQueue = new ActionsQueue(new QueueProcessor(){
        private final List<BoxEvent> events = new ArrayList<BoxEvent>();

        @Override
        public void process(WriteAction action) throws Exception {
            if (action instanceof BoxEvent) {
                this.events.add((BoxEvent)((Object)action));
            } else {
                logger.warning("Unsupported action: " + action.getClass());
            }
        }

        @Override
        public void flush() throws Exception {
            if (!this.events.isEmpty()) {
                for (BoxEventListener eventListener : FastListenerManager.this.eventListeners) {
                    eventListener.process(this.events);
                }
            }
            this.events.clear();
        }

        @Override
        public void close() {
        }
    }, "event listener");

    public final void close() {
        this.actionsQueue.close();
    }

    @Override
    public void actionsExecuted(List<WriteAction> actions) {
        this.actionsQueue.putActions(actions);
    }
}

