/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.filebox;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.ontobox.box.BoxClient;
import org.ontobox.box.BoxListenerManager;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.base.BaseBox;
import org.ontobox.box.helper.WHelper;
import org.ontobox.filebox.FileWorker;
import org.ontobox.storage.StorageBox;

public class FileBox
extends BaseBox {
    public static final String ONT = "http://filebox.ontobox.org/";
    protected final StorageBox storage = new StorageBox();
    public static final String RESOURCE_CLASS = "http://filebox.ontobox.org/#Resource";
    private static final String NAME_PROP = "http://filebox.ontobox.org/#name";
    private static final String FULL_NAME_PROP = "http://filebox.ontobox.org/#fullName";
    private static final String FILE_CLASS = "http://filebox.ontobox.org/#File";
    private static final String DIR_CLASS = "http://filebox.ontobox.org/#Dir";
    public static final String LIST_PROP = "http://filebox.ontobox.org/#list";
    private static final String ROOT_CLASS = "http://filebox.ontobox.org/#Root";
    public Map<String, File> roots = new HashMap<String, File>();

    public FileBox() {
        this.storage.client(new BoxClient<Object>(){

            @Override
            public Object process(BoxWorker worker) throws Exception {
                BoxWriter writer = worker.write();
                int o = writer.newOntology(FileBox.ONT);
                WHelper.ontclass(worker, FileBox.RESOURCE_CLASS).tprop(FileBox.NAME_PROP, 1).tprop(FileBox.FULL_NAME_PROP, 1);
                WHelper.ontclass(worker, FileBox.FILE_CLASS).subclassof(FileBox.RESOURCE_CLASS);
                WHelper.ontclass(worker, FileBox.DIR_CLASS).subclassof(FileBox.RESOURCE_CLASS).oprop(FileBox.LIST_PROP, FileBox.RESOURCE_CLASS, null);
                WHelper.ontclass(worker, FileBox.ROOT_CLASS).subclassof(FileBox.DIR_CLASS);
                for (File r : File.listRoots()) {
                    String d = r.getAbsolutePath();
                    System.out.println("root found: " + d);
                    if (d.endsWith(":\\")) {
                        d = d.substring(0, d.length() - 2);
                    } else if (d.equals("/")) {
                        d = "root";
                    }
                    String ont = FileBox.ONT + FileBox.encodePath(d.toLowerCase());
                    System.out.println("\t" + ont);
                    writer.newOntology(ont);
                    String rootName = ont + "#root";
                    WHelper.object(worker, rootName, FileBox.ROOT_CLASS);
                    FileBox.this.roots.put(rootName, r);
                }
                return null;
            }
        });
    }

    protected static int makeFile(BoxWorker worker, File file, int ont) {
        String name = worker.name(ont) + "#" + FileBox.encodePath(file.getAbsolutePath());
        if (file.isDirectory()) {
            return WHelper.object(worker, name, DIR_CLASS).id();
        }
        if (file.isFile()) {
            return WHelper.object(worker, name, FILE_CLASS).id();
        }
        throw new IllegalArgumentException("Unknown file type " + file);
    }

    protected static String encodePath(String path) {
        try {
            return URLEncoder.encode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String decodePath(String name) {
        try {
            return URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BoxWorker work() {
        return this.workRO();
    }

    @Override
    public BoxWorker workRO() {
        return new FileWorker(this, this.storage.work());
    }

    @Override
    public BoxWorker workAutocommit() {
        throw new UnsupportedOperationException("Autocommit is not supported");
    }

    @Override
    public void close() {
        this.storage.close();
    }

    @Override
    public BoxListenerManager getListenerManager() {
        throw new UnsupportedOperationException("Listeners are not supported");
    }
}

