/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto;

import com.teacode.exception.ExUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.meta2project.model.AnnotatedEntity;
import org.meta2project.model.NamedEntity;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.box2model.BoxConnection;
import org.ontobox.exchange.MVX;
import org.ontobox.libretto.ExceptionPass;
import org.ontobox.libretto.Interp;
import org.ontobox.libretto.LibrettoEnv;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.Modifier;
import org.ontobox.libretto.adapter.NamedEntityId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.debug.Debug;
import org.ontobox.libretto.function.BaseFuncs;
import org.ontobox.libretto.function.DateFuncs;
import org.ontobox.libretto.function.JavaFuncs;
import org.ontobox.libretto.function.LibrettoFunction;
import org.ontobox.libretto.function.ModelFuncs;
import org.ontobox.libretto.function.StringFuncs;
import org.ontobox.libretto.function.XMLFuncs;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.helper.Helper;
import org.ontobox.libretto.parser.Box2Libretto;
import org.ontobox.libretto.parser.FunctionTable;
import org.ontobox.libretto.parser.LQuery;
import org.ontobox.libretto.parser.Parser;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;
import org.ontobox.libretto.parser.sql.SQLParser;
import org.ontobox.play.libretto.PlayFuncs;

public class Handler {
    public static boolean DEBUG = false;
    public static boolean ALL_DEFAULT = false;
    static long count = 0L;
    PrintWriter printer = new PrintWriter(System.out);
    private Map<String, String> mapping = new HashMap<String, String>();
    private final FunctionTable functions;
    public TimeZone defaultTZ = new SimpleTimeZone(0, "UTC");
    public final Map<String, TimeZone> timeZones = new HashMap<String, TimeZone>();
    public boolean onlynamespaces = false;
    public int specialVarsBase;
    public int specialVarsNumber;
    public int indexVarNumber;
    public int matchVarNumber;
    public int thisVarNumber;
    public int prevVarNumber;
    public int localVar;
    public StringBuilder progtext;
    public Boolean stop = false;
    public LibrettoEnv librettoEnv = new LibrettoEnv();
    private static final CollectionConverter directConverter = new DirectConverter();

    public static void check() {
        ++count;
    }

    public Handler() {
        this.functions = new FunctionTable();
        new BaseFuncs().init(this.functions);
        ModelFuncs.init(this.functions);
        DateFuncs.init(this.functions);
        StringFuncs.init(this.functions);
        XMLFuncs.init(this.functions);
        JavaFuncs.init(this.functions);
        try {
            Class.forName("play.Play");
            PlayFuncs.init(this.functions);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.mapping.put("v", "http://ontobox.org/");
        this.mapping.put("map", "http://ontobox.org/map");
        this.mapping.put("java", "org.ontobox.java");
    }

    public Handler(Handler base) {
        this.functions = new FunctionTable(base.functions);
        this.mapping.putAll(base.mapping);
    }

    public final Map<String, String> getMapping() {
        return this.mapping;
    }

    public final void replaceMappedOntology(String oldOntology, String newOntology) {
        if (oldOntology.equals(newOntology)) {
            return;
        }
        List<String> prefixes = this.getPrefixesByURI(oldOntology);
        for (String prefix : prefixes) {
            this.mapping.put(prefix, newOntology);
        }
    }

    public final Map<String, String> setNewMapping() {
        Map<String, String> m = this.mapping;
        this.mapping = new HashMap<String, String>();
        this.mapping.put("v", "http://ontobox.org/");
        this.mapping.put("map", "http://ontobox.org/map");
        return m;
    }

    public void setMapping(Map<String, String> m) {
        this.mapping = m;
    }

    public FunctionTable getFunctions() {
        return this.functions;
    }

    public synchronized void putUriInMap(String pr, String uri) {
        this.getMapping().put(pr, uri);
    }

    public synchronized String getUriByPrefix(String pr) {
        String uri;
        if (pr == null) {
            pr = "";
        }
        if ((uri = this.getMapping().get(pr)) == null) {
            if (pr.isEmpty()) {
                throw new RuntimeException("Failed to find the default ontology");
            }
            throw new RuntimeException("Failed to find ontology with prefix '" + pr + "'");
        }
        return uri;
    }

    public synchronized String getPrefixByURI(String uri) {
        for (Map.Entry<String, String> entry : this.getMapping().entrySet()) {
            if (!entry.getValue().equals(uri)) continue;
            return entry.getKey();
        }
        return null;
    }

    public synchronized List<String> getPrefixesByURI(String uri) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.mapping.entrySet()) {
            if (!entry.getValue().equals(uri)) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    public final Collection<Collection> execute(LocalContext lc, String query) {
        if (query == null) {
            throw new IllegalArgumentException("The input query is null in execute(String)");
        }
        return this.execute(lc, new StringReader(query));
    }

    public final Collection<Collection> executeOld(LocalContext lc, String query) {
        if (query == null) {
            throw new IllegalArgumentException("The input query is null in execute(String)");
        }
        return this.executeOld(lc, new StringReader(query));
    }

    public final Collection<Collection> execute(LocalContext lc, Reader reader) {
        CharStream in = CharStream.createCharStream();
        this.progtext = new StringBuilder();
        in.setExtbuffer(this.progtext);
        in.rewindCharStream(reader);
        Token program = new Token(TokenType.PROGRAM, 0, in);
        Collection<Collection> col = this.getProgram(lc, in, true, program);
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return col;
    }

    public final Collection<Collection> execute(Token program, LocalContext lc, CharStream in) {
        Collection<Collection> col = this.getProgram(lc, in, true, program);
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return col;
    }

    public final Collection<Collection> executeOld(LocalContext lc, Reader reader) {
        CharStream in = CharStream.createCharStream();
        in.rewindCharStream(reader);
        Token program = new Token(TokenType.PROGRAM, 0, in);
        Collection<Collection> col = this.getProgramOld(lc, in, true, program);
        try {
            reader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return col;
    }

    public final void load(LocalContext lc, Reader preader) {
        CharStream in = CharStream.createCharStream();
        in.rewindCharStream(preader);
        Token program = new Token(TokenType.PROGRAM, 0, in);
        this.getProgram(lc, in, false, program);
    }

    public final void load(LocalContext lc, String prog) {
        if (prog == null) {
            throw new IllegalArgumentException("The input query is null in execute(String)");
        }
        this.load(lc, new StringReader(prog));
    }

    public final Collection query(LocalContext lc, String query) {
        if (query == null) {
            throw new IllegalArgumentException("The input string is null");
        }
        Parser parser = lc.getParser();
        parser.resetQuestionVarNum();
        CharStream in = CharStream.createCharStream();
        in.rewindString(query);
        parser.reset(in);
        Token program = new Token(TokenType.PROGRAM, 0, in);
        Sequence qseq = program.getSeq();
        Token instruction = parser.getQuery(qseq, null);
        OntCollection res = lc.getInterp().computePath(instruction);
        return LQuery.convertTokens(lc, res);
    }

    public final synchronized void setPrefix(String prefix, String uri) {
        this.putUriInMap(prefix, uri);
    }

    public final void exportProject(LocalContext lc, File file) {
        try {
            MVX.exportFile(file, lc.getWorker());
        }
        catch (Exception e) {
            throw new RuntimeException("Project " + file.getPath() + " save fails: " + e.getMessage(), e);
        }
    }

    public static void sql2path(Reader reader, Writer writer, String ontology) {
        CharStream input = CharStream.createCharStream();
        input.rewindCharStream(reader);
        SQLParser sqlparser = new SQLParser(input);
        sqlparser.sql2path(writer, ontology);
    }

    public final void sql2ontobox(BoxWorker worker, Reader reader, String ontology) {
        CharStream input = CharStream.createCharStream();
        try {
            input.rewindCharStream(reader);
            SQLParser sqlparser = new SQLParser(input);
            sqlparser.sql2ontobox(ontology, new BoxConnection(worker));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage() + " (" + input.getPosition() + ')', e);
        }
    }

    public final void box2libretto(BoxWorker worker, Writer w) {
        new Box2Libretto(worker).generate(w, false);
    }

    public final LQuery createQuery(LocalContext lc, String query) {
        Parser parser = lc.getParser();
        parser.resetQuestionVarNum();
        return new LQuery(parser, lc.getInterp(), query);
    }

    public final LQuery createQuery(LocalContext lc, CharStream in) {
        Parser parser = lc.getParser();
        parser.resetQuestionVarNum();
        return new LQuery(parser, lc.getInterp(), in);
    }

    private Collection<Collection> getProgram(LocalContext lc, CharStream in, boolean compute, Token program) {
        return this.getProgram(lc, in, compute, program, directConverter);
    }

    private Collection<Collection> getProgramOld(final LocalContext lc, CharStream in, boolean compute, Token program) {
        return this.getProgram(lc, in, compute, program, new CollectionConverter(){
            final BoxWorker worker;
            final BoxConnection con;
            {
                this.worker = lc.getWorker();
                this.con = new BoxConnection(this.worker);
            }

            @Override
            public Collection convertCollection(Collection collection) {
                if (collection == null) {
                    return null;
                }
                ArrayList<NamedEntity> ret = new ArrayList<NamedEntity>(collection.size());
                for (Object o : collection) {
                    AnnotatedEntity ne;
                    if (o instanceof NamedEntityId) {
                        String fn = this.worker.name(((NamedEntityId)o).id());
                        ne = null;
                        if (fn != null) {
                            ne = this.con.getEntity(fn);
                        }
                        ret.add((NamedEntity)ne);
                        continue;
                    }
                    if (o instanceof OntologyId) {
                        String uri = this.worker.name(((OntologyId)o).id());
                        ne = null;
                        if (uri != null) {
                            ne = this.con.getOntology(uri);
                        }
                        ret.add((NamedEntity)ne);
                        continue;
                    }
                    ret.add((NamedEntity)o);
                }
                return ret;
            }
        });
    }

    private Collection<Collection> getProgram(LocalContext lc, CharStream in, boolean compute, Token program, CollectionConverter conv) {
        ArrayList<Collection> ret = new ArrayList<Collection>();
        try {
            Parser parser = lc.getParser();
            Interp interp = lc.getInterp();
            Modifier modifier = lc.getModifier();
            parser.reset(in);
            Sequence qseq = program.getSeq();
            int count = 0;
            OntCollection res = null;
            this.stop = false;
            while (!parser.isEOF() && !this.stop.booleanValue()) {
                Token instruction;
                parser.resetQuestionVarNum();
                if (count >= 49) {
                    ++count;
                }
                if (parser.isPrefixKw()) {
                    parser.modifyPrefix(qseq);
                } else if (parser.isOntologyKw()) {
                    parser.modifyOntology(qseq);
                } else if (parser.isRequireKw()) {
                    parser.getRequire(qseq);
                } else if (parser.isClassKw()) {
                    instruction = parser.getClassModifier(qseq);
                } else if (parser.isQueryKw()) {
                    instruction = parser.getQuery(qseq, null);
                    if (this.onlynamespaces && (instruction = Helper.getNakedObjectCreater(instruction)) == null || !compute) continue;
                    res = interp.computePath(instruction);
                } else if (parser.isFunctionDeclarationKw()) {
                    int startpos = parser.filePosition - 1;
                    instruction = parser.getFunctionDeclaration(qseq, null, "def");
                    int endpos = parser.filePosition - 1;
                    int length = endpos - startpos;
                    char[] code = new char[length];
                    if (startpos < 0) {
                        startpos = 0;
                    }
                    this.progtext.getChars(startpos, endpos, code, 0);
                    Token head = instruction.getSub(0);
                    String name = head.getName();
                    String uri = lc.getTokenURI(head);
                    int arity = head.getSeq().size();
                } else {
                    instruction = parser.getQuery(qseq, null);
                    if (this.onlynamespaces && (instruction = Helper.getNakedObjectCreater(instruction)) == null || !compute) continue;
                    res = interp.computePath(instruction);
                }
                ++count;
                ret.add(conv.convertCollection(res));
                res = null;
            }
            Debug.progseq = qseq;
            return ret;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && ExceptionPass.isPassed(e)) {
                throw (RuntimeException)e;
            }
            int count = 1;
            for (Collection col : ret) {
                System.out.print(count + ":: ");
                System.out.println(col);
                ++count;
            }
            throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException(e.getMessage() + " (" + in.getPosition() + ')'), (Throwable)e);
        }
    }

    public synchronized void addBuiltin(LibrettoFunction bf) {
        this.functions.pushFunction(bf);
    }

    public void setPrintWriter(PrintWriter printer) {
        this.printer = printer;
    }

    public PrintWriter getPrintWriter() {
        return this.printer;
    }

    private static class DirectConverter
    implements CollectionConverter {
        private DirectConverter() {
        }

        @Override
        public Collection convertCollection(Collection collection) {
            return collection;
        }
    }

    private static interface CollectionConverter {
        public Collection convertCollection(Collection var1);
    }
}

