/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.ontobox.box.BoxWorker;
import org.ontobox.libretto.Handler;
import org.ontobox.libretto.ObjectContainer;
import org.ontobox.libretto.adapter.NamedEntityId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.collection.CollectionType;
import org.ontobox.libretto.collection.OntCollection;

class SimpleCol
implements OntCollection {
    private final List<Object> list;
    private CollectionType type;

    SimpleCol() {
        this.type = CollectionType.UNDEF_COL;
        this.list = new ArrayList<Object>(100);
    }

    SimpleCol(CollectionType type) {
        this.type = type;
        this.list = new ArrayList<Object>(100);
    }

    SimpleCol(CollectionType type, int initCapacity) {
        this.type = type;
        this.list = new ArrayList<Object>(initCapacity);
    }

    SimpleCol(Collection c) {
        this.list = new ArrayList<Object>(c.size());
        this.type = CollectionType.UNDEF_COL;
        for (Object o : c) {
            if (o instanceof ObjectId) {
                this.setType(CollectionType.OBJECT_COL);
            } else {
                this.setType(CollectionType.DATA_COL);
            }
            this.add(o);
        }
    }

    public SimpleCol(BoxWorker worker, int[] ids) {
        this.list = new ArrayList<Object>(ids.length);
        this.type = CollectionType.UNDEF_COL;
        this.addObjects(worker, ids);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(BoxWorker worker) {
        StringBuilder sb = new StringBuilder(100);
        sb.append('(');
        Iterator<Object> it = this.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if ((o = ObjectContainer.getObject(o)) instanceof NamedEntityId) {
                int id = ((NamedEntityId)o).id();
                if (worker == null) {
                    sb.append(id).append('^').append(o.getClass().getSimpleName());
                } else {
                    sb.append(worker.name(id));
                    if (!(o instanceof ObjectId)) {
                        sb.append('<').append(o.getClass().getSimpleName()).append('>');
                    }
                }
            } else if (o instanceof String) {
                sb.append('\"').append(o).append('\"');
            } else {
                sb.append(o.toString());
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public final void setType(CollectionType tp) {
        if (this.type == CollectionType.UNDEF_COL) {
            this.type = tp;
        } else if (tp != this.type) {
            throw new RuntimeException("The types of the collection elements are different (trying to change " + (Object)((Object)this.type) + " to " + (Object)((Object)tp) + ')');
        }
    }

    @Override
    public boolean isUndefCol() {
        return this.type == CollectionType.UNDEF_COL;
    }

    @Override
    public boolean isDataCol() {
        return this.type == CollectionType.DATA_COL;
    }

    @Override
    public boolean isObjCol() {
        return this.type == CollectionType.OBJECT_COL;
    }

    private void addTyped(Object obj) {
        Object e = ObjectContainer.getObject(obj);
        if (e == null) {
            return;
        }
        if (obj.equals(Boolean.FALSE)) {
            return;
        }
        if (e instanceof ObjectId) {
            this.setType(CollectionType.OBJECT_COL);
        } else {
            this.setType(CollectionType.DATA_COL);
        }
        this.add(obj);
        if (this.size() > 100) {
            Handler.check();
        }
    }

    private void addTyped(Object obj, int index) {
        Object e = ObjectContainer.getObject(obj);
        if (e == null) {
            return;
        }
        if (obj.equals(Boolean.FALSE)) {
            return;
        }
        if (e instanceof ObjectId) {
            this.setType(CollectionType.OBJECT_COL);
        } else {
            this.setType(CollectionType.DATA_COL);
        }
        this.add(index, obj);
        if (this.size() > 100) {
            Handler.check();
        }
    }

    @Override
    public OntCollection addAllTyped(Object col) {
        if (col instanceof Collection) {
            for (Object o : (Collection)col) {
                if (o == null) continue;
                this.addTyped(o);
            }
        } else {
            if (col instanceof int[]) {
                throw new RuntimeException("int[] object arrays are unsupported, use ObjectId.convert() to wrap");
            }
            if (col instanceof String[]) {
                String[] objects;
                for (String object : objects = (String[])col) {
                    this.addTyped(object);
                }
            } else {
                this.addTyped(col);
            }
        }
        return this;
    }

    @Override
    public OntCollection addAllTyped(Object col, int idx) {
        if (col instanceof Collection) {
            for (Object o : (Collection)col) {
                if (o == null) continue;
                this.addTyped(o, idx);
                ++idx;
            }
        } else {
            this.addTyped(col, idx);
        }
        return this;
    }

    @Override
    public OntCollection remove(int idx) {
        try {
            this.list.remove(idx);
        }
        catch (Exception e) {
            return null;
        }
        return this;
    }

    @Override
    public Object get(int n) {
        return this.list.get(n);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public OntCollection range(int first, int length) {
        SimpleCol oc = new SimpleCol(CollectionType.UNDEF_COL);
        if (first < 0 || first >= this.size()) {
            return oc;
        }
        int l = Math.min(this.size(), first + length);
        for (int i = first; i < l; ++i) {
            oc.addTyped(this.get(i));
        }
        return oc;
    }

    @Override
    public final Iterator<Object> iterator() {
        return this.list.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    @Override
    public final boolean add(Object o) {
        return this.list.add(o);
    }

    public final void add(int index, Object o) {
        this.list.add(index, o);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.type = CollectionType.UNDEF_COL;
        this.list.clear();
    }

    public void sort(Comparator<? super Object> comp) {
        Collections.sort(this.list, comp);
    }

    @Override
    public void addObject(BoxWorker worker, int id) {
        this.setType(CollectionType.OBJECT_COL);
        this.add(ObjectId.newId(worker, id));
    }

    @Override
    public void addObjects(BoxWorker worker, int[] ids) {
        this.setType(CollectionType.OBJECT_COL);
        for (int id : ids) {
            this.add(ObjectId.newId(worker, id));
        }
    }
}

