/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.metalang;

import java.io.IOException;
import java.io.Reader;
import org.ontobox.libretto.Handler;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.ObjectContainer;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;

public abstract class EmbeddedLanguage {
    protected String id;
    protected Handler handler;
    protected String namespace;
    protected OntologyId ontology;
    protected String prefix;

    public EmbeddedLanguage(String langName, Handler handler, String ns, String px) {
        this.id = langName;
        this.namespace = ns;
        this.prefix = px;
        this.handler = handler;
        if (px != null) {
            handler.putUriInMap(px, ns);
        }
    }

    public EmbeddedLanguage(String langName, Handler handler) {
        this(langName, handler, null, null);
    }

    public abstract void wakeUp(LocalContext var1);

    public abstract Object parse(LocalContext var1, Reader var2);

    public abstract OntCollection execute(LocalContext var1, Object var2, OntCollection var3);

    public Token qlParse(LocalContext lc, Reader code) {
        Token tok = lc.getPathTerm(code);
        tok.setType(TokenType.QUOTED_EXP);
        lc.addToEmbeddedExp(tok);
        return tok;
    }

    public Object qlExecute(LocalContext lc, Object code, Object context) {
        Object res = lc.eval(context, code);
        if (res instanceof ObjectContainer) {
            res = ObjectContainer.getObject(res);
        } else if (res instanceof OntCollection) {
            OntCollection col = OntCC.newCol();
            for (Object obj : (OntCollection)res) {
                if (obj instanceof ObjectContainer) {
                    obj = ObjectContainer.getObject(obj);
                }
                col.addAllTyped(obj);
            }
            res = col;
        }
        return res;
    }

    public String getID() {
        return this.id;
    }

    public void setId(String nm) {
        this.id = nm;
    }

    public static StringBuilder readToStick(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        int ch = reader.read();
        if (ch == 124) {
            return sb;
        }
        do {
            if (ch == 39 || ch == 34) {
                EmbeddedLanguage.readStringSegment(reader, sb, ch);
                continue;
            }
            sb.append((char)ch);
        } while ((ch = reader.read()) != 124);
        return sb;
    }

    private static void readStringSegment(Reader reader, StringBuilder sb, int ch) throws IOException {
        int delim = ch;
        sb.append((char)ch);
        do {
            if ((ch = reader.read()) == 92) {
                sb.append((char)ch);
                ch = reader.read();
            }
            sb.append((char)ch);
        } while (ch != delim);
    }
}

