/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser;

import org.ontobox.libretto.parser.Asterisk;
import org.ontobox.libretto.parser.Delimiter;
import org.ontobox.libretto.parser.KeyWord;
import org.ontobox.libretto.parser.Operation;
import org.ontobox.libretto.parser.Operator;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;
import org.ontobox.libretto.parser.Tokens;

public class Display {
    private final Tokens tokens;
    private static final String[] tokshow = new String[100];
    private static final String[] keyshow = new String[50];
    private static final String[] delimshow = new String[50];
    private static final String[] poshow = new String[10];
    static final String[] opshow = new String[20];

    Display(Tokens tok) {
        this.tokens = tok;
    }

    private static String showToken(Token tk) {
        String res;
        switch (tk.type) {
            case KEYWORD: {
                res = keyshow[tk.value];
                break;
            }
            case BASIC_TYPE: {
                res = String.valueOf(tk.obj.toString());
                if (!(tk.obj instanceof String)) break;
                res = '\"' + res + '\"';
                break;
            }
            case PROP_NAME: {
                res = Display.showName(tk);
                break;
            }
            case EDITED_PROP_NAME: {
                res = Display.showName(tk);
                break;
            }
            case OBJ_NAME: {
                res = '&' + Display.showName(tk);
                break;
            }
            case CLASS_NAME: {
                res = '@' + Display.showName(tk);
                break;
            }
            case ONTO_NAME: {
                res = ':' + tk.name;
                break;
            }
            case VAR_REF: {
                res = '$' + tk.name + '[' + tk.value + ']';
                break;
            }
            case DOT: {
                res = ".";
                break;
            }
            case SLASH: {
                res = "/";
                break;
            }
            case OPER: {
                res = opshow[tk.value];
                break;
            }
            case PROP_OPERATOR: {
                res = poshow[tk.value];
                break;
            }
            case ASTERISK: {
                if (tk.value == Asterisk.AST_NS.ordinal()) {
                    res = Display.showName(tk);
                    break;
                }
                if (tk.value == Asterisk.AST_ALL.ordinal()) {
                    res = "*:*";
                    break;
                }
                res = "*";
                break;
            }
            case FUNCTOR: {
                res = tk.name + '/' + tk.value + '(';
                break;
            }
            case FORALL_QUANT: {
                if (tk.value == 1) {
                    res = "!";
                    break;
                }
                res = "!!";
                break;
            }
            case QUESTION: {
                res = "?";
                break;
            }
            case DELIM: {
                res = delimshow[tk.value];
                break;
            }
            case COMMENT: {
                res = '#' + tk.name;
                break;
            }
            case PATH_EXP: {
                res = "";
                break;
            }
            case TERM_EXP: {
                res = "";
                break;
            }
            case SET_EXP: {
                res = "";
                break;
            }
            case ASSIGN_INSTR: {
                res = "";
                break;
            }
            case QUERY_INSTR: {
                res = "";
                break;
            }
            case DECLARE_INSTR: {
                res = "";
                break;
            }
            case ONT_MODIFY_INSTR: {
                res = Display.showUpdater(tk.value);
                break;
            }
            case CLS_MODIFY_INSTR: {
                res = Display.showUpdater(tk.value);
                break;
            }
            case TPROP_UPDATER: {
                res = "";
                break;
            }
            case OPROP_UPDATER: {
                res = "";
                break;
            }
            case PROGRAM: {
                res = "";
                break;
            }
            case PROPERTY_COMMAND: {
                res = poshow[tk.value];
                break;
            }
            case FUN_CALL: {
                res = tk.name + '/' + tk.value + '(';
                break;
            }
            case SET_FIELD: 
            case GET_FIELD: {
                res = tk.name;
                break;
            }
            case IF_EXP: {
                res = "";
                break;
            }
            case PREDICATE: 
            case SORTER: {
                res = "";
                break;
            }
            case INVERSE_OPROP_NAME: {
                res = tk.name;
                break;
            }
            default: {
                res = "err " + (Object)((Object)tk.type);
            }
        }
        return tokshow[tk.type.ordinal()] + '.' + res;
    }

    private static String showUpdater(int val) {
        if (val == KeyWord.UPDATE.ordinal()) {
            return "up";
        }
        if (val == KeyWord.CREATE.ordinal()) {
            return "cr";
        }
        return "cu";
    }

    private static String showName(Token tk) {
        String res = tk.prefix != null ? tk.prefix + ':' : "";
        res = res + tk.name;
        return res;
    }

    private static void tokenize(Sequence seq) {
        int i = 0;
        for (Token tk : seq.sequence) {
            if (i > 0) {
                if (seq.parent.type == TokenType.PATH_EXP) {
                    System.out.print(" / ");
                } else if (seq.parent.type == TokenType.TERM_EXP) {
                    System.out.print(" ");
                } else {
                    System.out.print(", ");
                }
            }
            ++i;
            if (tk == null) {
                System.out.print("null ");
                continue;
            }
            System.out.print(Display.showToken(tk));
            if (tk.seq == null) continue;
            System.out.print('[');
            Display.tokenize(tk.getSeq());
            System.out.print(']');
        }
    }

    public void tokenize() {
        Token tk;
        do {
            tk = this.tokens.nextToken();
            System.out.print(Display.showToken(tk) + ' ');
        } while (tk.type != TokenType.DELIM || tk.value != Delimiter.EOF.ordinal());
    }

    static {
        Display.tokshow[TokenType.KEYWORD.ordinal()] = "kw";
        Display.tokshow[TokenType.QNAME.ordinal()] = "qn";
        Display.tokshow[TokenType.PROP_NAME.ordinal()] = "pn";
        Display.tokshow[TokenType.OBJ_NAME.ordinal()] = "in";
        Display.tokshow[TokenType.CLASS_NAME.ordinal()] = "cn";
        Display.tokshow[TokenType.ONTO_NAME.ordinal()] = "";
        Display.tokshow[TokenType.DATATYPE_NAME.ordinal()] = "dn";
        Display.tokshow[TokenType.VAR_REF.ordinal()] = "";
        Display.tokshow[TokenType.DOT.ordinal()] = "dt";
        Display.tokshow[TokenType.SLASH.ordinal()] = "sl";
        Display.tokshow[TokenType.OPER.ordinal()] = "";
        Display.tokshow[TokenType.PROP_OPERATOR.ordinal()] = "po";
        Display.tokshow[TokenType.ASTERISK.ordinal()] = "";
        Display.tokshow[TokenType.FUNCTOR.ordinal()] = "";
        Display.tokshow[TokenType.FORALL_QUANT.ordinal()] = "";
        Display.tokshow[TokenType.QUESTION.ordinal()] = "qt";
        Display.tokshow[TokenType.DELIM.ordinal()] = "dl";
        Display.tokshow[TokenType.COMMENT.ordinal()] = "cm";
        Display.tokshow[TokenType.EDITED_PROP_NAME.ordinal()] = "ed";
        Display.tokshow[TokenType.INVERSE_OPROP_NAME.ordinal()] = "~";
        Display.tokshow[TokenType.SORTER.ordinal()] = "sr";
        Display.tokshow[TokenType.PROGRAM.ordinal()] = "\nprog";
        Display.tokshow[TokenType.QUERY_INSTR.ordinal()] = "\nquery";
        Display.tokshow[TokenType.DECLARE_INSTR.ordinal()] = "\ndecl";
        Display.tokshow[TokenType.ONT_MODIFY_INSTR.ordinal()] = "\nont";
        Display.tokshow[TokenType.CLS_MODIFY_INSTR.ordinal()] = "\nclass";
        Display.tokshow[TokenType.ASSIGN_INSTR.ordinal()] = "\nassignVar";
        Display.tokshow[TokenType.PATH_EXP.ordinal()] = "path";
        Display.tokshow[TokenType.TERM_EXP.ordinal()] = "term";
        Display.tokshow[TokenType.SET_EXP.ordinal()] = "set";
        Display.tokshow[TokenType.OPROP_UPDATER.ordinal()] = "oup";
        Display.tokshow[TokenType.TPROP_UPDATER.ordinal()] = "tup";
        Display.tokshow[TokenType.PROPERTY_COMMAND.ordinal()] = "";
        Display.tokshow[TokenType.SET_FIELD.ordinal()] = "^";
        Display.tokshow[TokenType.GET_FIELD.ordinal()] = "^^";
        Display.tokshow[TokenType.FUN_CALL.ordinal()] = "";
        Display.tokshow[TokenType.IF_EXP.ordinal()] = "if";
        Display.tokshow[TokenType.PREDICATE.ordinal()] = "pred";
        Display.keyshow[KeyWord.CREATE.ordinal()] = "create";
        Display.keyshow[KeyWord.CREATE_OR_UPDATE.ordinal()] = "create-or-update";
        Display.keyshow[KeyWord.UPDATE.ordinal()] = "update";
        Display.keyshow[KeyWord.QUERY.ordinal()] = "query";
        Display.keyshow[KeyWord.FUNCTION.ordinal()] = "def";
        Display.keyshow[KeyWord.GENERATOR.ordinal()] = "gen";
        Display.keyshow[KeyWord.IF.ordinal()] = "if";
        Display.keyshow[KeyWord.ONTOLOGY.ordinal()] = "on";
        Display.keyshow[KeyWord.CLASS.ordinal()] = "cl";
        Display.keyshow[KeyWord.REQUIRE.ordinal()] = "rq";
        Display.delimshow[Delimiter.OPEN_PARENTH.ordinal()] = "(";
        Display.delimshow[Delimiter.CLOSE_PARENTH.ordinal()] = ")";
        Display.delimshow[Delimiter.OPEN_BRACKET.ordinal()] = "[";
        Display.delimshow[Delimiter.CLOSE_BRACKET.ordinal()] = "]";
        Display.delimshow[Delimiter.LANGLE.ordinal()] = "'<'";
        Display.delimshow[Delimiter.RANGLE.ordinal()] = "'>'";
        Display.delimshow[Delimiter.OPEN_CURLY.ordinal()] = "{";
        Display.delimshow[Delimiter.CLOSE_CURLY.ordinal()] = "}";
        Display.delimshow[Delimiter.COMMA.ordinal()] = ",";
        Display.delimshow[Delimiter.SEMICOLON.ordinal()] = ";";
        Display.delimshow[Delimiter.EOF.ordinal()] = "<eof>";
        Display.poshow[Operator.ASSIGN.ordinal()] = ":=";
        Display.poshow[Operator.INSERT_BEFORE.ordinal()] = ".=";
        Display.poshow[Operator.INSERT_AFTER.ordinal()] = "+=";
        Display.poshow[Operator.DELETE_VALUE.ordinal()] = "--";
        Display.opshow[Operation.PLUS.ordinal()] = "+";
        Display.opshow[Operation.MINUS.ordinal()] = "-";
        Display.opshow[Operation.MULT.ordinal()] = "*";
        Display.opshow[Operation.DIV.ordinal()] = "div";
        Display.opshow[Operation.MOD.ordinal()] = "mod";
        Display.opshow[Operation.EQ.ordinal()] = "=";
        Display.opshow[Operation.NEQ.ordinal()] = "!=";
        Display.opshow[Operation.LT.ordinal()] = "<";
        Display.opshow[Operation.GT.ordinal()] = ">";
        Display.opshow[Operation.LEQ.ordinal()] = "<=";
        Display.opshow[Operation.GEQ.ordinal()] = ">=";
        Display.opshow[Operation.AND.ordinal()] = "and";
        Display.opshow[Operation.OR.ordinal()] = "or";
        Display.opshow[Operation.NOT.ordinal()] = "not";
        Display.opshow[Operation.FIELD.ordinal()] = "^";
        Display.opshow[Operation.EVAL.ordinal()] = "^^";
        Display.opshow[Operation.INVERSE.ordinal()] = "~";
        Display.opshow[Operation.UMINUS.ordinal()] = "/-/";
    }
}

