/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.net.client;

import com.teacode.bml.BML;
import com.teacode.bml.LoadMode;
import com.teacode.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class ClientBox {
    private static final String ENCODING = "UTF-8";
    private String au;
    private URL url;

    public ClientBox(URL url, String user, String password) throws IOException {
        this.url = url;
        this.au = "Basic " + Base64.encodeBytes((byte[])(user + ':' + password).getBytes("ASCII"));
        System.out.println(this.query());
    }

    public Object query() throws IOException {
        HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
        try {
            con.setRequestMethod("PUT");
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setRequestProperty("Authorization", this.au);
            OutputStream out = con.getOutputStream();
            BML.save((Object)1, (OutputStream)out);
            InputStream in = con.getInputStream();
            String mimeType = con.getContentType();
            if (mimeType == null) {
                throw new IOException("response MIME type is null");
            }
            if (!mimeType.equals("application/x-bml")) {
                throw new IOException("unsupported response MIME type (" + mimeType + ')');
            }
            Object object = BML.load((InputStream)in, (LoadMode)LoadMode.LIST_AS_ARRAY);
            return object;
        }
        catch (Exception e) {
            int code = con.getResponseCode();
            if (code != -1 && code != 200) {
                throw new RuntimeException("Code: " + code + " [" + con.getResponseMessage() + "]: " + e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            con.disconnect();
        }
    }
}

