/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.play.data;

import com.teacode.exception.ExUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.play.data.BoxContext;
import org.ontobox.play.data.BoxInitter;
import org.ontobox.storage.StorageBox;
import play.Play;
import play.exceptions.ConfigurationException;

public class Global {
    public static Logger logger = Logger.getLogger(Global.class.getName());
    static Map<String, BoxContext> boxes = new HashMap<String, BoxContext>();
    static ThreadLocal<Map<String, BoxWorker>> worker = new ThreadLocal();
    public static ThreadLocal<Integer> rVar = new ThreadLocal();
    public static ThreadLocal<Integer> cVar = new ThreadLocal();

    public static synchronized void closeBoxes() {
        for (BoxContext context : boxes.values()) {
            context.box.close();
        }
        boxes.clear();
    }

    public static synchronized BoxContext initBox(String key) {
        BoxContext box = boxes.get(key);
        if (box == null) {
            logger.info("InitBox (key: " + key + ")");
            String mode = Play.configuration.getProperty("libretto.mode", "mem");
            if (mode == null || mode.equals("mem")) {
                box = new BoxContext(new StorageBox());
            } else if (mode.equals("fs")) {
                box = new BoxContext(new StorageBox(new File(key)));
            } else {
                throw new ConfigurationException("libretto.mode must be mem or fs (libretto.mode=" + mode + ")");
            }
            try {
                BoxInitter.init(box, key);
            }
            catch (RuntimeException e) {
                box.box.close();
                throw e;
            }
            catch (Exception e) {
                box.box.close();
                throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException(e.getMessage()), (Throwable)e);
            }
            boxes.put(key, box);
        }
        return box;
    }

    public static int r(BoxWorker worker) {
        Integer r = rVar.get();
        if (r == null) {
            throw new IllegalStateException("Not a Libretto Play controller");
        }
        if (worker.entity(r) != Entity.ONTOBJECT) {
            throw new IllegalStateException("Object (" + r + ") is not found");
        }
        return r;
    }

    public static int c(BoxWorker worker) {
        Integer c = cVar.get();
        if (c == null) {
            throw new IllegalStateException("Not a Libretto Play view template");
        }
        if (worker.entity(c) != Entity.ONTOBJECT) {
            throw new IllegalStateException("Object (" + c + ") is not found");
        }
        return c;
    }

    public static BoxWorker worker(String key, boolean readOnly) {
        BoxWorker ret;
        Map<String, BoxWorker> w = worker.get();
        if (w == null) {
            w = new HashMap<String, BoxWorker>();
            worker.set(w);
        }
        if ((ret = w.get(key)) == null) {
            ret = readOnly ? Global.initBox((String)key).box.workRO() : Global.initBox((String)key).box.work();
            w.put(key, ret);
        }
        return ret;
    }

    public static void commitWorkers() {
        Map<String, BoxWorker> w = worker.get();
        if (w != null) {
            for (BoxWorker boxWorker : w.values()) {
                boxWorker.commit();
            }
        }
    }

    public static void closeWorkers() {
        Map<String, BoxWorker> w = worker.get();
        if (w != null) {
            for (BoxWorker boxWorker : w.values()) {
                boxWorker.close();
            }
            worker.remove();
        }
    }
}

