/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.RHelper;
import org.ontobox.box.helper.SortMode;
import org.ontobox.box.helper.Sorter;
import org.ontobox.box.helper.VMap;
import org.ontobox.box.helper.WHelper;
import org.ontobox.box.query.QContext;
import org.ontobox.box.query.Query;
import org.ontobox.storage.StorageBox;

public class DocExample {
    private static String ONTOLOGY = "http://person.example.com/";
    private static String PERSON_CLASS = ONTOLOGY + "#Person";
    private static String PERSON_NAME = ONTOLOGY + "#name";
    private static String PERSON_AGE = ONTOLOGY + "#age";
    private static String[] names = new String[]{"\u0412\u0430\u0441\u044f", "\u041f\u0435\u0442\u044f", "\u041a\u043e\u043b\u044f", "\u0430\u0431\u0432"};
    private static int[] ages = new int[]{23, 20, 30, 99};

    private static void createLow(BoxWorker worker) {
        DocExample.createStructureLow(worker);
        DocExample.createDataLow(worker);
    }

    private static void createMid(BoxWorker worker) {
        DocExample.createStructureMid(worker);
        DocExample.createDataMid(worker);
    }

    private static void createHigh(BoxWorker worker) {
        DocExample.createStructureHigh(worker);
        DocExample.createDataHigh(worker);
    }

    private static void createStructureLow(BoxWorker worker) {
        BoxWriter writer = worker.write();
        writer.newOntology(ONTOLOGY);
        int person = writer.newClass(PERSON_CLASS);
        int name = writer.newTProperty(PERSON_NAME);
        writer.setDomain(name, person);
        writer.setRange(name, worker.resolve("http://ontobox.org/#string"));
        writer.annotate(name, "http://ontobox.org/#maxcard", "1");
        int age = writer.newTProperty(PERSON_AGE);
        writer.setDomain(age, person);
        writer.setRange(age, worker.resolve("http://ontobox.org/#int"));
        writer.annotate(age, "http://ontobox.org/#maxcard", "1");
    }

    private static void createStructureMid(BoxWorker worker) {
        BoxWriter writer = worker.write();
        writer.newOntology(ONTOLOGY);
        WHelper.ontclass(worker, PERSON_CLASS).tprop(PERSON_NAME, "http://ontobox.org/#string", 1).tprop(PERSON_AGE, "http://ontobox.org/#int", 1);
    }

    private static void createStructureHigh(BoxWorker worker) {
        worker.q(new QContext(), "ontology . \"http://person.example.com/\";class Person { name[,1] { xsd:string }, age[,1] { xsd:int } };");
    }

    private static void createDataLow(BoxWorker worker) {
        BoxWriter writer = worker.write();
        int ont = worker.id(ONTOLOGY);
        int person = worker.id(PERSON_CLASS);
        int name = worker.id(PERSON_NAME);
        int age = worker.id(PERSON_AGE);
        int size = names.length;
        for (int t = 0; t < size; ++t) {
            int obj = writer.newObject(writer.newName(ont));
            writer.addObjectClass(obj, person);
            writer.addString(obj, name, names[t]);
            writer.addInt(obj, age, ages[t]);
        }
    }

    private static void createDataMid(BoxWorker worker) {
        int ont = worker.id(ONTOLOGY);
        int size = names.length;
        for (int t = 0; t < size; ++t) {
            WHelper.object(worker, ont, PERSON_CLASS).addString(PERSON_NAME, names[t]).addInt(PERSON_AGE, ages[t]);
        }
    }

    private static void createDataHigh(BoxWorker worker) {
        QContext ctx = new QContext();
        ctx.setDefaultPrefix(ONTOLOGY);
        Query q = ctx.createQuery("Person &_ { name := ?, age := ? };");
        int size = names.length;
        for (int t = 0; t < size; ++t) {
            q.setString(0, names[t]);
            q.setInt(1, ages[t]);
            worker.q(ctx, q);
        }
    }

    private static void printDataLow(BoxWorker worker) {
        int name = worker.resolve(PERSON_NAME, Entity.TPROPERTY);
        int age = worker.resolve(PERSON_AGE, Entity.TPROPERTY);
        ArrayList<PersonName> persons = new ArrayList<PersonName>();
        for (int obj : worker.objects(worker.resolve(PERSON_CLASS))) {
            persons.add(new PersonName(obj, worker.strings(obj, name)[0]));
        }
        Collections.sort(persons, new Comparator<PersonName>(){

            @Override
            public int compare(PersonName pn1, PersonName pn2) {
                return pn1.name.toLowerCase().compareTo(pn2.name.toLowerCase());
            }
        });
        System.out.println("Person list (Low)");
        for (PersonName person : persons) {
            System.out.println("Object: " + worker.name(person.person));
            System.out.println("Name: " + person.name);
            System.out.println("Age: " + worker.ints(person.person, age)[0]);
        }
    }

    private static void printDataMid(BoxWorker worker) {
        int[] persons = worker.objects(worker.resolve(PERSON_CLASS));
        persons = Sorter.sortIgnoreCase(worker, persons, SortMode.ASC, worker.resolve(PERSON_NAME, Entity.TPROPERTY));
        System.out.println("Person list (Mid-1)");
        for (int person : persons) {
            System.out.println("Object: " + worker.name(person));
            System.out.println("Name: " + RHelper.stringValue(worker, person, PERSON_NAME));
            System.out.println("Age: " + RHelper.intValue(worker, person, PERSON_AGE));
        }
        System.out.println("Person list (Mid-2)");
        for (int person : persons) {
            VMap v = new VMap(worker, person);
            System.out.println("Object: " + v.name());
            System.out.println("Name: " + v.mString(PERSON_NAME));
            System.out.println("Age: " + v.mInteger(PERSON_AGE));
        }
    }

    private static void printDataHigh(BoxWorker worker) {
        QContext ctx = new QContext();
        ctx.setDefaultPrefix(ONTOLOGY);
        System.out.println("Person list (High)");
        List<VMap> persons = worker.qMaps(ctx, "Person<<name/fn:lower-case()>>");
        for (VMap v : persons) {
            System.out.println("Object: " + v.name());
            System.out.println("Name: " + v.mString(PERSON_NAME));
            System.out.println("Age: " + v.mInteger(PERSON_AGE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        StorageBox box = new StorageBox();
        try {
            BoxWorker worker = box.work();
            try {
                if (worker.entity(ONTOLOGY) != Entity.ONTOLOGY) {
                    DocExample.createHigh(worker);
                }
                worker.commit();
            }
            finally {
                worker.close();
            }
            worker = box.workRO();
            try {
                DocExample.printDataLow(worker);
                DocExample.printDataMid(worker);
                DocExample.printDataHigh(worker);
            }
            finally {
                worker.close();
            }
        }
        finally {
            box.close();
        }
    }

    private static class PersonName {
        public int person;
        public String name;

        private PersonName(int person, String name) {
            this.person = person;
            this.name = name;
        }
    }
}

