/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.bml;

import com.teacode.bml.LoadMode;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BMLLoader {
    private final InputStream in;
    private final LoadMode mode;

    public BMLLoader(InputStream in, LoadMode mode) {
        this.in = in;
        this.mode = mode;
    }

    private byte[] readFully(int buflen) throws IOException {
        int read;
        byte[] buf = new byte[buflen];
        int off = 0;
        do {
            if ((read = this.in.read(buf, off, buflen - off)) != -1) continue;
            throw new EOFException();
        } while ((off += read) != buflen);
        return buf;
    }

    private int read() throws IOException {
        int r = this.in.read();
        if (r == -1) {
            throw new EOFException();
        }
        return r;
    }

    Object load() throws IOException {
        int sign0 = this.read();
        int sign1 = this.read();
        if (sign0 != 52 && sign1 != 18) {
            throw new IllegalArgumentException("signature is not found");
        }
        Object preValue = this.loadObject();
        Object value = this.loadObject();
        return value;
    }

    private Object loadObject() throws IOException {
        int type = this.read();
        switch (type) {
            case 0: {
                return null;
            }
            case 129: {
                return true;
            }
            case 128: {
                return false;
            }
            case 3: {
                return this.loadList();
            }
            case 4: {
                return this.loadTypedList();
            }
            case 1: {
                return this.loadMap();
            }
            case 2: {
                return this.loadTypedMap();
            }
        }
        return this.loadObjectRAW(type);
    }

    private Object loadObjectRAW(int type) throws IOException {
        switch (type) {
            case 9: {
                return Character.valueOf(this.loadCharRAW());
            }
            case 5: {
                return this.loadStringRAW();
            }
            case 8: {
                return this.loadInt8RAW();
            }
            case 16: {
                return this.loadInt16RAW();
            }
            case 32: {
                return this.loadInt32RAW();
            }
            case 64: {
                return this.loadInt64RAW();
            }
        }
        throw new IllegalArgumentException("unknown type: 0x" + Integer.toHexString(type));
    }

    private Object loadList() throws IOException {
        int len = this.loadLength();
        if (this.mode == LoadMode.LIST_AS_LIST) {
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int t = 0; t < len; ++t) {
                list.add(this.loadObject());
            }
            return list;
        }
        if (this.mode == LoadMode.LIST_AS_ARRAY) {
            Object[] array = new Object[len];
            for (int t = 0; t < len; ++t) {
                array[t] = this.loadObject();
            }
            return array;
        }
        throw new IllegalArgumentException("Unknown load mode: " + (Object)((Object)this.mode));
    }

    private Object loadTypedList() throws IOException {
        int valueType = this.read();
        int len = this.loadLength();
        if (this.mode == LoadMode.LIST_AS_LIST) {
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int t = 0; t < len; ++t) {
                list.add(this.loadObjectRAW(valueType));
            }
            return list;
        }
        if (this.mode == LoadMode.LIST_AS_ARRAY) {
            switch (valueType) {
                case 9: {
                    char[] array = new char[]{};
                    for (int t = 0; t < len; ++t) {
                        array[t] = this.loadCharRAW();
                    }
                    return array;
                }
                case 5: {
                    String[] array = new String[]{};
                    for (int t = 0; t < len; ++t) {
                        array[t] = this.loadStringRAW();
                    }
                    return array;
                }
                case 8: {
                    byte[] array = new byte[len];
                    for (int t = 0; t < len; ++t) {
                        array[t] = this.loadInt8RAW();
                    }
                    return array;
                }
                case 16: {
                    short[] array = new short[len];
                    for (int t = 0; t < len; ++t) {
                        array[t] = this.loadInt16RAW();
                    }
                    return array;
                }
                case 32: {
                    int[] array = new int[len];
                    for (int t = 0; t < len; ++t) {
                        array[t] = this.loadInt32RAW();
                    }
                    return array;
                }
                case 64: {
                    long[] array = new long[len];
                    for (int t = 0; t < len; ++t) {
                        array[t] = this.loadInt64RAW();
                    }
                    return array;
                }
            }
            throw new IllegalArgumentException("Unknown type for values of typed list: 0x" + Integer.toHexString(valueType));
        }
        throw new IllegalArgumentException("Unknown load mode: " + (Object)((Object)this.mode));
    }

    private Map loadMap() throws IOException {
        int len = this.loadLength();
        HashMap<Object, Object> map = new HashMap<Object, Object>(len);
        for (int t = 0; t < len; ++t) {
            map.put(this.loadObject(), this.loadObject());
        }
        return map;
    }

    private Map loadTypedMap() throws IOException {
        int keyType = this.read();
        int valueType = this.read();
        int len = this.loadLength();
        HashMap<Object, Object> map = new HashMap<Object, Object>(len);
        for (int t = 0; t < len; ++t) {
            map.put(this.loadObjectRAW(keyType), this.loadObjectRAW(valueType));
        }
        return map;
    }

    private int loadLength() throws IOException {
        return this.loadInt32RAW();
    }

    private char loadCharRAW() throws IOException {
        return (char)((this.read() & 0xFF) + ((this.read() & 0xFF) << 8));
    }

    private byte loadInt8RAW() throws IOException {
        return (byte)this.read();
    }

    private short loadInt16RAW() throws IOException {
        return (short)((this.read() & 0xFF) + ((this.read() & 0xFF) << 8));
    }

    private int loadInt32RAW() throws IOException {
        return (this.read() & 0xFF) + ((this.read() & 0xFF) << 8) + ((this.read() & 0xFF) << 16) + ((this.read() & 0xFF) << 24);
    }

    private long loadInt64RAW() throws IOException {
        return (long)(this.read() & 0xFF) + ((long)(this.read() & 0xFF) << 8) + ((long)(this.read() & 0xFF) << 16) + ((long)(this.read() & 0xFF) << 24) + ((long)(this.read() & 0xFF) << 32) + ((long)(this.read() & 0xFF) << 40) + ((long)(this.read() & 0xFF) << 48) + ((long)(this.read() & 0xFF) << 56);
    }

    private String loadStringRAW() throws IOException {
        int len = this.loadLength();
        byte[] buf = this.readFully(len * 2);
        StringBuilder sb = new StringBuilder(len);
        for (int t = 0; t < len; ++t) {
            sb.append((char)((buf[t * 2] & 0xFF) + ((buf[t * 2 + 1] & 0xFF) << 8)));
        }
        return sb.toString();
    }
}

