/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.bml;

import com.teacode.bml.BML;
import com.teacode.bml.SizedListIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BMLSaver {
    BMLSaver() {
    }

    static void save(Object obj, OutputStream out) throws IOException {
        out.write(BML.SIGNATURE);
        out.write(0);
        BMLSaver.saveObject(obj, out);
        out.flush();
    }

    private static void saveObject(Object obj, OutputStream out) throws IOException {
        if (obj == null) {
            out.write(0);
        } else if (obj instanceof Boolean) {
            BMLSaver.saveBoolean((Boolean)obj, out);
        } else if (obj instanceof Long) {
            BMLSaver.saveInt64((Long)obj, out);
        } else if (obj instanceof Integer) {
            BMLSaver.saveInt32((Integer)obj, out);
        } else if (obj instanceof Short) {
            BMLSaver.saveInt16((Short)obj, out);
        } else if (obj instanceof Byte) {
            BMLSaver.saveInt8((Byte)obj, out);
        } else if (obj instanceof Character) {
            BMLSaver.saveChar(((Character)obj).charValue(), out);
        } else if (obj instanceof String) {
            BMLSaver.saveString((String)obj, out);
        } else if (obj instanceof Map) {
            BMLSaver.saveMap((Map)obj, out);
        } else if (obj instanceof Collection) {
            BMLSaver.saveList((Collection)obj, out);
        } else if (obj instanceof SizedListIterator) {
            BMLSaver.saveIterator((SizedListIterator)obj, out);
        } else if (obj instanceof int[]) {
            BMLSaver.saveIntArray((int[])obj, out);
        } else if (obj instanceof String[]) {
            BMLSaver.saveStringArray((String[])obj, out);
        } else if (obj instanceof Object[]) {
            BMLSaver.saveArray((Object[])obj, out);
        } else {
            throw new IllegalArgumentException("unsupported object (" + obj.getClass() + ')');
        }
    }

    private static void saveBoolean(boolean bool, OutputStream out) throws IOException {
        out.write(bool ? 129 : 128);
    }

    private static void saveString(String str, OutputStream out) throws IOException {
        out.write(5);
        BMLSaver.saveStringRAW(str, out);
    }

    private static void saveInt8(byte int8, OutputStream out) throws IOException {
        out.write(8);
        out.write(int8);
    }

    private static void saveInt16(short int16, OutputStream out) throws IOException {
        out.write(16);
        BMLSaver.saveInt16RAW(int16, out);
    }

    private static void saveInt32(int int32, OutputStream out) throws IOException {
        out.write(32);
        BMLSaver.saveInt32RAW(int32, out);
    }

    private static void saveInt64(long int64, OutputStream out) throws IOException {
        out.write(64);
        BMLSaver.saveInt64RAW(int64, out);
    }

    private static void saveChar(char ch, OutputStream out) throws IOException {
        out.write(9);
        BMLSaver.saveCharRAW(ch, out);
    }

    private static void saveArray(Object[] array, OutputStream out) throws IOException {
        out.write(3);
        BMLSaver.saveLen(array.length, out);
        for (Object obj : array) {
            BMLSaver.saveObject(obj, out);
        }
    }

    private static void saveIntArray(int[] array, OutputStream out) throws IOException {
        out.write(4);
        out.write(32);
        BMLSaver.saveLen(array.length, out);
        for (int obj : array) {
            BMLSaver.saveInt32RAW(obj, out);
        }
    }

    private static void saveStringArray(String[] array, OutputStream out) throws IOException {
        out.write(4);
        out.write(5);
        BMLSaver.saveLen(array.length, out);
        for (String obj : array) {
            BMLSaver.saveStringRAW(obj, out);
        }
    }

    private static void saveList(Collection col, OutputStream out) throws IOException {
        out.write(3);
        BMLSaver.saveLen(col.size(), out);
        for (Object obj : col) {
            BMLSaver.saveObject(obj, out);
        }
    }

    private static void saveIterator(SizedListIterator iterator, OutputStream out) throws IOException {
        out.write(3);
        BMLSaver.saveLen(iterator.getSize(), out);
        while (iterator.hasNext()) {
            BMLSaver.saveObject(iterator.next(), out);
        }
    }

    private static void saveMap(Map<Object, Object> map, OutputStream out) throws IOException {
        out.write(1);
        BMLSaver.saveLen(map.size(), out);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            BMLSaver.saveObject(entry.getKey(), out);
            BMLSaver.saveObject(entry.getValue(), out);
        }
    }

    private static void saveLen(int len, OutputStream out) throws IOException {
        BMLSaver.saveInt32RAW(len, out);
    }

    private static void saveInt64RAW(long int64, OutputStream out) throws IOException {
        out.write((byte)int64);
        out.write((byte)(int64 >>> 8));
        out.write((byte)(int64 >>> 16));
        out.write((byte)(int64 >>> 24));
        out.write((byte)(int64 >>> 32));
        out.write((byte)(int64 >>> 40));
        out.write((byte)(int64 >>> 48));
        out.write((byte)(int64 >>> 56));
    }

    private static void saveInt32RAW(int int32, OutputStream out) throws IOException {
        out.write((byte)int32);
        out.write((byte)(int32 >>> 8));
        out.write((byte)(int32 >>> 16));
        out.write((byte)(int32 >>> 24));
    }

    private static void saveInt16RAW(short int16, OutputStream out) throws IOException {
        out.write((byte)int16);
        out.write((byte)(int16 >>> 8));
    }

    private static void saveCharRAW(char ch, OutputStream out) throws IOException {
        out.write((byte)ch);
        out.write((byte)(ch >>> 8));
    }

    private static void saveStringRAW(String str, OutputStream out) throws IOException {
        int len = str.length();
        BMLSaver.saveInt32RAW(len, out);
        byte[] buf = new byte[len * 2];
        for (int t = 0; t < len; ++t) {
            char value = str.charAt(t);
            buf[t * 2] = (byte)value;
            buf[t * 2 + 1] = (byte)(value >>> 8);
        }
        out.write(buf);
    }

    private static void saveStringAuto(String str, OutputStream out) throws IOException {
        int t;
        int len = str.length();
        byte[] buf = new byte[len * 2];
        boolean latin1 = true;
        for (t = 0; t < len; ++t) {
            byte b2;
            char value = str.charAt(t);
            buf[t * 2] = (byte)value;
            buf[t * 2 + 1] = b2 = (byte)(value >>> 8);
            if (b2 == 0) continue;
            latin1 = false;
            break;
        }
        if (latin1) {
            out.write(6);
            BMLSaver.saveInt32RAW(len, out);
            for (t = 0; t < len; ++t) {
                out.write(buf[t * 2]);
            }
        } else {
            out.write(5);
            BMLSaver.saveInt32RAW(len, out);
            out.write(buf);
        }
    }
}

