/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.collection.primitive.impl.pcj;

import bak.pcj.map.CharKeyChainedHashMap;
import bak.pcj.map.CharKeyMap;
import bak.pcj.map.CharKeyMapIterator;
import bak.pcj.map.CharKeyOpenHashMap;
import bak.pcj.map.ObjectKeyCharChainedHashMap;
import bak.pcj.map.ObjectKeyCharMap;
import bak.pcj.map.ObjectKeyCharOpenHashMap;
import com.teacode.collection.primitive.BooleanList;
import com.teacode.collection.primitive.CharObjectMap;
import com.teacode.collection.primitive.Collections;
import com.teacode.collection.primitive.IntByteMap;
import com.teacode.collection.primitive.IntIntMap;
import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntObjectMap;
import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.LongList;
import com.teacode.collection.primitive.LongObjectMap;
import com.teacode.collection.primitive.ObjectCharMap;
import com.teacode.collection.primitive.ObjectIntMap;
import com.teacode.collection.primitive.impl.pcj.PCJBooleanList;
import com.teacode.collection.primitive.impl.pcj.PCJIntByteMap;
import com.teacode.collection.primitive.impl.pcj.PCJIntIntMap;
import com.teacode.collection.primitive.impl.pcj.PCJIntList;
import com.teacode.collection.primitive.impl.pcj.PCJIntObjectMap;
import com.teacode.collection.primitive.impl.pcj.PCJIntSet;
import com.teacode.collection.primitive.impl.pcj.PCJLongList;
import com.teacode.collection.primitive.impl.pcj.PCJLongObjectMap;
import com.teacode.collection.primitive.impl.pcj.PCJObjectIntMap;
import com.teacode.collection.primitive.process.CharProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCJCollections
implements Collections {
    final boolean chained;

    public PCJCollections(boolean chained) {
        this.chained = chained;
    }

    @Override
    public final BooleanList newBooleanList(int size) {
        return new PCJBooleanList(size);
    }

    @Override
    public final IntList newIntList(int size) {
        return new PCJIntList(size);
    }

    @Override
    public final IntSet newIntSet(int size) {
        return new PCJIntSet(this.chained, size);
    }

    @Override
    public final <T> ObjectIntMap<T> newObjectIntMap(int size) {
        return new PCJObjectIntMap(this.chained, size);
    }

    @Override
    public final <T> IntObjectMap<T> newIntObjectMap(int size) {
        return new PCJIntObjectMap(this.chained, size);
    }

    @Override
    public final IntByteMap newIntByteMap(int size) {
        return new PCJIntByteMap(this.chained, size);
    }

    @Override
    public final IntIntMap newIntIntMap(int size) {
        return new PCJIntIntMap(this.chained, size);
    }

    @Override
    public final LongList newLongList(int size) {
        return new PCJLongList(size);
    }

    @Override
    public final <T> LongObjectMap<T> newLongObjectMap(int size) {
        return new PCJLongObjectMap(this.chained, size);
    }

    @Override
    public final <T> CharObjectMap<T> newCharObjectMap(final int size) {
        return new CharObjectMap<T>(){
            private final CharKeyMap map;
            {
                this.map = PCJCollections.this.chained ? new CharKeyChainedHashMap(size) : new CharKeyOpenHashMap(size);
            }

            @Override
            public final T get(char key) {
                return this.map.get(key);
            }

            @Override
            public final void put(char key, T value) {
                this.map.put(key, value);
            }

            @Override
            public final int size() {
                return this.map.size();
            }

            @Override
            public final boolean forEachKey(CharProcessor processor) {
                CharKeyMapIterator itr = this.map.entries();
                while (itr.hasNext()) {
                    itr.next();
                    char key = itr.getKey();
                    if (processor.process(key)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public final <T> ObjectCharMap<T> newObjectCharMap(final int size) {
        return new ObjectCharMap<T>(){
            private final ObjectKeyCharMap map;
            {
                this.map = PCJCollections.this.chained ? new ObjectKeyCharChainedHashMap(size) : new ObjectKeyCharOpenHashMap(size);
            }

            @Override
            public final Character get(T key) {
                char ret = this.map.get(key);
                if (ret == '\u0000') {
                    if (this.map.containsKey(key)) {
                        return Character.valueOf(ret);
                    }
                    return null;
                }
                return Character.valueOf(ret);
            }

            @Override
            public final void put(T key, char value) {
                this.map.put(key, value);
            }

            @Override
            public final int size() {
                return this.map.size();
            }
        };
    }

    public final String toString() {
        return "PCJ " + (this.chained ? "chained map/set" : "open map/set");
    }
}

