/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.file.buffer;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ReadBuffer {
    private static final int READ_BUFFER_SIZE = 819200;
    private final ByteBuffer buffer = ByteBuffer.allocate(819200);
    private final FileChannel ch;

    public ReadBuffer(FileChannel ch) throws IOException {
        this.ch = ch;
        if (ch.read(this.buffer) == -1) {
            throw new EOF();
        }
        this.buffer.flip();
    }

    public final void preload() {
        this.buffer.compact();
        try {
            if (this.ch.read(this.buffer) == -1) {
                throw new EOF();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.buffer.flip();
    }

    public final Integer getInt() {
        while (true) {
            try {
                int v = this.buffer.getInt();
                if (v == -1) {
                    return null;
                }
                return v;
            }
            catch (BufferUnderflowException e) {
                this.preload();
                continue;
            }
            break;
        }
    }

    public final long getLong() {
        while (true) {
            try {
                return this.buffer.getLong();
            }
            catch (BufferUnderflowException e) {
                this.preload();
                continue;
            }
            break;
        }
    }

    public final char getChar() {
        while (true) {
            try {
                return this.buffer.getChar();
            }
            catch (BufferUnderflowException e) {
                this.preload();
                continue;
            }
            break;
        }
    }

    public final byte getByte() {
        while (true) {
            try {
                return this.buffer.get();
            }
            catch (BufferUnderflowException e) {
                this.preload();
                continue;
            }
            break;
        }
    }

    public final String getString() {
        Integer len = this.getInt();
        if (len == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(len);
        for (int t = 0; t < len; ++t) {
            sb.append(this.getChar());
        }
        return sb.toString();
    }

    public final String getASCIICompact() {
        int len = this.getByte();
        StringBuilder sb = new StringBuilder(len);
        for (int t = 0; t < len; ++t) {
            sb.append((char)this.getByte());
        }
        return sb.toString();
    }

    public final String getRAWASCII(int count) throws IOException {
        StringBuilder sb = new StringBuilder(count);
        for (int t = 0; t < count; ++t) {
            sb.append((char)this.getByte());
        }
        return sb.toString();
    }

    public static class EOF
    extends RuntimeException {
        public EOF() {
            super("End of file");
        }
    }
}

