/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.file.buffer;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class WriteBuffer {
    static final int NULL_INT = -1;
    private static final int WRITE_BUFFER_SIZE = 2048000;
    private final ByteBuffer buffer = ByteBuffer.allocate(2048000);
    private final FileChannel ch;

    public WriteBuffer(FileChannel ch) {
        this.ch = ch;
    }

    public final void flush() {
        this.buffer.flip();
        try {
            this.ch.write(this.buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.buffer.clear();
    }

    public final void putByte(byte b) {
        try {
            this.buffer.put(b);
        }
        catch (BufferOverflowException e) {
            this.flush();
            this.buffer.put(b);
        }
    }

    public final void putChar(char c) {
        try {
            this.buffer.putChar(c);
        }
        catch (BufferOverflowException e) {
            this.flush();
            this.buffer.putChar(c);
        }
    }

    public final void putInt(int i) {
        try {
            this.buffer.putInt(i);
        }
        catch (BufferOverflowException e) {
            this.flush();
            this.buffer.putInt(i);
        }
    }

    public final void putNullInt() {
        this.putInt(-1);
    }

    public final void putLong(long i) {
        try {
            this.buffer.putLong(i);
        }
        catch (BufferOverflowException e) {
            this.flush();
            this.buffer.putLong(i);
        }
    }

    public final void putRAWASCII(String s) {
        int size = s.length();
        for (int t = 0; t < size; ++t) {
            this.putByte((byte)s.charAt(t));
        }
    }

    public final void putASCIICompact(String s) {
        int size = s.length();
        this.putByte((byte)size);
        for (int t = 0; t < size; ++t) {
            this.putByte((byte)s.charAt(t));
        }
    }

    public final void putString(String str) {
        if (str == null) {
            this.putNullInt();
        } else {
            int len = str.length();
            this.putInt(len);
            for (int t = 0; t < len; ++t) {
                this.putChar(str.charAt(t));
            }
        }
    }
}

