/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.component;

import com.teacode.swing.CommonRB;
import com.teacode.swing.tool.SelectTextMouseListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PopupClipboardMenu
extends JPopupMenu
implements ActionListener {
    protected SelectTextMouseListener.Copyable copyable;
    protected JMenuItem cut = new JMenuItem(CommonRB.get("menu.cut"));
    protected JMenuItem copy = new JMenuItem(CommonRB.get("menu.copy"));
    protected JMenuItem paste = new JMenuItem(CommonRB.get("menu.paste"));
    protected JMenuItem selectAll = new JMenuItem(CommonRB.get("menu.select.all"));

    protected void addItem(JMenuItem item) {
        this.add(item);
        item.addActionListener(this);
    }

    public PopupClipboardMenu(SelectTextMouseListener.Copyable copyable) {
        this.copyable = copyable;
        this.addItem(this.cut);
        this.addItem(this.copy);
        this.addItem(this.paste);
        this.addSeparator();
        this.addItem(this.selectAll);
    }

    public void refresh() {
        this.cut.setEnabled(this.copyable.isEditable() && this.copyable.isSelected());
        this.copy.setEnabled(this.copyable.isSelected());
        this.paste.setEnabled(this.copyable.isEditable() && this.getToolkit().getSystemClipboard().getContents(this) != null);
        this.selectAll.setEnabled(this.copyable.isSelectAllSupported());
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.cut) {
            this.copyable.cut();
        } else if (source == this.copy) {
            this.copyable.copy();
        } else if (source == this.paste) {
            this.copyable.paste();
        } else if (source == this.selectAll) {
            this.copyable.selectAll();
        }
    }
}

