/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.exception;

import com.teacode.swing.CommonRB;
import com.teacode.swing.component.ButtonPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class ErrorMessagePanel
extends JTabbedPane
implements ActionListener {
    protected Throwable tr;

    public ErrorMessagePanel(Throwable tr) {
        this.tr = tr;
        JButton copy = new JButton(CommonRB.get("exception.copy.to.clipboard"));
        copy.addActionListener(this);
        JTextArea simpleArea = this.createArea(tr);
        JTextArea moreArea = this.createArea(this.getStackTrace(tr));
        this.addTab(CommonRB.get("exception.error.tab"), new JScrollPane(simpleArea));
        JPanel morePanel = new JPanel(new BorderLayout());
        morePanel.add((Component)new JScrollPane(moreArea), "Center");
        morePanel.add((Component)new ButtonPanel(copy), "South");
        this.addTab(CommonRB.get("exception.more.tab"), morePanel);
    }

    protected String getStackTrace(Throwable tr) {
        StringWriter writer = new StringWriter();
        tr.printStackTrace(new PrintWriter(writer));
        return ((Object)writer).toString();
    }

    protected JTextArea createArea(String text) {
        JTextArea area = new JTextArea(text);
        area.setEditable(false);
        area.setCaretPosition(0);
        return area;
    }

    protected JTextArea createArea(Throwable tr) {
        if (tr.getMessage() != null) {
            return this.createArea(tr.getMessage());
        }
        return this.createArea(tr.toString());
    }

    public void actionPerformed(ActionEvent e) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        StringSelection sc = new StringSelection(this.getStackTrace(this.tr));
        Clipboard clip = tk.getSystemClipboard();
        clip.setContents(sc, null);
    }
}

