/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.laf;

import com.teacode.swing.CommonRB;
import com.teacode.swing.dialog.DialogSize;
import com.teacode.swing.laf.ContrastTheme;
import com.teacode.swing.laf.GreenTheme;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.plaf.metal.OceanTheme;

public class LAFChanger {
    private static Logger logger = Logger.getLogger(LAFChanger.class.getName());
    protected static String KEY = "laf";
    protected Class prefClass;
    protected String[] defaultsMAC = new String[]{"SYSTEM", "JGPLASTIC", "NIMBUS", "METAL_DEF"};
    protected String[] defaults = this.defaultsMAC;
    protected String currentLAF = null;
    protected List<LAFInfo> lafInfos = new ArrayList<LAFInfo>();
    protected JFrame frame;

    private boolean addLAF(String name, String title, String laf, String metalTheme) {
        try {
            Class.forName(laf);
            this.lafInfos.add(new LAFInfo(name, title, laf, metalTheme));
            logger.info(name + " (" + title + "): " + laf + " added");
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.warning(name + " (" + title + "): " + laf + " not found");
            return false;
        }
    }

    public LAFChanger(Class cl) {
        this.prefClass = cl;
        if (this.prefClass == null) {
            this.prefClass = this.getClass();
        }
        this.addLAF("SYSTEM", CommonRB.get("laf.system"), UIManager.getSystemLookAndFeelClassName(), null);
        this.addLAF("NIMBUS", CommonRB.get("laf.nimbus"), "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel", null);
        this.addLAF("METAL_DEF", CommonRB.get("laf.metal"), MetalLookAndFeel.class.getName(), DefaultMetalTheme.class.getName());
        this.addLAF("METAL_OCEAN", CommonRB.get("laf.metal.ocean"), MetalLookAndFeel.class.getName(), OceanTheme.class.getName());
        this.addLAF("METAL_GREEN", CommonRB.get("laf.metal.green"), MetalLookAndFeel.class.getName(), GreenTheme.class.getName());
        this.addLAF("METAL_CONTRAST", CommonRB.get("laf.metal.contrast"), MetalLookAndFeel.class.getName(), ContrastTheme.class.getName());
        this.addLAF("MOTIF", CommonRB.get("laf.motif"), "com.sun.java.swing.plaf.motif.MotifLookAndFeel", null);
        this.addLAF("JGWIN", "Windows (JG)", "com.jgoodies.looks.windows.WindowsLookAndFeel", null);
        this.addLAF("JGPLASTIC", CommonRB.get("laf.plastic") + " (JG)", "com.jgoodies.looks.plastic.PlasticLookAndFeel", null);
        this.addLAF("JG3D", CommonRB.get("laf.plastic") + "-3D (JG)", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel", null);
        this.addLAF("JGWIN", CommonRB.get("laf.plastic") + "-XP (JG)", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel", null);
        this.addLAF("LIQUID", CommonRB.get("laf.liquid"), "com.birosoft.liquid.LiquidLookAndFeel", null);
        String name = this.getPreferences().get(KEY, null);
        if (name == null || this.findLafInfo(name) == null) {
            String[] defs;
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS")) {
                logger.info("MacOS found");
                defs = this.defaultsMAC;
            } else {
                defs = this.defaults;
            }
            name = this.getDefault(defs);
            if (name != null) {
                logger.info("Default LAF: " + name);
            }
        }
        this.setLAF(null, name, true);
    }

    protected Preferences getPreferences() {
        return Preferences.userNodeForPackage(this.prefClass);
    }

    private String getDefault(String[] defs) {
        for (String def : defs) {
            if (this.findLafInfo(def) == null) continue;
            return def;
        }
        return null;
    }

    protected LAFInfo findLafInfo(String name) {
        for (LAFInfo lafInfo : this.lafInfos) {
            if (!lafInfo.getName().equals(name)) continue;
            return lafInfo;
        }
        logger.warning("LAF for " + name + " is not found");
        return null;
    }

    public String getLAF() {
        return this.currentLAF;
    }

    protected boolean setLAF(JFrame frame, String name, boolean asDefault) {
        if (name == null) {
            return false;
        }
        LAFInfo info = this.findLafInfo(name);
        if (info == null) {
            return false;
        }
        try {
            if (info.getMetalTheme() != null) {
                MetalLookAndFeel.setCurrentTheme((MetalTheme)Class.forName(info.getMetalTheme()).newInstance());
            }
            UIManager.setLookAndFeel(info.getLaf());
            if (frame != null) {
                SwingUtilities.updateComponentTreeUI(frame);
            }
            if (!asDefault) {
                this.getPreferences().put(KEY, info.getName());
            }
            this.currentLAF = info.getName();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, name, e);
            return false;
        }
    }

    public JMenu generateMenu(JFrame frame) {
        JMenu laf = new JMenu(CommonRB.get("laf.menu"));
        ButtonGroup group = new ButtonGroup();
        for (LAFInfo info : this.lafInfos) {
            JRadioButtonMenuItem i = new JRadioButtonMenuItem(info.getTitle());
            i.addActionListener(new LAFActionListener(frame, info.getName(), this));
            laf.add(i);
            group.add(i);
            if (!info.getName().equals(this.currentLAF)) continue;
            i.setSelected(true);
        }
        return laf;
    }

    public static void main(String[] args) {
        new LAFChanger(null);
        JFrame frame = new JFrame("test");
        JMenuBar bar = new JMenuBar();
        JMenuItem item = new JMenuItem("Test");
        JMenu menu = new JMenu("Menu");
        menu.add(item);
        bar.add(menu);
        frame.setDefaultCloseOperation(3);
        frame.setJMenuBar(bar);
        frame.setSize(DialogSize.calcViewSize());
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    protected static class LAFInfo {
        protected String name;
        protected String title;
        protected String laf;
        protected String metalTheme;

        public LAFInfo(String name, String title, String laf, String metalTheme) {
            this.name = name;
            this.title = title;
            this.laf = laf;
            this.metalTheme = metalTheme;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getLaf() {
            return this.laf;
        }

        public String getMetalTheme() {
            return this.metalTheme;
        }
    }

    protected static class LAFActionListener
    implements ActionListener {
        protected JFrame frame;
        protected String lafName;
        protected LAFChanger changer;

        public LAFActionListener(JFrame frame, String lafName, LAFChanger changer) {
            this.frame = frame;
            this.lafName = lafName;
            this.changer = changer;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.changer.setLAF(this.frame, this.lafName, false)) {
                JOptionPane.showMessageDialog(this.frame, CommonRB.get("laf.ok"), CommonRB.get("laf.title"), 1);
            } else {
                JOptionPane.showMessageDialog(this.frame, CommonRB.get("laf.error"), CommonRB.get("laf.title"), 0);
            }
        }
    }
}

