/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.table;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTableModel<D>
extends DefaultTableModel {
    protected List<D> data = new ArrayList<D>();

    protected BaseTableModel(String firstColumn, String ... columns) {
        this.addColumn(firstColumn);
        for (String column : columns) {
            this.addColumn(column);
        }
    }

    @Override
    public synchronized boolean isCellEditable(int row, int column) {
        return false;
    }

    public synchronized void addData(D d) {
        int index = this.data.size();
        this.data.add(d);
        this.addRow(new Vector(this.convertToRow(index, d)));
    }

    public synchronized void addDataSorted(D d, Comparator<D> comparator) {
        int len = this.data.size();
        for (int index = 0; index < len; ++index) {
            D rowD = this.data.get(index);
            if (comparator.compare(rowD, d) <= 0) continue;
            this.data.add(index, d);
            this.insertRow(index, new Vector(this.convertToRow(index, d)));
            return;
        }
        this.addData(d);
    }

    public synchronized void setData(int index, D d) {
        this.data.set(index, d);
        List<?> els = this.convertToRow(index, d);
        for (int t = 0; t < els.size(); ++t) {
            Object newV;
            Object v = this.getValueAt(index, t);
            if (v.equals(newV = els.get(t))) continue;
            this.setValueAt(newV, index, t);
        }
    }

    public synchronized D getData(int index) {
        return this.data.get(index);
    }

    public synchronized List<D> getAllData() {
        return new ArrayList<D>(this.data);
    }

    public synchronized void removeAllData() {
        int size = this.data.size();
        for (int t = 0; t < size; ++t) {
            this.removeRow(0);
        }
    }

    @Override
    public synchronized void removeRow(int index) {
        super.removeRow(index);
        this.data.remove(index);
    }

    public synchronized int simpleFindData(D d) {
        int t = 0;
        for (D d2 : this.data) {
            if (d2 == d) {
                return t;
            }
            ++t;
        }
        return -1;
    }

    protected abstract List<?> convertToRow(int var1, D var2);
}

