/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.tool;

import com.teacode.swing.dialog.DialogSize;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.prefs.Preferences;

public class PositionSizeSaver {
    protected static final String X = ".x";
    protected static final String Y = ".y";
    protected static final String WIDTH = ".width";
    protected static final String HEIGHT = ".height";
    protected static final String EXT_STATE = ".extstate";
    protected Frame frame;
    protected Preferences pref;
    protected String prefix;

    public PositionSizeSaver(Frame frame, Class prefClass, String prefix) {
        this.frame = frame;
        this.pref = Preferences.userNodeForPackage(prefClass);
        this.prefix = prefix;
    }

    protected static String getPrefix(Class cl) {
        String prefix = cl.getName();
        prefix = prefix.substring(prefix.lastIndexOf(46) + 1);
        return prefix;
    }

    public PositionSizeSaver(Frame frame, Class prefClass) {
        this(frame, prefClass, PositionSizeSaver.getPrefix(prefClass));
    }

    public PositionSizeSaver(Frame frame) {
        this(frame, frame.getClass());
    }

    protected void load() {
        Dimension dimension = DialogSize.calcViewSize();
        int defaultH = dimension.height;
        int defaultW = dimension.width;
        int x = this.pref.getInt(this.prefix + X, -1);
        int y = this.pref.getInt(this.prefix + Y, -1);
        int width = this.pref.getInt(this.prefix + WIDTH, defaultW);
        int height = this.pref.getInt(this.prefix + HEIGHT, defaultH);
        if (x != -1 && y != -1) {
            Rectangle rect = new Rectangle(x, y, width, height);
            Rectangle screen = new Rectangle();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice gd : ge.getScreenDevices()) {
                GraphicsConfiguration gc = gd.getDefaultConfiguration();
                screen = screen.union(gc.getBounds());
            }
            if (screen.contains(rect)) {
                this.frame.setSize(width, height);
                this.frame.setLocation(x, y);
                int state = this.pref.getInt(this.prefix + EXT_STATE, 0);
                this.frame.setExtendedState(state);
                return;
            }
        }
        this.frame.setSize(defaultW, defaultH);
        this.frame.setLocationRelativeTo(null);
        int state = this.pref.getInt(this.prefix + EXT_STATE, 0);
        this.frame.setExtendedState(state);
    }

    public void install() {
        this.load();
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent e) {
                Point p = PositionSizeSaver.this.frame.getLocation();
                PositionSizeSaver.this.pref.putInt(PositionSizeSaver.this.prefix + PositionSizeSaver.X, p.x);
                PositionSizeSaver.this.pref.putInt(PositionSizeSaver.this.prefix + PositionSizeSaver.Y, p.y);
            }

            public void componentResized(ComponentEvent e) {
                Dimension d = PositionSizeSaver.this.frame.getSize();
                PositionSizeSaver.this.pref.putInt(PositionSizeSaver.this.prefix + PositionSizeSaver.WIDTH, d.width);
                PositionSizeSaver.this.pref.putInt(PositionSizeSaver.this.prefix + PositionSizeSaver.HEIGHT, d.height);
            }
        });
        this.frame.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent e) {
                int status = PositionSizeSaver.this.frame.getExtendedState();
                PositionSizeSaver.this.pref.putInt(PositionSizeSaver.this.prefix + PositionSizeSaver.EXT_STATE, status &= 6);
            }
        });
    }
}

