/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.util;

import java.util.Arrays;

public class Hex {
    public static String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        int size = data.length;
        for (int t = 0; t < size; ++t) {
            String s = Integer.toHexString(data[t] & 0xFF);
            if (s.length() == 1) {
                sb.append('0');
            }
            sb.append(s);
        }
        if (sb.length() != data.length * 2) {
            throw new IllegalStateException(sb.length() + " != " + data.length);
        }
        return sb.toString();
    }

    public static byte[] fromHex(String hex) {
        int len = hex.length();
        if (len % 2 == 1) {
            throw new IllegalArgumentException("Hex string length must be even");
        }
        byte[] ret = new byte[len /= 2];
        for (int t = 0; t < len; ++t) {
            ret[t] = (byte)Integer.parseInt(hex.substring(t * 2, (t + 1) * 2), 16);
        }
        return ret;
    }

    public static void main(String[] args) {
        byte[] b = new byte[]{0, 1, 2, -1, -2};
        System.out.println(Arrays.toString(b));
        String t = Hex.toHex(b);
        System.out.println(t);
        System.out.println(Arrays.toString(Hex.fromHex(t)));
        System.out.println(Arrays.toString(Hex.fromHex("ff807f00FF807F00")));
    }
}

