/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.web;

import com.teacode.code.java.JavaString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamedCharReferences {
    protected static final Map<String, Character> map = new HashMap<String, Character>();

    protected static void r(String named, Character ch) {
        map.put(named, ch);
    }

    public static String process(String htmlText) {
        int len = htmlText.length();
        StringBuilder sb = new StringBuilder(len);
        StringBuilder entity = null;
        for (int t = 0; t < len; ++t) {
            char ch = htmlText.charAt(t);
            if (entity != null) {
                if (ch == ';') {
                    String entName = entity.toString();
                    Character entCh = map.get(entName);
                    if (entCh == null) {
                        sb.append("&").append(entName).append(";");
                    } else {
                        sb.append(entCh);
                    }
                    entity = null;
                    continue;
                }
                entity.append(ch);
                continue;
            }
            if (ch == '&') {
                entity = new StringBuilder();
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        String line;
        File file = new File("d:\\ch.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        HashMap<String, String> map = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("(\\S+)\\s+U\\+(\\S+).+");
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                String s = matcher.group(1).trim();
                String c = matcher.group(2).trim();
                if (s.endsWith(";")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.equalsIgnoreCase("lt") || s.equalsIgnoreCase("gt") || s.equalsIgnoreCase("apos") || s.equalsIgnoreCase("quot") || s.equalsIgnoreCase("amp")) continue;
                if (c.startsWith("0") && c.length() == 5) {
                    c = c.substring(1);
                    String oldC = (String)map.get(s);
                    if (oldC != null && !oldC.equals(c)) {
                        System.out.println("Warning: " + s + " -> " + oldC + " and " + c);
                    }
                    map.put(s, c);
                    continue;
                }
                System.out.println("Skipped (>ffff): " + line);
                continue;
            }
            System.out.println("Skipped (not matched): " + line);
        }
        ArrayList names = new ArrayList(map.keySet());
        Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
        System.out.println();
        System.out.println();
        for (String name : names) {
            String ch = (String)map.get(name);
            ch = ch.equalsIgnoreCase("000a") ? "\\n" : (ch.equalsIgnoreCase("000d") ? "\\r" : (ch.equalsIgnoreCase("005c") ? "\\\\" : "\\u" + ch));
            System.out.println("r(" + JavaString.javaString(name) + ", '" + ch + "');");
        }
    }

    static {
        NamedCharReferences.r("aacute", Character.valueOf('\u00e1'));
        NamedCharReferences.r("Aacute", Character.valueOf('\u00c1'));
        NamedCharReferences.r("Abreve", Character.valueOf('\u0102'));
        NamedCharReferences.r("abreve", Character.valueOf('\u0103'));
        NamedCharReferences.r("ac", Character.valueOf('\u223e'));
        NamedCharReferences.r("acd", Character.valueOf('\u223f'));
        NamedCharReferences.r("acE", Character.valueOf('\u223e'));
        NamedCharReferences.r("Acirc", Character.valueOf('\u00c2'));
        NamedCharReferences.r("acirc", Character.valueOf('\u00e2'));
        NamedCharReferences.r("acute", Character.valueOf('\u00b4'));
        NamedCharReferences.r("Acy", Character.valueOf('\u0410'));
        NamedCharReferences.r("acy", Character.valueOf('\u0430'));
        NamedCharReferences.r("aelig", Character.valueOf('\u00e6'));
        NamedCharReferences.r("AElig", Character.valueOf('\u00c6'));
        NamedCharReferences.r("af", Character.valueOf('\u2061'));
        NamedCharReferences.r("agrave", Character.valueOf('\u00e0'));
        NamedCharReferences.r("Agrave", Character.valueOf('\u00c0'));
        NamedCharReferences.r("alefsym", Character.valueOf('\u2135'));
        NamedCharReferences.r("aleph", Character.valueOf('\u2135'));
        NamedCharReferences.r("alpha", Character.valueOf('\u03b1'));
        NamedCharReferences.r("Alpha", Character.valueOf('\u0391'));
        NamedCharReferences.r("Amacr", Character.valueOf('\u0100'));
        NamedCharReferences.r("amacr", Character.valueOf('\u0101'));
        NamedCharReferences.r("amalg", Character.valueOf('\u2a3f'));
        NamedCharReferences.r("And", Character.valueOf('\u2a53'));
        NamedCharReferences.r("and", Character.valueOf('\u2227'));
        NamedCharReferences.r("andand", Character.valueOf('\u2a55'));
        NamedCharReferences.r("andd", Character.valueOf('\u2a5c'));
        NamedCharReferences.r("andslope", Character.valueOf('\u2a58'));
        NamedCharReferences.r("andv", Character.valueOf('\u2a5a'));
        NamedCharReferences.r("ang", Character.valueOf('\u2220'));
        NamedCharReferences.r("ange", Character.valueOf('\u29a4'));
        NamedCharReferences.r("angle", Character.valueOf('\u2220'));
        NamedCharReferences.r("angmsd", Character.valueOf('\u2221'));
        NamedCharReferences.r("angmsdaa", Character.valueOf('\u29a8'));
        NamedCharReferences.r("angmsdab", Character.valueOf('\u29a9'));
        NamedCharReferences.r("angmsdac", Character.valueOf('\u29aa'));
        NamedCharReferences.r("angmsdad", Character.valueOf('\u29ab'));
        NamedCharReferences.r("angmsdae", Character.valueOf('\u29ac'));
        NamedCharReferences.r("angmsdaf", Character.valueOf('\u29ad'));
        NamedCharReferences.r("angmsdag", Character.valueOf('\u29ae'));
        NamedCharReferences.r("angmsdah", Character.valueOf('\u29af'));
        NamedCharReferences.r("angrt", Character.valueOf('\u221f'));
        NamedCharReferences.r("angrtvb", Character.valueOf('\u22be'));
        NamedCharReferences.r("angrtvbd", Character.valueOf('\u299d'));
        NamedCharReferences.r("angsph", Character.valueOf('\u2222'));
        NamedCharReferences.r("angst", Character.valueOf('\u00c5'));
        NamedCharReferences.r("angzarr", Character.valueOf('\u237c'));
        NamedCharReferences.r("Aogon", Character.valueOf('\u0104'));
        NamedCharReferences.r("aogon", Character.valueOf('\u0105'));
        NamedCharReferences.r("ap", Character.valueOf('\u2248'));
        NamedCharReferences.r("apacir", Character.valueOf('\u2a6f'));
        NamedCharReferences.r("apE", Character.valueOf('\u2a70'));
        NamedCharReferences.r("ape", Character.valueOf('\u224a'));
        NamedCharReferences.r("apid", Character.valueOf('\u224b'));
        NamedCharReferences.r("ApplyFunction", Character.valueOf('\u2061'));
        NamedCharReferences.r("approx", Character.valueOf('\u2248'));
        NamedCharReferences.r("approxeq", Character.valueOf('\u224a'));
        NamedCharReferences.r("aring", Character.valueOf('\u00e5'));
        NamedCharReferences.r("Aring", Character.valueOf('\u00c5'));
        NamedCharReferences.r("Assign", Character.valueOf('\u2254'));
        NamedCharReferences.r("ast", Character.valueOf('*'));
        NamedCharReferences.r("asymp", Character.valueOf('\u2248'));
        NamedCharReferences.r("asympeq", Character.valueOf('\u224d'));
        NamedCharReferences.r("atilde", Character.valueOf('\u00e3'));
        NamedCharReferences.r("Atilde", Character.valueOf('\u00c3'));
        NamedCharReferences.r("auml", Character.valueOf('\u00e4'));
        NamedCharReferences.r("Auml", Character.valueOf('\u00c4'));
        NamedCharReferences.r("awconint", Character.valueOf('\u2233'));
        NamedCharReferences.r("awint", Character.valueOf('\u2a11'));
        NamedCharReferences.r("backcong", Character.valueOf('\u224c'));
        NamedCharReferences.r("backepsilon", Character.valueOf('\u03f6'));
        NamedCharReferences.r("backprime", Character.valueOf('\u2035'));
        NamedCharReferences.r("backsim", Character.valueOf('\u223d'));
        NamedCharReferences.r("backsimeq", Character.valueOf('\u22cd'));
        NamedCharReferences.r("Backslash", Character.valueOf('\u2216'));
        NamedCharReferences.r("Barv", Character.valueOf('\u2ae7'));
        NamedCharReferences.r("barvee", Character.valueOf('\u22bd'));
        NamedCharReferences.r("barwed", Character.valueOf('\u2305'));
        NamedCharReferences.r("Barwed", Character.valueOf('\u2306'));
        NamedCharReferences.r("barwedge", Character.valueOf('\u2305'));
        NamedCharReferences.r("bbrk", Character.valueOf('\u23b5'));
        NamedCharReferences.r("bbrktbrk", Character.valueOf('\u23b6'));
        NamedCharReferences.r("bcong", Character.valueOf('\u224c'));
        NamedCharReferences.r("Bcy", Character.valueOf('\u0411'));
        NamedCharReferences.r("bcy", Character.valueOf('\u0431'));
        NamedCharReferences.r("bdquo", Character.valueOf('\u201e'));
        NamedCharReferences.r("becaus", Character.valueOf('\u2235'));
        NamedCharReferences.r("because", Character.valueOf('\u2235'));
        NamedCharReferences.r("Because", Character.valueOf('\u2235'));
        NamedCharReferences.r("bemptyv", Character.valueOf('\u29b0'));
        NamedCharReferences.r("bepsi", Character.valueOf('\u03f6'));
        NamedCharReferences.r("bernou", Character.valueOf('\u212c'));
        NamedCharReferences.r("Bernoullis", Character.valueOf('\u212c'));
        NamedCharReferences.r("beta", Character.valueOf('\u03b2'));
        NamedCharReferences.r("Beta", Character.valueOf('\u0392'));
        NamedCharReferences.r("beth", Character.valueOf('\u2136'));
        NamedCharReferences.r("between", Character.valueOf('\u226c'));
        NamedCharReferences.r("bigcap", Character.valueOf('\u22c2'));
        NamedCharReferences.r("bigcirc", Character.valueOf('\u25ef'));
        NamedCharReferences.r("bigcup", Character.valueOf('\u22c3'));
        NamedCharReferences.r("bigodot", Character.valueOf('\u2a00'));
        NamedCharReferences.r("bigoplus", Character.valueOf('\u2a01'));
        NamedCharReferences.r("bigotimes", Character.valueOf('\u2a02'));
        NamedCharReferences.r("bigsqcup", Character.valueOf('\u2a06'));
        NamedCharReferences.r("bigstar", Character.valueOf('\u2605'));
        NamedCharReferences.r("bigtriangledown", Character.valueOf('\u25bd'));
        NamedCharReferences.r("bigtriangleup", Character.valueOf('\u25b3'));
        NamedCharReferences.r("biguplus", Character.valueOf('\u2a04'));
        NamedCharReferences.r("bigvee", Character.valueOf('\u22c1'));
        NamedCharReferences.r("bigwedge", Character.valueOf('\u22c0'));
        NamedCharReferences.r("bkarow", Character.valueOf('\u290d'));
        NamedCharReferences.r("blacklozenge", Character.valueOf('\u29eb'));
        NamedCharReferences.r("blacksquare", Character.valueOf('\u25aa'));
        NamedCharReferences.r("blacktriangle", Character.valueOf('\u25b4'));
        NamedCharReferences.r("blacktriangledown", Character.valueOf('\u25be'));
        NamedCharReferences.r("blacktriangleleft", Character.valueOf('\u25c2'));
        NamedCharReferences.r("blacktriangleright", Character.valueOf('\u25b8'));
        NamedCharReferences.r("blank", Character.valueOf('\u2423'));
        NamedCharReferences.r("blk12", Character.valueOf('\u2592'));
        NamedCharReferences.r("blk14", Character.valueOf('\u2591'));
        NamedCharReferences.r("blk34", Character.valueOf('\u2593'));
        NamedCharReferences.r("block", Character.valueOf('\u2588'));
        NamedCharReferences.r("bne", Character.valueOf('='));
        NamedCharReferences.r("bnequiv", Character.valueOf('\u2261'));
        NamedCharReferences.r("bnot", Character.valueOf('\u2310'));
        NamedCharReferences.r("bNot", Character.valueOf('\u2aed'));
        NamedCharReferences.r("bot", Character.valueOf('\u22a5'));
        NamedCharReferences.r("bottom", Character.valueOf('\u22a5'));
        NamedCharReferences.r("bowtie", Character.valueOf('\u22c8'));
        NamedCharReferences.r("boxbox", Character.valueOf('\u29c9'));
        NamedCharReferences.r("boxDl", Character.valueOf('\u2556'));
        NamedCharReferences.r("boxDL", Character.valueOf('\u2557'));
        NamedCharReferences.r("boxdL", Character.valueOf('\u2555'));
        NamedCharReferences.r("boxdl", Character.valueOf('\u2510'));
        NamedCharReferences.r("boxDr", Character.valueOf('\u2553'));
        NamedCharReferences.r("boxDR", Character.valueOf('\u2554'));
        NamedCharReferences.r("boxdR", Character.valueOf('\u2552'));
        NamedCharReferences.r("boxdr", Character.valueOf('\u250c'));
        NamedCharReferences.r("boxH", Character.valueOf('\u2550'));
        NamedCharReferences.r("boxh", Character.valueOf('\u2500'));
        NamedCharReferences.r("boxhD", Character.valueOf('\u2565'));
        NamedCharReferences.r("boxHd", Character.valueOf('\u2564'));
        NamedCharReferences.r("boxHD", Character.valueOf('\u2566'));
        NamedCharReferences.r("boxhd", Character.valueOf('\u252c'));
        NamedCharReferences.r("boxhU", Character.valueOf('\u2568'));
        NamedCharReferences.r("boxHu", Character.valueOf('\u2567'));
        NamedCharReferences.r("boxHU", Character.valueOf('\u2569'));
        NamedCharReferences.r("boxhu", Character.valueOf('\u2534'));
        NamedCharReferences.r("boxminus", Character.valueOf('\u229f'));
        NamedCharReferences.r("boxplus", Character.valueOf('\u229e'));
        NamedCharReferences.r("boxtimes", Character.valueOf('\u22a0'));
        NamedCharReferences.r("boxUl", Character.valueOf('\u255c'));
        NamedCharReferences.r("boxUL", Character.valueOf('\u255d'));
        NamedCharReferences.r("boxul", Character.valueOf('\u2518'));
        NamedCharReferences.r("boxuL", Character.valueOf('\u255b'));
        NamedCharReferences.r("boxUr", Character.valueOf('\u2559'));
        NamedCharReferences.r("boxUR", Character.valueOf('\u255a'));
        NamedCharReferences.r("boxur", Character.valueOf('\u2514'));
        NamedCharReferences.r("boxuR", Character.valueOf('\u2558'));
        NamedCharReferences.r("boxv", Character.valueOf('\u2502'));
        NamedCharReferences.r("boxV", Character.valueOf('\u2551'));
        NamedCharReferences.r("boxVh", Character.valueOf('\u256b'));
        NamedCharReferences.r("boxVH", Character.valueOf('\u256c'));
        NamedCharReferences.r("boxvh", Character.valueOf('\u253c'));
        NamedCharReferences.r("boxvH", Character.valueOf('\u256a'));
        NamedCharReferences.r("boxVl", Character.valueOf('\u2562'));
        NamedCharReferences.r("boxVL", Character.valueOf('\u2563'));
        NamedCharReferences.r("boxvL", Character.valueOf('\u2561'));
        NamedCharReferences.r("boxvl", Character.valueOf('\u2524'));
        NamedCharReferences.r("boxVr", Character.valueOf('\u255f'));
        NamedCharReferences.r("boxVR", Character.valueOf('\u2560'));
        NamedCharReferences.r("boxvR", Character.valueOf('\u255e'));
        NamedCharReferences.r("boxvr", Character.valueOf('\u251c'));
        NamedCharReferences.r("bprime", Character.valueOf('\u2035'));
        NamedCharReferences.r("breve", Character.valueOf('\u02d8'));
        NamedCharReferences.r("Breve", Character.valueOf('\u02d8'));
        NamedCharReferences.r("brvbar", Character.valueOf('\u00a6'));
        NamedCharReferences.r("Bscr", Character.valueOf('\u212c'));
        NamedCharReferences.r("bsemi", Character.valueOf('\u204f'));
        NamedCharReferences.r("bsim", Character.valueOf('\u223d'));
        NamedCharReferences.r("bsime", Character.valueOf('\u22cd'));
        NamedCharReferences.r("bsol", Character.valueOf('\\'));
        NamedCharReferences.r("bsolb", Character.valueOf('\u29c5'));
        NamedCharReferences.r("bsolhsub", Character.valueOf('\u27c8'));
        NamedCharReferences.r("bull", Character.valueOf('\u2022'));
        NamedCharReferences.r("bullet", Character.valueOf('\u2022'));
        NamedCharReferences.r("bump", Character.valueOf('\u224e'));
        NamedCharReferences.r("bumpe", Character.valueOf('\u224f'));
        NamedCharReferences.r("bumpE", Character.valueOf('\u2aae'));
        NamedCharReferences.r("bumpeq", Character.valueOf('\u224f'));
        NamedCharReferences.r("Bumpeq", Character.valueOf('\u224e'));
        NamedCharReferences.r("cacute", Character.valueOf('\u0107'));
        NamedCharReferences.r("Cacute", Character.valueOf('\u0106'));
        NamedCharReferences.r("Cap", Character.valueOf('\u22d2'));
        NamedCharReferences.r("cap", Character.valueOf('\u2229'));
        NamedCharReferences.r("capand", Character.valueOf('\u2a44'));
        NamedCharReferences.r("capbrcup", Character.valueOf('\u2a49'));
        NamedCharReferences.r("capcap", Character.valueOf('\u2a4b'));
        NamedCharReferences.r("capcup", Character.valueOf('\u2a47'));
        NamedCharReferences.r("capdot", Character.valueOf('\u2a40'));
        NamedCharReferences.r("CapitalDifferentialD", Character.valueOf('\u2145'));
        NamedCharReferences.r("caps", Character.valueOf('\u2229'));
        NamedCharReferences.r("caret", Character.valueOf('\u2041'));
        NamedCharReferences.r("caron", Character.valueOf('\u02c7'));
        NamedCharReferences.r("Cayleys", Character.valueOf('\u212d'));
        NamedCharReferences.r("ccaps", Character.valueOf('\u2a4d'));
        NamedCharReferences.r("Ccaron", Character.valueOf('\u010c'));
        NamedCharReferences.r("ccaron", Character.valueOf('\u010d'));
        NamedCharReferences.r("ccedil", Character.valueOf('\u00e7'));
        NamedCharReferences.r("Ccedil", Character.valueOf('\u00c7'));
        NamedCharReferences.r("Ccirc", Character.valueOf('\u0108'));
        NamedCharReferences.r("ccirc", Character.valueOf('\u0109'));
        NamedCharReferences.r("Cconint", Character.valueOf('\u2230'));
        NamedCharReferences.r("ccups", Character.valueOf('\u2a4c'));
        NamedCharReferences.r("ccupssm", Character.valueOf('\u2a50'));
        NamedCharReferences.r("cdot", Character.valueOf('\u010b'));
        NamedCharReferences.r("Cdot", Character.valueOf('\u010a'));
        NamedCharReferences.r("cedil", Character.valueOf('\u00b8'));
        NamedCharReferences.r("Cedilla", Character.valueOf('\u00b8'));
        NamedCharReferences.r("cemptyv", Character.valueOf('\u29b2'));
        NamedCharReferences.r("cent", Character.valueOf('\u00a2'));
        NamedCharReferences.r("CenterDot", Character.valueOf('\u00b7'));
        NamedCharReferences.r("centerdot", Character.valueOf('\u00b7'));
        NamedCharReferences.r("Cfr", Character.valueOf('\u212d'));
        NamedCharReferences.r("chcy", Character.valueOf('\u0447'));
        NamedCharReferences.r("CHcy", Character.valueOf('\u0427'));
        NamedCharReferences.r("check", Character.valueOf('\u2713'));
        NamedCharReferences.r("checkmark", Character.valueOf('\u2713'));
        NamedCharReferences.r("Chi", Character.valueOf('\u03a7'));
        NamedCharReferences.r("chi", Character.valueOf('\u03c7'));
        NamedCharReferences.r("cir", Character.valueOf('\u25cb'));
        NamedCharReferences.r("circ", Character.valueOf('\u02c6'));
        NamedCharReferences.r("circeq", Character.valueOf('\u2257'));
        NamedCharReferences.r("circlearrowleft", Character.valueOf('\u21ba'));
        NamedCharReferences.r("circlearrowright", Character.valueOf('\u21bb'));
        NamedCharReferences.r("circledast", Character.valueOf('\u229b'));
        NamedCharReferences.r("circledcirc", Character.valueOf('\u229a'));
        NamedCharReferences.r("circleddash", Character.valueOf('\u229d'));
        NamedCharReferences.r("CircleDot", Character.valueOf('\u2299'));
        NamedCharReferences.r("circledR", Character.valueOf('\u00ae'));
        NamedCharReferences.r("circledS", Character.valueOf('\u24c8'));
        NamedCharReferences.r("CircleMinus", Character.valueOf('\u2296'));
        NamedCharReferences.r("CirclePlus", Character.valueOf('\u2295'));
        NamedCharReferences.r("CircleTimes", Character.valueOf('\u2297'));
        NamedCharReferences.r("cirE", Character.valueOf('\u29c3'));
        NamedCharReferences.r("cire", Character.valueOf('\u2257'));
        NamedCharReferences.r("cirfnint", Character.valueOf('\u2a10'));
        NamedCharReferences.r("cirmid", Character.valueOf('\u2aef'));
        NamedCharReferences.r("cirscir", Character.valueOf('\u29c2'));
        NamedCharReferences.r("ClockwiseContourIntegral", Character.valueOf('\u2232'));
        NamedCharReferences.r("CloseCurlyDoubleQuote", Character.valueOf('\u201d'));
        NamedCharReferences.r("CloseCurlyQuote", Character.valueOf('\u2019'));
        NamedCharReferences.r("clubs", Character.valueOf('\u2663'));
        NamedCharReferences.r("clubsuit", Character.valueOf('\u2663'));
        NamedCharReferences.r("Colon", Character.valueOf('\u2237'));
        NamedCharReferences.r("colon", Character.valueOf(':'));
        NamedCharReferences.r("colone", Character.valueOf('\u2254'));
        NamedCharReferences.r("Colone", Character.valueOf('\u2a74'));
        NamedCharReferences.r("coloneq", Character.valueOf('\u2254'));
        NamedCharReferences.r("comma", Character.valueOf(','));
        NamedCharReferences.r("commat", Character.valueOf('@'));
        NamedCharReferences.r("comp", Character.valueOf('\u2201'));
        NamedCharReferences.r("compfn", Character.valueOf('\u2218'));
        NamedCharReferences.r("complement", Character.valueOf('\u2201'));
        NamedCharReferences.r("complexes", Character.valueOf('\u2102'));
        NamedCharReferences.r("cong", Character.valueOf('\u2245'));
        NamedCharReferences.r("congdot", Character.valueOf('\u2a6d'));
        NamedCharReferences.r("Congruent", Character.valueOf('\u2261'));
        NamedCharReferences.r("conint", Character.valueOf('\u222e'));
        NamedCharReferences.r("Conint", Character.valueOf('\u222f'));
        NamedCharReferences.r("ContourIntegral", Character.valueOf('\u222e'));
        NamedCharReferences.r("Copf", Character.valueOf('\u2102'));
        NamedCharReferences.r("coprod", Character.valueOf('\u2210'));
        NamedCharReferences.r("Coproduct", Character.valueOf('\u2210'));
        NamedCharReferences.r("COPY", Character.valueOf('\u00a9'));
        NamedCharReferences.r("copy", Character.valueOf('\u00a9'));
        NamedCharReferences.r("copysr", Character.valueOf('\u2117'));
        NamedCharReferences.r("CounterClockwiseContourIntegral", Character.valueOf('\u2233'));
        NamedCharReferences.r("crarr", Character.valueOf('\u21b5'));
        NamedCharReferences.r("Cross", Character.valueOf('\u2a2f'));
        NamedCharReferences.r("cross", Character.valueOf('\u2717'));
        NamedCharReferences.r("csub", Character.valueOf('\u2acf'));
        NamedCharReferences.r("csube", Character.valueOf('\u2ad1'));
        NamedCharReferences.r("csup", Character.valueOf('\u2ad0'));
        NamedCharReferences.r("csupe", Character.valueOf('\u2ad2'));
        NamedCharReferences.r("ctdot", Character.valueOf('\u22ef'));
        NamedCharReferences.r("cudarrl", Character.valueOf('\u2938'));
        NamedCharReferences.r("cudarrr", Character.valueOf('\u2935'));
        NamedCharReferences.r("cuepr", Character.valueOf('\u22de'));
        NamedCharReferences.r("cuesc", Character.valueOf('\u22df'));
        NamedCharReferences.r("cularr", Character.valueOf('\u21b6'));
        NamedCharReferences.r("cularrp", Character.valueOf('\u293d'));
        NamedCharReferences.r("Cup", Character.valueOf('\u22d3'));
        NamedCharReferences.r("cup", Character.valueOf('\u222a'));
        NamedCharReferences.r("cupbrcap", Character.valueOf('\u2a48'));
        NamedCharReferences.r("cupcap", Character.valueOf('\u2a46'));
        NamedCharReferences.r("CupCap", Character.valueOf('\u224d'));
        NamedCharReferences.r("cupcup", Character.valueOf('\u2a4a'));
        NamedCharReferences.r("cupdot", Character.valueOf('\u228d'));
        NamedCharReferences.r("cupor", Character.valueOf('\u2a45'));
        NamedCharReferences.r("cups", Character.valueOf('\u222a'));
        NamedCharReferences.r("curarr", Character.valueOf('\u21b7'));
        NamedCharReferences.r("curarrm", Character.valueOf('\u293c'));
        NamedCharReferences.r("curlyeqprec", Character.valueOf('\u22de'));
        NamedCharReferences.r("curlyeqsucc", Character.valueOf('\u22df'));
        NamedCharReferences.r("curlyvee", Character.valueOf('\u22ce'));
        NamedCharReferences.r("curlywedge", Character.valueOf('\u22cf'));
        NamedCharReferences.r("curren", Character.valueOf('\u00a4'));
        NamedCharReferences.r("curvearrowleft", Character.valueOf('\u21b6'));
        NamedCharReferences.r("curvearrowright", Character.valueOf('\u21b7'));
        NamedCharReferences.r("cuvee", Character.valueOf('\u22ce'));
        NamedCharReferences.r("cuwed", Character.valueOf('\u22cf'));
        NamedCharReferences.r("cwconint", Character.valueOf('\u2232'));
        NamedCharReferences.r("cwint", Character.valueOf('\u2231'));
        NamedCharReferences.r("cylcty", Character.valueOf('\u232d'));
        NamedCharReferences.r("dagger", Character.valueOf('\u2020'));
        NamedCharReferences.r("Dagger", Character.valueOf('\u2021'));
        NamedCharReferences.r("daleth", Character.valueOf('\u2138'));
        NamedCharReferences.r("Darr", Character.valueOf('\u21a1'));
        NamedCharReferences.r("dArr", Character.valueOf('\u21d3'));
        NamedCharReferences.r("darr", Character.valueOf('\u2193'));
        NamedCharReferences.r("dash", Character.valueOf('\u2010'));
        NamedCharReferences.r("dashv", Character.valueOf('\u22a3'));
        NamedCharReferences.r("Dashv", Character.valueOf('\u2ae4'));
        NamedCharReferences.r("dbkarow", Character.valueOf('\u290f'));
        NamedCharReferences.r("dblac", Character.valueOf('\u02dd'));
        NamedCharReferences.r("Dcaron", Character.valueOf('\u010e'));
        NamedCharReferences.r("dcaron", Character.valueOf('\u010f'));
        NamedCharReferences.r("dcy", Character.valueOf('\u0434'));
        NamedCharReferences.r("Dcy", Character.valueOf('\u0414'));
        NamedCharReferences.r("DD", Character.valueOf('\u2145'));
        NamedCharReferences.r("dd", Character.valueOf('\u2146'));
        NamedCharReferences.r("ddagger", Character.valueOf('\u2021'));
        NamedCharReferences.r("ddarr", Character.valueOf('\u21ca'));
        NamedCharReferences.r("DDotrahd", Character.valueOf('\u2911'));
        NamedCharReferences.r("ddotseq", Character.valueOf('\u2a77'));
        NamedCharReferences.r("deg", Character.valueOf('\u00b0'));
        NamedCharReferences.r("Del", Character.valueOf('\u2207'));
        NamedCharReferences.r("Delta", Character.valueOf('\u0394'));
        NamedCharReferences.r("delta", Character.valueOf('\u03b4'));
        NamedCharReferences.r("demptyv", Character.valueOf('\u29b1'));
        NamedCharReferences.r("dfisht", Character.valueOf('\u297f'));
        NamedCharReferences.r("dHar", Character.valueOf('\u2965'));
        NamedCharReferences.r("dharl", Character.valueOf('\u21c3'));
        NamedCharReferences.r("dharr", Character.valueOf('\u21c2'));
        NamedCharReferences.r("DiacriticalAcute", Character.valueOf('\u00b4'));
        NamedCharReferences.r("DiacriticalDot", Character.valueOf('\u02d9'));
        NamedCharReferences.r("DiacriticalDoubleAcute", Character.valueOf('\u02dd'));
        NamedCharReferences.r("DiacriticalGrave", Character.valueOf('`'));
        NamedCharReferences.r("DiacriticalTilde", Character.valueOf('\u02dc'));
        NamedCharReferences.r("diam", Character.valueOf('\u22c4'));
        NamedCharReferences.r("Diamond", Character.valueOf('\u22c4'));
        NamedCharReferences.r("diamond", Character.valueOf('\u22c4'));
        NamedCharReferences.r("diamondsuit", Character.valueOf('\u2666'));
        NamedCharReferences.r("diams", Character.valueOf('\u2666'));
        NamedCharReferences.r("die", Character.valueOf('\u00a8'));
        NamedCharReferences.r("DifferentialD", Character.valueOf('\u2146'));
        NamedCharReferences.r("digamma", Character.valueOf('\u03dd'));
        NamedCharReferences.r("disin", Character.valueOf('\u22f2'));
        NamedCharReferences.r("div", Character.valueOf('\u00f7'));
        NamedCharReferences.r("divide", Character.valueOf('\u00f7'));
        NamedCharReferences.r("divideontimes", Character.valueOf('\u22c7'));
        NamedCharReferences.r("divonx", Character.valueOf('\u22c7'));
        NamedCharReferences.r("djcy", Character.valueOf('\u0452'));
        NamedCharReferences.r("DJcy", Character.valueOf('\u0402'));
        NamedCharReferences.r("dlcorn", Character.valueOf('\u231e'));
        NamedCharReferences.r("dlcrop", Character.valueOf('\u230d'));
        NamedCharReferences.r("dollar", Character.valueOf('$'));
        NamedCharReferences.r("dot", Character.valueOf('\u02d9'));
        NamedCharReferences.r("Dot", Character.valueOf('\u00a8'));
        NamedCharReferences.r("DotDot", Character.valueOf('\u20dc'));
        NamedCharReferences.r("doteq", Character.valueOf('\u2250'));
        NamedCharReferences.r("doteqdot", Character.valueOf('\u2251'));
        NamedCharReferences.r("DotEqual", Character.valueOf('\u2250'));
        NamedCharReferences.r("dotminus", Character.valueOf('\u2238'));
        NamedCharReferences.r("dotplus", Character.valueOf('\u2214'));
        NamedCharReferences.r("dotsquare", Character.valueOf('\u22a1'));
        NamedCharReferences.r("doublebarwedge", Character.valueOf('\u2306'));
        NamedCharReferences.r("DoubleContourIntegral", Character.valueOf('\u222f'));
        NamedCharReferences.r("DoubleDot", Character.valueOf('\u00a8'));
        NamedCharReferences.r("DoubleDownArrow", Character.valueOf('\u21d3'));
        NamedCharReferences.r("DoubleLeftArrow", Character.valueOf('\u21d0'));
        NamedCharReferences.r("DoubleLeftRightArrow", Character.valueOf('\u21d4'));
        NamedCharReferences.r("DoubleLeftTee", Character.valueOf('\u2ae4'));
        NamedCharReferences.r("DoubleLongLeftArrow", Character.valueOf('\u27f8'));
        NamedCharReferences.r("DoubleLongLeftRightArrow", Character.valueOf('\u27fa'));
        NamedCharReferences.r("DoubleLongRightArrow", Character.valueOf('\u27f9'));
        NamedCharReferences.r("DoubleRightArrow", Character.valueOf('\u21d2'));
        NamedCharReferences.r("DoubleRightTee", Character.valueOf('\u22a8'));
        NamedCharReferences.r("DoubleUpArrow", Character.valueOf('\u21d1'));
        NamedCharReferences.r("DoubleUpDownArrow", Character.valueOf('\u21d5'));
        NamedCharReferences.r("DoubleVerticalBar", Character.valueOf('\u2225'));
        NamedCharReferences.r("downarrow", Character.valueOf('\u2193'));
        NamedCharReferences.r("Downarrow", Character.valueOf('\u21d3'));
        NamedCharReferences.r("DownArrow", Character.valueOf('\u2193'));
        NamedCharReferences.r("DownArrowBar", Character.valueOf('\u2913'));
        NamedCharReferences.r("DownArrowUpArrow", Character.valueOf('\u21f5'));
        NamedCharReferences.r("DownBreve", Character.valueOf('\u0311'));
        NamedCharReferences.r("downdownarrows", Character.valueOf('\u21ca'));
        NamedCharReferences.r("downharpoonleft", Character.valueOf('\u21c3'));
        NamedCharReferences.r("downharpoonright", Character.valueOf('\u21c2'));
        NamedCharReferences.r("DownLeftRightVector", Character.valueOf('\u2950'));
        NamedCharReferences.r("DownLeftTeeVector", Character.valueOf('\u295e'));
        NamedCharReferences.r("DownLeftVector", Character.valueOf('\u21bd'));
        NamedCharReferences.r("DownLeftVectorBar", Character.valueOf('\u2956'));
        NamedCharReferences.r("DownRightTeeVector", Character.valueOf('\u295f'));
        NamedCharReferences.r("DownRightVector", Character.valueOf('\u21c1'));
        NamedCharReferences.r("DownRightVectorBar", Character.valueOf('\u2957'));
        NamedCharReferences.r("DownTee", Character.valueOf('\u22a4'));
        NamedCharReferences.r("DownTeeArrow", Character.valueOf('\u21a7'));
        NamedCharReferences.r("drbkarow", Character.valueOf('\u2910'));
        NamedCharReferences.r("drcorn", Character.valueOf('\u231f'));
        NamedCharReferences.r("drcrop", Character.valueOf('\u230c'));
        NamedCharReferences.r("DScy", Character.valueOf('\u0405'));
        NamedCharReferences.r("dscy", Character.valueOf('\u0455'));
        NamedCharReferences.r("dsol", Character.valueOf('\u29f6'));
        NamedCharReferences.r("Dstrok", Character.valueOf('\u0110'));
        NamedCharReferences.r("dstrok", Character.valueOf('\u0111'));
        NamedCharReferences.r("dtdot", Character.valueOf('\u22f1'));
        NamedCharReferences.r("dtri", Character.valueOf('\u25bf'));
        NamedCharReferences.r("dtrif", Character.valueOf('\u25be'));
        NamedCharReferences.r("duarr", Character.valueOf('\u21f5'));
        NamedCharReferences.r("duhar", Character.valueOf('\u296f'));
        NamedCharReferences.r("dwangle", Character.valueOf('\u29a6'));
        NamedCharReferences.r("DZcy", Character.valueOf('\u040f'));
        NamedCharReferences.r("dzcy", Character.valueOf('\u045f'));
        NamedCharReferences.r("dzigrarr", Character.valueOf('\u27ff'));
        NamedCharReferences.r("eacute", Character.valueOf('\u00e9'));
        NamedCharReferences.r("Eacute", Character.valueOf('\u00c9'));
        NamedCharReferences.r("easter", Character.valueOf('\u2a6e'));
        NamedCharReferences.r("Ecaron", Character.valueOf('\u011a'));
        NamedCharReferences.r("ecaron", Character.valueOf('\u011b'));
        NamedCharReferences.r("ecir", Character.valueOf('\u2256'));
        NamedCharReferences.r("ecirc", Character.valueOf('\u00ea'));
        NamedCharReferences.r("Ecirc", Character.valueOf('\u00ca'));
        NamedCharReferences.r("ecolon", Character.valueOf('\u2255'));
        NamedCharReferences.r("ecy", Character.valueOf('\u044d'));
        NamedCharReferences.r("Ecy", Character.valueOf('\u042d'));
        NamedCharReferences.r("eDDot", Character.valueOf('\u2a77'));
        NamedCharReferences.r("edot", Character.valueOf('\u0117'));
        NamedCharReferences.r("eDot", Character.valueOf('\u2251'));
        NamedCharReferences.r("Edot", Character.valueOf('\u0116'));
        NamedCharReferences.r("ee", Character.valueOf('\u2147'));
        NamedCharReferences.r("efDot", Character.valueOf('\u2252'));
        NamedCharReferences.r("eg", Character.valueOf('\u2a9a'));
        NamedCharReferences.r("Egrave", Character.valueOf('\u00c8'));
        NamedCharReferences.r("egrave", Character.valueOf('\u00e8'));
        NamedCharReferences.r("egs", Character.valueOf('\u2a96'));
        NamedCharReferences.r("egsdot", Character.valueOf('\u2a98'));
        NamedCharReferences.r("el", Character.valueOf('\u2a99'));
        NamedCharReferences.r("Element", Character.valueOf('\u2208'));
        NamedCharReferences.r("elinters", Character.valueOf('\u23e7'));
        NamedCharReferences.r("ell", Character.valueOf('\u2113'));
        NamedCharReferences.r("els", Character.valueOf('\u2a95'));
        NamedCharReferences.r("elsdot", Character.valueOf('\u2a97'));
        NamedCharReferences.r("emacr", Character.valueOf('\u0113'));
        NamedCharReferences.r("Emacr", Character.valueOf('\u0112'));
        NamedCharReferences.r("empty", Character.valueOf('\u2205'));
        NamedCharReferences.r("emptyset", Character.valueOf('\u2205'));
        NamedCharReferences.r("EmptySmallSquare", Character.valueOf('\u25fb'));
        NamedCharReferences.r("emptyv", Character.valueOf('\u2205'));
        NamedCharReferences.r("EmptyVerySmallSquare", Character.valueOf('\u25ab'));
        NamedCharReferences.r("emsp", Character.valueOf('\u2003'));
        NamedCharReferences.r("emsp13", Character.valueOf('\u2004'));
        NamedCharReferences.r("emsp14", Character.valueOf('\u2005'));
        NamedCharReferences.r("eng", Character.valueOf('\u014b'));
        NamedCharReferences.r("ENG", Character.valueOf('\u014a'));
        NamedCharReferences.r("ensp", Character.valueOf('\u2002'));
        NamedCharReferences.r("eogon", Character.valueOf('\u0119'));
        NamedCharReferences.r("Eogon", Character.valueOf('\u0118'));
        NamedCharReferences.r("epar", Character.valueOf('\u22d5'));
        NamedCharReferences.r("eparsl", Character.valueOf('\u29e3'));
        NamedCharReferences.r("eplus", Character.valueOf('\u2a71'));
        NamedCharReferences.r("epsi", Character.valueOf('\u03b5'));
        NamedCharReferences.r("Epsilon", Character.valueOf('\u0395'));
        NamedCharReferences.r("epsilon", Character.valueOf('\u03b5'));
        NamedCharReferences.r("epsiv", Character.valueOf('\u03f5'));
        NamedCharReferences.r("eqcirc", Character.valueOf('\u2256'));
        NamedCharReferences.r("eqcolon", Character.valueOf('\u2255'));
        NamedCharReferences.r("eqsim", Character.valueOf('\u2242'));
        NamedCharReferences.r("eqslantgtr", Character.valueOf('\u2a96'));
        NamedCharReferences.r("eqslantless", Character.valueOf('\u2a95'));
        NamedCharReferences.r("Equal", Character.valueOf('\u2a75'));
        NamedCharReferences.r("equals", Character.valueOf('='));
        NamedCharReferences.r("EqualTilde", Character.valueOf('\u2242'));
        NamedCharReferences.r("equest", Character.valueOf('\u225f'));
        NamedCharReferences.r("Equilibrium", Character.valueOf('\u21cc'));
        NamedCharReferences.r("equiv", Character.valueOf('\u2261'));
        NamedCharReferences.r("equivDD", Character.valueOf('\u2a78'));
        NamedCharReferences.r("eqvparsl", Character.valueOf('\u29e5'));
        NamedCharReferences.r("erarr", Character.valueOf('\u2971'));
        NamedCharReferences.r("erDot", Character.valueOf('\u2253'));
        NamedCharReferences.r("escr", Character.valueOf('\u212f'));
        NamedCharReferences.r("Escr", Character.valueOf('\u2130'));
        NamedCharReferences.r("esdot", Character.valueOf('\u2250'));
        NamedCharReferences.r("esim", Character.valueOf('\u2242'));
        NamedCharReferences.r("Esim", Character.valueOf('\u2a73'));
        NamedCharReferences.r("eta", Character.valueOf('\u03b7'));
        NamedCharReferences.r("Eta", Character.valueOf('\u0397'));
        NamedCharReferences.r("eth", Character.valueOf('\u00f0'));
        NamedCharReferences.r("ETH", Character.valueOf('\u00d0'));
        NamedCharReferences.r("Euml", Character.valueOf('\u00cb'));
        NamedCharReferences.r("euml", Character.valueOf('\u00eb'));
        NamedCharReferences.r("euro", Character.valueOf('\u20ac'));
        NamedCharReferences.r("excl", Character.valueOf('!'));
        NamedCharReferences.r("exist", Character.valueOf('\u2203'));
        NamedCharReferences.r("Exists", Character.valueOf('\u2203'));
        NamedCharReferences.r("expectation", Character.valueOf('\u2130'));
        NamedCharReferences.r("exponentiale", Character.valueOf('\u2147'));
        NamedCharReferences.r("ExponentialE", Character.valueOf('\u2147'));
        NamedCharReferences.r("fallingdotseq", Character.valueOf('\u2252'));
        NamedCharReferences.r("Fcy", Character.valueOf('\u0424'));
        NamedCharReferences.r("fcy", Character.valueOf('\u0444'));
        NamedCharReferences.r("female", Character.valueOf('\u2640'));
        NamedCharReferences.r("ffilig", Character.valueOf('\ufb03'));
        NamedCharReferences.r("fflig", Character.valueOf('\ufb00'));
        NamedCharReferences.r("ffllig", Character.valueOf('\ufb04'));
        NamedCharReferences.r("filig", Character.valueOf('\ufb01'));
        NamedCharReferences.r("FilledSmallSquare", Character.valueOf('\u25fc'));
        NamedCharReferences.r("FilledVerySmallSquare", Character.valueOf('\u25aa'));
        NamedCharReferences.r("fjlig", Character.valueOf('f'));
        NamedCharReferences.r("flat", Character.valueOf('\u266d'));
        NamedCharReferences.r("fllig", Character.valueOf('\ufb02'));
        NamedCharReferences.r("fltns", Character.valueOf('\u25b1'));
        NamedCharReferences.r("fnof", Character.valueOf('\u0192'));
        NamedCharReferences.r("forall", Character.valueOf('\u2200'));
        NamedCharReferences.r("ForAll", Character.valueOf('\u2200'));
        NamedCharReferences.r("fork", Character.valueOf('\u22d4'));
        NamedCharReferences.r("forkv", Character.valueOf('\u2ad9'));
        NamedCharReferences.r("Fouriertrf", Character.valueOf('\u2131'));
        NamedCharReferences.r("fpartint", Character.valueOf('\u2a0d'));
        NamedCharReferences.r("frac12", Character.valueOf('\u00bd'));
        NamedCharReferences.r("frac13", Character.valueOf('\u2153'));
        NamedCharReferences.r("frac14", Character.valueOf('\u00bc'));
        NamedCharReferences.r("frac15", Character.valueOf('\u2155'));
        NamedCharReferences.r("frac16", Character.valueOf('\u2159'));
        NamedCharReferences.r("frac18", Character.valueOf('\u215b'));
        NamedCharReferences.r("frac23", Character.valueOf('\u2154'));
        NamedCharReferences.r("frac25", Character.valueOf('\u2156'));
        NamedCharReferences.r("frac34", Character.valueOf('\u00be'));
        NamedCharReferences.r("frac35", Character.valueOf('\u2157'));
        NamedCharReferences.r("frac38", Character.valueOf('\u215c'));
        NamedCharReferences.r("frac45", Character.valueOf('\u2158'));
        NamedCharReferences.r("frac56", Character.valueOf('\u215a'));
        NamedCharReferences.r("frac58", Character.valueOf('\u215d'));
        NamedCharReferences.r("frac78", Character.valueOf('\u215e'));
        NamedCharReferences.r("frasl", Character.valueOf('\u2044'));
        NamedCharReferences.r("frown", Character.valueOf('\u2322'));
        NamedCharReferences.r("Fscr", Character.valueOf('\u2131'));
        NamedCharReferences.r("gacute", Character.valueOf('\u01f5'));
        NamedCharReferences.r("gamma", Character.valueOf('\u03b3'));
        NamedCharReferences.r("Gamma", Character.valueOf('\u0393'));
        NamedCharReferences.r("gammad", Character.valueOf('\u03dd'));
        NamedCharReferences.r("Gammad", Character.valueOf('\u03dc'));
        NamedCharReferences.r("gap", Character.valueOf('\u2a86'));
        NamedCharReferences.r("Gbreve", Character.valueOf('\u011e'));
        NamedCharReferences.r("gbreve", Character.valueOf('\u011f'));
        NamedCharReferences.r("Gcedil", Character.valueOf('\u0122'));
        NamedCharReferences.r("gcirc", Character.valueOf('\u011d'));
        NamedCharReferences.r("Gcirc", Character.valueOf('\u011c'));
        NamedCharReferences.r("gcy", Character.valueOf('\u0433'));
        NamedCharReferences.r("Gcy", Character.valueOf('\u0413'));
        NamedCharReferences.r("gdot", Character.valueOf('\u0121'));
        NamedCharReferences.r("Gdot", Character.valueOf('\u0120'));
        NamedCharReferences.r("ge", Character.valueOf('\u2265'));
        NamedCharReferences.r("gE", Character.valueOf('\u2267'));
        NamedCharReferences.r("gEl", Character.valueOf('\u2a8c'));
        NamedCharReferences.r("gel", Character.valueOf('\u22db'));
        NamedCharReferences.r("geq", Character.valueOf('\u2265'));
        NamedCharReferences.r("geqq", Character.valueOf('\u2267'));
        NamedCharReferences.r("geqslant", Character.valueOf('\u2a7e'));
        NamedCharReferences.r("ges", Character.valueOf('\u2a7e'));
        NamedCharReferences.r("gescc", Character.valueOf('\u2aa9'));
        NamedCharReferences.r("gesdot", Character.valueOf('\u2a80'));
        NamedCharReferences.r("gesdoto", Character.valueOf('\u2a82'));
        NamedCharReferences.r("gesdotol", Character.valueOf('\u2a84'));
        NamedCharReferences.r("gesl", Character.valueOf('\u22db'));
        NamedCharReferences.r("gesles", Character.valueOf('\u2a94'));
        NamedCharReferences.r("Gg", Character.valueOf('\u22d9'));
        NamedCharReferences.r("gg", Character.valueOf('\u226b'));
        NamedCharReferences.r("ggg", Character.valueOf('\u22d9'));
        NamedCharReferences.r("gimel", Character.valueOf('\u2137'));
        NamedCharReferences.r("gjcy", Character.valueOf('\u0453'));
        NamedCharReferences.r("GJcy", Character.valueOf('\u0403'));
        NamedCharReferences.r("gl", Character.valueOf('\u2277'));
        NamedCharReferences.r("gla", Character.valueOf('\u2aa5'));
        NamedCharReferences.r("glE", Character.valueOf('\u2a92'));
        NamedCharReferences.r("glj", Character.valueOf('\u2aa4'));
        NamedCharReferences.r("gnap", Character.valueOf('\u2a8a'));
        NamedCharReferences.r("gnapprox", Character.valueOf('\u2a8a'));
        NamedCharReferences.r("gnE", Character.valueOf('\u2269'));
        NamedCharReferences.r("gne", Character.valueOf('\u2a88'));
        NamedCharReferences.r("gneq", Character.valueOf('\u2a88'));
        NamedCharReferences.r("gneqq", Character.valueOf('\u2269'));
        NamedCharReferences.r("gnsim", Character.valueOf('\u22e7'));
        NamedCharReferences.r("grave", Character.valueOf('`'));
        NamedCharReferences.r("GreaterEqual", Character.valueOf('\u2265'));
        NamedCharReferences.r("GreaterEqualLess", Character.valueOf('\u22db'));
        NamedCharReferences.r("GreaterFullEqual", Character.valueOf('\u2267'));
        NamedCharReferences.r("GreaterGreater", Character.valueOf('\u2aa2'));
        NamedCharReferences.r("GreaterLess", Character.valueOf('\u2277'));
        NamedCharReferences.r("GreaterSlantEqual", Character.valueOf('\u2a7e'));
        NamedCharReferences.r("GreaterTilde", Character.valueOf('\u2273'));
        NamedCharReferences.r("gscr", Character.valueOf('\u210a'));
        NamedCharReferences.r("gsim", Character.valueOf('\u2273'));
        NamedCharReferences.r("gsime", Character.valueOf('\u2a8e'));
        NamedCharReferences.r("gsiml", Character.valueOf('\u2a90'));
        NamedCharReferences.r("gtcc", Character.valueOf('\u2aa7'));
        NamedCharReferences.r("gtcir", Character.valueOf('\u2a7a'));
        NamedCharReferences.r("gtdot", Character.valueOf('\u22d7'));
        NamedCharReferences.r("gtlPar", Character.valueOf('\u2995'));
        NamedCharReferences.r("gtquest", Character.valueOf('\u2a7c'));
        NamedCharReferences.r("gtrapprox", Character.valueOf('\u2a86'));
        NamedCharReferences.r("gtrarr", Character.valueOf('\u2978'));
        NamedCharReferences.r("gtrdot", Character.valueOf('\u22d7'));
        NamedCharReferences.r("gtreqless", Character.valueOf('\u22db'));
        NamedCharReferences.r("gtreqqless", Character.valueOf('\u2a8c'));
        NamedCharReferences.r("gtrless", Character.valueOf('\u2277'));
        NamedCharReferences.r("gtrsim", Character.valueOf('\u2273'));
        NamedCharReferences.r("gvertneqq", Character.valueOf('\u2269'));
        NamedCharReferences.r("gvnE", Character.valueOf('\u2269'));
        NamedCharReferences.r("Hacek", Character.valueOf('\u02c7'));
        NamedCharReferences.r("hairsp", Character.valueOf('\u200a'));
        NamedCharReferences.r("half", Character.valueOf('\u00bd'));
        NamedCharReferences.r("hamilt", Character.valueOf('\u210b'));
        NamedCharReferences.r("HARDcy", Character.valueOf('\u042a'));
        NamedCharReferences.r("hardcy", Character.valueOf('\u044a'));
        NamedCharReferences.r("harr", Character.valueOf('\u2194'));
        NamedCharReferences.r("hArr", Character.valueOf('\u21d4'));
        NamedCharReferences.r("harrcir", Character.valueOf('\u2948'));
        NamedCharReferences.r("harrw", Character.valueOf('\u21ad'));
        NamedCharReferences.r("Hat", Character.valueOf('^'));
        NamedCharReferences.r("hbar", Character.valueOf('\u210f'));
        NamedCharReferences.r("Hcirc", Character.valueOf('\u0124'));
        NamedCharReferences.r("hcirc", Character.valueOf('\u0125'));
        NamedCharReferences.r("hearts", Character.valueOf('\u2665'));
        NamedCharReferences.r("heartsuit", Character.valueOf('\u2665'));
        NamedCharReferences.r("hellip", Character.valueOf('\u2026'));
        NamedCharReferences.r("hercon", Character.valueOf('\u22b9'));
        NamedCharReferences.r("Hfr", Character.valueOf('\u210c'));
        NamedCharReferences.r("HilbertSpace", Character.valueOf('\u210b'));
        NamedCharReferences.r("hksearow", Character.valueOf('\u2925'));
        NamedCharReferences.r("hkswarow", Character.valueOf('\u2926'));
        NamedCharReferences.r("hoarr", Character.valueOf('\u21ff'));
        NamedCharReferences.r("homtht", Character.valueOf('\u223b'));
        NamedCharReferences.r("hookleftarrow", Character.valueOf('\u21a9'));
        NamedCharReferences.r("hookrightarrow", Character.valueOf('\u21aa'));
        NamedCharReferences.r("Hopf", Character.valueOf('\u210d'));
        NamedCharReferences.r("horbar", Character.valueOf('\u2015'));
        NamedCharReferences.r("HorizontalLine", Character.valueOf('\u2500'));
        NamedCharReferences.r("Hscr", Character.valueOf('\u210b'));
        NamedCharReferences.r("hslash", Character.valueOf('\u210f'));
        NamedCharReferences.r("hstrok", Character.valueOf('\u0127'));
        NamedCharReferences.r("Hstrok", Character.valueOf('\u0126'));
        NamedCharReferences.r("HumpDownHump", Character.valueOf('\u224e'));
        NamedCharReferences.r("HumpEqual", Character.valueOf('\u224f'));
        NamedCharReferences.r("hybull", Character.valueOf('\u2043'));
        NamedCharReferences.r("hyphen", Character.valueOf('\u2010'));
        NamedCharReferences.r("Iacute", Character.valueOf('\u00cd'));
        NamedCharReferences.r("iacute", Character.valueOf('\u00ed'));
        NamedCharReferences.r("ic", Character.valueOf('\u2063'));
        NamedCharReferences.r("icirc", Character.valueOf('\u00ee'));
        NamedCharReferences.r("Icirc", Character.valueOf('\u00ce'));
        NamedCharReferences.r("icy", Character.valueOf('\u0438'));
        NamedCharReferences.r("Icy", Character.valueOf('\u0418'));
        NamedCharReferences.r("Idot", Character.valueOf('\u0130'));
        NamedCharReferences.r("iecy", Character.valueOf('\u0435'));
        NamedCharReferences.r("IEcy", Character.valueOf('\u0415'));
        NamedCharReferences.r("iexcl", Character.valueOf('\u00a1'));
        NamedCharReferences.r("iff", Character.valueOf('\u21d4'));
        NamedCharReferences.r("Ifr", Character.valueOf('\u2111'));
        NamedCharReferences.r("Igrave", Character.valueOf('\u00cc'));
        NamedCharReferences.r("igrave", Character.valueOf('\u00ec'));
        NamedCharReferences.r("ii", Character.valueOf('\u2148'));
        NamedCharReferences.r("iiiint", Character.valueOf('\u2a0c'));
        NamedCharReferences.r("iiint", Character.valueOf('\u222d'));
        NamedCharReferences.r("iinfin", Character.valueOf('\u29dc'));
        NamedCharReferences.r("iiota", Character.valueOf('\u2129'));
        NamedCharReferences.r("ijlig", Character.valueOf('\u0133'));
        NamedCharReferences.r("IJlig", Character.valueOf('\u0132'));
        NamedCharReferences.r("Im", Character.valueOf('\u2111'));
        NamedCharReferences.r("Imacr", Character.valueOf('\u012a'));
        NamedCharReferences.r("imacr", Character.valueOf('\u012b'));
        NamedCharReferences.r("image", Character.valueOf('\u2111'));
        NamedCharReferences.r("ImaginaryI", Character.valueOf('\u2148'));
        NamedCharReferences.r("imagline", Character.valueOf('\u2110'));
        NamedCharReferences.r("imagpart", Character.valueOf('\u2111'));
        NamedCharReferences.r("imath", Character.valueOf('\u0131'));
        NamedCharReferences.r("imof", Character.valueOf('\u22b7'));
        NamedCharReferences.r("imped", Character.valueOf('\u01b5'));
        NamedCharReferences.r("Implies", Character.valueOf('\u21d2'));
        NamedCharReferences.r("in", Character.valueOf('\u2208'));
        NamedCharReferences.r("incare", Character.valueOf('\u2105'));
        NamedCharReferences.r("infin", Character.valueOf('\u221e'));
        NamedCharReferences.r("infintie", Character.valueOf('\u29dd'));
        NamedCharReferences.r("inodot", Character.valueOf('\u0131'));
        NamedCharReferences.r("Int", Character.valueOf('\u222c'));
        NamedCharReferences.r("int", Character.valueOf('\u222b'));
        NamedCharReferences.r("intcal", Character.valueOf('\u22ba'));
        NamedCharReferences.r("integers", Character.valueOf('\u2124'));
        NamedCharReferences.r("Integral", Character.valueOf('\u222b'));
        NamedCharReferences.r("intercal", Character.valueOf('\u22ba'));
        NamedCharReferences.r("Intersection", Character.valueOf('\u22c2'));
        NamedCharReferences.r("intlarhk", Character.valueOf('\u2a17'));
        NamedCharReferences.r("intprod", Character.valueOf('\u2a3c'));
        NamedCharReferences.r("InvisibleComma", Character.valueOf('\u2063'));
        NamedCharReferences.r("InvisibleTimes", Character.valueOf('\u2062'));
        NamedCharReferences.r("IOcy", Character.valueOf('\u0401'));
        NamedCharReferences.r("iocy", Character.valueOf('\u0451'));
        NamedCharReferences.r("Iogon", Character.valueOf('\u012e'));
        NamedCharReferences.r("iogon", Character.valueOf('\u012f'));
        NamedCharReferences.r("Iota", Character.valueOf('\u0399'));
        NamedCharReferences.r("iota", Character.valueOf('\u03b9'));
        NamedCharReferences.r("iprod", Character.valueOf('\u2a3c'));
        NamedCharReferences.r("iquest", Character.valueOf('\u00bf'));
        NamedCharReferences.r("Iscr", Character.valueOf('\u2110'));
        NamedCharReferences.r("isin", Character.valueOf('\u2208'));
        NamedCharReferences.r("isindot", Character.valueOf('\u22f5'));
        NamedCharReferences.r("isinE", Character.valueOf('\u22f9'));
        NamedCharReferences.r("isins", Character.valueOf('\u22f4'));
        NamedCharReferences.r("isinsv", Character.valueOf('\u22f3'));
        NamedCharReferences.r("isinv", Character.valueOf('\u2208'));
        NamedCharReferences.r("it", Character.valueOf('\u2062'));
        NamedCharReferences.r("Itilde", Character.valueOf('\u0128'));
        NamedCharReferences.r("itilde", Character.valueOf('\u0129'));
        NamedCharReferences.r("iukcy", Character.valueOf('\u0456'));
        NamedCharReferences.r("Iukcy", Character.valueOf('\u0406'));
        NamedCharReferences.r("iuml", Character.valueOf('\u00ef'));
        NamedCharReferences.r("Iuml", Character.valueOf('\u00cf'));
        NamedCharReferences.r("Jcirc", Character.valueOf('\u0134'));
        NamedCharReferences.r("jcirc", Character.valueOf('\u0135'));
        NamedCharReferences.r("jcy", Character.valueOf('\u0439'));
        NamedCharReferences.r("Jcy", Character.valueOf('\u0419'));
        NamedCharReferences.r("jmath", Character.valueOf('\u0237'));
        NamedCharReferences.r("jsercy", Character.valueOf('\u0458'));
        NamedCharReferences.r("Jsercy", Character.valueOf('\u0408'));
        NamedCharReferences.r("Jukcy", Character.valueOf('\u0404'));
        NamedCharReferences.r("jukcy", Character.valueOf('\u0454'));
        NamedCharReferences.r("kappa", Character.valueOf('\u03ba'));
        NamedCharReferences.r("Kappa", Character.valueOf('\u039a'));
        NamedCharReferences.r("kappav", Character.valueOf('\u03f0'));
        NamedCharReferences.r("Kcedil", Character.valueOf('\u0136'));
        NamedCharReferences.r("kcedil", Character.valueOf('\u0137'));
        NamedCharReferences.r("kcy", Character.valueOf('\u043a'));
        NamedCharReferences.r("Kcy", Character.valueOf('\u041a'));
        NamedCharReferences.r("kgreen", Character.valueOf('\u0138'));
        NamedCharReferences.r("khcy", Character.valueOf('\u0445'));
        NamedCharReferences.r("KHcy", Character.valueOf('\u0425'));
        NamedCharReferences.r("kjcy", Character.valueOf('\u045c'));
        NamedCharReferences.r("KJcy", Character.valueOf('\u040c'));
        NamedCharReferences.r("lAarr", Character.valueOf('\u21da'));
        NamedCharReferences.r("Lacute", Character.valueOf('\u0139'));
        NamedCharReferences.r("lacute", Character.valueOf('\u013a'));
        NamedCharReferences.r("laemptyv", Character.valueOf('\u29b4'));
        NamedCharReferences.r("lagran", Character.valueOf('\u2112'));
        NamedCharReferences.r("lambda", Character.valueOf('\u03bb'));
        NamedCharReferences.r("Lambda", Character.valueOf('\u039b'));
        NamedCharReferences.r("Lang", Character.valueOf('\u27ea'));
        NamedCharReferences.r("lang", Character.valueOf('\u27e8'));
        NamedCharReferences.r("langd", Character.valueOf('\u2991'));
        NamedCharReferences.r("langle", Character.valueOf('\u27e8'));
        NamedCharReferences.r("lap", Character.valueOf('\u2a85'));
        NamedCharReferences.r("Laplacetrf", Character.valueOf('\u2112'));
        NamedCharReferences.r("laquo", Character.valueOf('\u00ab'));
        NamedCharReferences.r("Larr", Character.valueOf('\u219e'));
        NamedCharReferences.r("lArr", Character.valueOf('\u21d0'));
        NamedCharReferences.r("larr", Character.valueOf('\u2190'));
        NamedCharReferences.r("larrb", Character.valueOf('\u21e4'));
        NamedCharReferences.r("larrbfs", Character.valueOf('\u291f'));
        NamedCharReferences.r("larrfs", Character.valueOf('\u291d'));
        NamedCharReferences.r("larrhk", Character.valueOf('\u21a9'));
        NamedCharReferences.r("larrlp", Character.valueOf('\u21ab'));
        NamedCharReferences.r("larrpl", Character.valueOf('\u2939'));
        NamedCharReferences.r("larrsim", Character.valueOf('\u2973'));
        NamedCharReferences.r("larrtl", Character.valueOf('\u21a2'));
        NamedCharReferences.r("lat", Character.valueOf('\u2aab'));
        NamedCharReferences.r("latail", Character.valueOf('\u2919'));
        NamedCharReferences.r("lAtail", Character.valueOf('\u291b'));
        NamedCharReferences.r("late", Character.valueOf('\u2aad'));
        NamedCharReferences.r("lates", Character.valueOf('\u2aad'));
        NamedCharReferences.r("lBarr", Character.valueOf('\u290e'));
        NamedCharReferences.r("lbarr", Character.valueOf('\u290c'));
        NamedCharReferences.r("lbbrk", Character.valueOf('\u2772'));
        NamedCharReferences.r("lbrace", Character.valueOf('{'));
        NamedCharReferences.r("lbrack", Character.valueOf('['));
        NamedCharReferences.r("lbrke", Character.valueOf('\u298b'));
        NamedCharReferences.r("lbrksld", Character.valueOf('\u298f'));
        NamedCharReferences.r("lbrkslu", Character.valueOf('\u298d'));
        NamedCharReferences.r("lcaron", Character.valueOf('\u013e'));
        NamedCharReferences.r("Lcaron", Character.valueOf('\u013d'));
        NamedCharReferences.r("Lcedil", Character.valueOf('\u013b'));
        NamedCharReferences.r("lcedil", Character.valueOf('\u013c'));
        NamedCharReferences.r("lceil", Character.valueOf('\u2308'));
        NamedCharReferences.r("lcub", Character.valueOf('{'));
        NamedCharReferences.r("lcy", Character.valueOf('\u043b'));
        NamedCharReferences.r("Lcy", Character.valueOf('\u041b'));
        NamedCharReferences.r("ldca", Character.valueOf('\u2936'));
        NamedCharReferences.r("ldquo", Character.valueOf('\u201c'));
        NamedCharReferences.r("ldquor", Character.valueOf('\u201e'));
        NamedCharReferences.r("ldrdhar", Character.valueOf('\u2967'));
        NamedCharReferences.r("ldrushar", Character.valueOf('\u294b'));
        NamedCharReferences.r("ldsh", Character.valueOf('\u21b2'));
        NamedCharReferences.r("lE", Character.valueOf('\u2266'));
        NamedCharReferences.r("le", Character.valueOf('\u2264'));
        NamedCharReferences.r("LeftAngleBracket", Character.valueOf('\u27e8'));
        NamedCharReferences.r("LeftArrow", Character.valueOf('\u2190'));
        NamedCharReferences.r("leftarrow", Character.valueOf('\u2190'));
        NamedCharReferences.r("Leftarrow", Character.valueOf('\u21d0'));
        NamedCharReferences.r("LeftArrowBar", Character.valueOf('\u21e4'));
        NamedCharReferences.r("LeftArrowRightArrow", Character.valueOf('\u21c6'));
        NamedCharReferences.r("leftarrowtail", Character.valueOf('\u21a2'));
        NamedCharReferences.r("LeftCeiling", Character.valueOf('\u2308'));
        NamedCharReferences.r("LeftDoubleBracket", Character.valueOf('\u27e6'));
        NamedCharReferences.r("LeftDownTeeVector", Character.valueOf('\u2961'));
        NamedCharReferences.r("LeftDownVector", Character.valueOf('\u21c3'));
        NamedCharReferences.r("LeftDownVectorBar", Character.valueOf('\u2959'));
        NamedCharReferences.r("LeftFloor", Character.valueOf('\u230a'));
        NamedCharReferences.r("leftharpoondown", Character.valueOf('\u21bd'));
        NamedCharReferences.r("leftharpoonup", Character.valueOf('\u21bc'));
        NamedCharReferences.r("leftleftarrows", Character.valueOf('\u21c7'));
        NamedCharReferences.r("Leftrightarrow", Character.valueOf('\u21d4'));
        NamedCharReferences.r("leftrightarrow", Character.valueOf('\u2194'));
        NamedCharReferences.r("LeftRightArrow", Character.valueOf('\u2194'));
        NamedCharReferences.r("leftrightarrows", Character.valueOf('\u21c6'));
        NamedCharReferences.r("leftrightharpoons", Character.valueOf('\u21cb'));
        NamedCharReferences.r("leftrightsquigarrow", Character.valueOf('\u21ad'));
        NamedCharReferences.r("LeftRightVector", Character.valueOf('\u294e'));
        NamedCharReferences.r("LeftTee", Character.valueOf('\u22a3'));
        NamedCharReferences.r("LeftTeeArrow", Character.valueOf('\u21a4'));
        NamedCharReferences.r("LeftTeeVector", Character.valueOf('\u295a'));
        NamedCharReferences.r("leftthreetimes", Character.valueOf('\u22cb'));
        NamedCharReferences.r("LeftTriangle", Character.valueOf('\u22b2'));
        NamedCharReferences.r("LeftTriangleBar", Character.valueOf('\u29cf'));
        NamedCharReferences.r("LeftTriangleEqual", Character.valueOf('\u22b4'));
        NamedCharReferences.r("LeftUpDownVector", Character.valueOf('\u2951'));
        NamedCharReferences.r("LeftUpTeeVector", Character.valueOf('\u2960'));
        NamedCharReferences.r("LeftUpVector", Character.valueOf('\u21bf'));
        NamedCharReferences.r("LeftUpVectorBar", Character.valueOf('\u2958'));
        NamedCharReferences.r("LeftVector", Character.valueOf('\u21bc'));
        NamedCharReferences.r("LeftVectorBar", Character.valueOf('\u2952'));
        NamedCharReferences.r("lEg", Character.valueOf('\u2a8b'));
        NamedCharReferences.r("leg", Character.valueOf('\u22da'));
        NamedCharReferences.r("leq", Character.valueOf('\u2264'));
        NamedCharReferences.r("leqq", Character.valueOf('\u2266'));
        NamedCharReferences.r("leqslant", Character.valueOf('\u2a7d'));
        NamedCharReferences.r("les", Character.valueOf('\u2a7d'));
        NamedCharReferences.r("lescc", Character.valueOf('\u2aa8'));
        NamedCharReferences.r("lesdot", Character.valueOf('\u2a7f'));
        NamedCharReferences.r("lesdoto", Character.valueOf('\u2a81'));
        NamedCharReferences.r("lesdotor", Character.valueOf('\u2a83'));
        NamedCharReferences.r("lesg", Character.valueOf('\u22da'));
        NamedCharReferences.r("lesges", Character.valueOf('\u2a93'));
        NamedCharReferences.r("lessapprox", Character.valueOf('\u2a85'));
        NamedCharReferences.r("lessdot", Character.valueOf('\u22d6'));
        NamedCharReferences.r("lesseqgtr", Character.valueOf('\u22da'));
        NamedCharReferences.r("lesseqqgtr", Character.valueOf('\u2a8b'));
        NamedCharReferences.r("LessEqualGreater", Character.valueOf('\u22da'));
        NamedCharReferences.r("LessFullEqual", Character.valueOf('\u2266'));
        NamedCharReferences.r("LessGreater", Character.valueOf('\u2276'));
        NamedCharReferences.r("lessgtr", Character.valueOf('\u2276'));
        NamedCharReferences.r("LessLess", Character.valueOf('\u2aa1'));
        NamedCharReferences.r("lesssim", Character.valueOf('\u2272'));
        NamedCharReferences.r("LessSlantEqual", Character.valueOf('\u2a7d'));
        NamedCharReferences.r("LessTilde", Character.valueOf('\u2272'));
        NamedCharReferences.r("lfisht", Character.valueOf('\u297c'));
        NamedCharReferences.r("lfloor", Character.valueOf('\u230a'));
        NamedCharReferences.r("lg", Character.valueOf('\u2276'));
        NamedCharReferences.r("lgE", Character.valueOf('\u2a91'));
        NamedCharReferences.r("lHar", Character.valueOf('\u2962'));
        NamedCharReferences.r("lhard", Character.valueOf('\u21bd'));
        NamedCharReferences.r("lharu", Character.valueOf('\u21bc'));
        NamedCharReferences.r("lharul", Character.valueOf('\u296a'));
        NamedCharReferences.r("lhblk", Character.valueOf('\u2584'));
        NamedCharReferences.r("LJcy", Character.valueOf('\u0409'));
        NamedCharReferences.r("ljcy", Character.valueOf('\u0459'));
        NamedCharReferences.r("Ll", Character.valueOf('\u22d8'));
        NamedCharReferences.r("ll", Character.valueOf('\u226a'));
        NamedCharReferences.r("llarr", Character.valueOf('\u21c7'));
        NamedCharReferences.r("llcorner", Character.valueOf('\u231e'));
        NamedCharReferences.r("Lleftarrow", Character.valueOf('\u21da'));
        NamedCharReferences.r("llhard", Character.valueOf('\u296b'));
        NamedCharReferences.r("lltri", Character.valueOf('\u25fa'));
        NamedCharReferences.r("lmidot", Character.valueOf('\u0140'));
        NamedCharReferences.r("Lmidot", Character.valueOf('\u013f'));
        NamedCharReferences.r("lmoust", Character.valueOf('\u23b0'));
        NamedCharReferences.r("lmoustache", Character.valueOf('\u23b0'));
        NamedCharReferences.r("lnap", Character.valueOf('\u2a89'));
        NamedCharReferences.r("lnapprox", Character.valueOf('\u2a89'));
        NamedCharReferences.r("lne", Character.valueOf('\u2a87'));
        NamedCharReferences.r("lnE", Character.valueOf('\u2268'));
        NamedCharReferences.r("lneq", Character.valueOf('\u2a87'));
        NamedCharReferences.r("lneqq", Character.valueOf('\u2268'));
        NamedCharReferences.r("lnsim", Character.valueOf('\u22e6'));
        NamedCharReferences.r("loang", Character.valueOf('\u27ec'));
        NamedCharReferences.r("loarr", Character.valueOf('\u21fd'));
        NamedCharReferences.r("lobrk", Character.valueOf('\u27e6'));
        NamedCharReferences.r("Longleftarrow", Character.valueOf('\u27f8'));
        NamedCharReferences.r("LongLeftArrow", Character.valueOf('\u27f5'));
        NamedCharReferences.r("longleftarrow", Character.valueOf('\u27f5'));
        NamedCharReferences.r("LongLeftRightArrow", Character.valueOf('\u27f7'));
        NamedCharReferences.r("longleftrightarrow", Character.valueOf('\u27f7'));
        NamedCharReferences.r("Longleftrightarrow", Character.valueOf('\u27fa'));
        NamedCharReferences.r("longmapsto", Character.valueOf('\u27fc'));
        NamedCharReferences.r("longrightarrow", Character.valueOf('\u27f6'));
        NamedCharReferences.r("Longrightarrow", Character.valueOf('\u27f9'));
        NamedCharReferences.r("LongRightArrow", Character.valueOf('\u27f6'));
        NamedCharReferences.r("looparrowleft", Character.valueOf('\u21ab'));
        NamedCharReferences.r("looparrowright", Character.valueOf('\u21ac'));
        NamedCharReferences.r("lopar", Character.valueOf('\u2985'));
        NamedCharReferences.r("loplus", Character.valueOf('\u2a2d'));
        NamedCharReferences.r("lotimes", Character.valueOf('\u2a34'));
        NamedCharReferences.r("lowast", Character.valueOf('\u2217'));
        NamedCharReferences.r("lowbar", Character.valueOf('_'));
        NamedCharReferences.r("LowerLeftArrow", Character.valueOf('\u2199'));
        NamedCharReferences.r("LowerRightArrow", Character.valueOf('\u2198'));
        NamedCharReferences.r("loz", Character.valueOf('\u25ca'));
        NamedCharReferences.r("lozenge", Character.valueOf('\u25ca'));
        NamedCharReferences.r("lozf", Character.valueOf('\u29eb'));
        NamedCharReferences.r("lpar", Character.valueOf('('));
        NamedCharReferences.r("lparlt", Character.valueOf('\u2993'));
        NamedCharReferences.r("lrarr", Character.valueOf('\u21c6'));
        NamedCharReferences.r("lrcorner", Character.valueOf('\u231f'));
        NamedCharReferences.r("lrhar", Character.valueOf('\u21cb'));
        NamedCharReferences.r("lrhard", Character.valueOf('\u296d'));
        NamedCharReferences.r("lrm", Character.valueOf('\u200e'));
        NamedCharReferences.r("lrtri", Character.valueOf('\u22bf'));
        NamedCharReferences.r("lsaquo", Character.valueOf('\u2039'));
        NamedCharReferences.r("Lscr", Character.valueOf('\u2112'));
        NamedCharReferences.r("lsh", Character.valueOf('\u21b0'));
        NamedCharReferences.r("Lsh", Character.valueOf('\u21b0'));
        NamedCharReferences.r("lsim", Character.valueOf('\u2272'));
        NamedCharReferences.r("lsime", Character.valueOf('\u2a8d'));
        NamedCharReferences.r("lsimg", Character.valueOf('\u2a8f'));
        NamedCharReferences.r("lsqb", Character.valueOf('['));
        NamedCharReferences.r("lsquo", Character.valueOf('\u2018'));
        NamedCharReferences.r("lsquor", Character.valueOf('\u201a'));
        NamedCharReferences.r("Lstrok", Character.valueOf('\u0141'));
        NamedCharReferences.r("lstrok", Character.valueOf('\u0142'));
        NamedCharReferences.r("ltcc", Character.valueOf('\u2aa6'));
        NamedCharReferences.r("ltcir", Character.valueOf('\u2a79'));
        NamedCharReferences.r("ltdot", Character.valueOf('\u22d6'));
        NamedCharReferences.r("lthree", Character.valueOf('\u22cb'));
        NamedCharReferences.r("ltimes", Character.valueOf('\u22c9'));
        NamedCharReferences.r("ltlarr", Character.valueOf('\u2976'));
        NamedCharReferences.r("ltquest", Character.valueOf('\u2a7b'));
        NamedCharReferences.r("ltri", Character.valueOf('\u25c3'));
        NamedCharReferences.r("ltrie", Character.valueOf('\u22b4'));
        NamedCharReferences.r("ltrif", Character.valueOf('\u25c2'));
        NamedCharReferences.r("ltrPar", Character.valueOf('\u2996'));
        NamedCharReferences.r("lurdshar", Character.valueOf('\u294a'));
        NamedCharReferences.r("luruhar", Character.valueOf('\u2966'));
        NamedCharReferences.r("lvertneqq", Character.valueOf('\u2268'));
        NamedCharReferences.r("lvnE", Character.valueOf('\u2268'));
        NamedCharReferences.r("macr", Character.valueOf('\u00af'));
        NamedCharReferences.r("male", Character.valueOf('\u2642'));
        NamedCharReferences.r("malt", Character.valueOf('\u2720'));
        NamedCharReferences.r("maltese", Character.valueOf('\u2720'));
        NamedCharReferences.r("map", Character.valueOf('\u21a6'));
        NamedCharReferences.r("Map", Character.valueOf('\u2905'));
        NamedCharReferences.r("mapsto", Character.valueOf('\u21a6'));
        NamedCharReferences.r("mapstodown", Character.valueOf('\u21a7'));
        NamedCharReferences.r("mapstoleft", Character.valueOf('\u21a4'));
        NamedCharReferences.r("mapstoup", Character.valueOf('\u21a5'));
        NamedCharReferences.r("marker", Character.valueOf('\u25ae'));
        NamedCharReferences.r("mcomma", Character.valueOf('\u2a29'));
        NamedCharReferences.r("mcy", Character.valueOf('\u043c'));
        NamedCharReferences.r("Mcy", Character.valueOf('\u041c'));
        NamedCharReferences.r("mdash", Character.valueOf('\u2014'));
        NamedCharReferences.r("mDDot", Character.valueOf('\u223a'));
        NamedCharReferences.r("measuredangle", Character.valueOf('\u2221'));
        NamedCharReferences.r("MediumSpace", Character.valueOf('\u205f'));
        NamedCharReferences.r("Mellintrf", Character.valueOf('\u2133'));
        NamedCharReferences.r("mho", Character.valueOf('\u2127'));
        NamedCharReferences.r("micro", Character.valueOf('\u00b5'));
        NamedCharReferences.r("mid", Character.valueOf('\u2223'));
        NamedCharReferences.r("midast", Character.valueOf('*'));
        NamedCharReferences.r("midcir", Character.valueOf('\u2af0'));
        NamedCharReferences.r("middot", Character.valueOf('\u00b7'));
        NamedCharReferences.r("minus", Character.valueOf('\u2212'));
        NamedCharReferences.r("minusb", Character.valueOf('\u229f'));
        NamedCharReferences.r("minusd", Character.valueOf('\u2238'));
        NamedCharReferences.r("minusdu", Character.valueOf('\u2a2a'));
        NamedCharReferences.r("MinusPlus", Character.valueOf('\u2213'));
        NamedCharReferences.r("mlcp", Character.valueOf('\u2adb'));
        NamedCharReferences.r("mldr", Character.valueOf('\u2026'));
        NamedCharReferences.r("mnplus", Character.valueOf('\u2213'));
        NamedCharReferences.r("models", Character.valueOf('\u22a7'));
        NamedCharReferences.r("mp", Character.valueOf('\u2213'));
        NamedCharReferences.r("Mscr", Character.valueOf('\u2133'));
        NamedCharReferences.r("mstpos", Character.valueOf('\u223e'));
        NamedCharReferences.r("Mu", Character.valueOf('\u039c'));
        NamedCharReferences.r("mu", Character.valueOf('\u03bc'));
        NamedCharReferences.r("multimap", Character.valueOf('\u22b8'));
        NamedCharReferences.r("mumap", Character.valueOf('\u22b8'));
        NamedCharReferences.r("nabla", Character.valueOf('\u2207'));
        NamedCharReferences.r("Nacute", Character.valueOf('\u0143'));
        NamedCharReferences.r("nacute", Character.valueOf('\u0144'));
        NamedCharReferences.r("nang", Character.valueOf('\u2220'));
        NamedCharReferences.r("nap", Character.valueOf('\u2249'));
        NamedCharReferences.r("napE", Character.valueOf('\u2a70'));
        NamedCharReferences.r("napid", Character.valueOf('\u224b'));
        NamedCharReferences.r("napos", Character.valueOf('\u0149'));
        NamedCharReferences.r("napprox", Character.valueOf('\u2249'));
        NamedCharReferences.r("natur", Character.valueOf('\u266e'));
        NamedCharReferences.r("natural", Character.valueOf('\u266e'));
        NamedCharReferences.r("naturals", Character.valueOf('\u2115'));
        NamedCharReferences.r("nbsp", Character.valueOf('\u00a0'));
        NamedCharReferences.r("nbump", Character.valueOf('\u224e'));
        NamedCharReferences.r("nbumpe", Character.valueOf('\u224f'));
        NamedCharReferences.r("ncap", Character.valueOf('\u2a43'));
        NamedCharReferences.r("ncaron", Character.valueOf('\u0148'));
        NamedCharReferences.r("Ncaron", Character.valueOf('\u0147'));
        NamedCharReferences.r("Ncedil", Character.valueOf('\u0145'));
        NamedCharReferences.r("ncedil", Character.valueOf('\u0146'));
        NamedCharReferences.r("ncong", Character.valueOf('\u2247'));
        NamedCharReferences.r("ncongdot", Character.valueOf('\u2a6d'));
        NamedCharReferences.r("ncup", Character.valueOf('\u2a42'));
        NamedCharReferences.r("Ncy", Character.valueOf('\u041d'));
        NamedCharReferences.r("ncy", Character.valueOf('\u043d'));
        NamedCharReferences.r("ndash", Character.valueOf('\u2013'));
        NamedCharReferences.r("ne", Character.valueOf('\u2260'));
        NamedCharReferences.r("nearhk", Character.valueOf('\u2924'));
        NamedCharReferences.r("nearr", Character.valueOf('\u2197'));
        NamedCharReferences.r("neArr", Character.valueOf('\u21d7'));
        NamedCharReferences.r("nearrow", Character.valueOf('\u2197'));
        NamedCharReferences.r("nedot", Character.valueOf('\u2250'));
        NamedCharReferences.r("NegativeMediumSpace", Character.valueOf('\u200b'));
        NamedCharReferences.r("NegativeThickSpace", Character.valueOf('\u200b'));
        NamedCharReferences.r("NegativeThinSpace", Character.valueOf('\u200b'));
        NamedCharReferences.r("NegativeVeryThinSpace", Character.valueOf('\u200b'));
        NamedCharReferences.r("nequiv", Character.valueOf('\u2262'));
        NamedCharReferences.r("nesear", Character.valueOf('\u2928'));
        NamedCharReferences.r("nesim", Character.valueOf('\u2242'));
        NamedCharReferences.r("NestedGreaterGreater", Character.valueOf('\u226b'));
        NamedCharReferences.r("NestedLessLess", Character.valueOf('\u226a'));
        NamedCharReferences.r("NewLine", Character.valueOf('\n'));
        NamedCharReferences.r("nexist", Character.valueOf('\u2204'));
        NamedCharReferences.r("nexists", Character.valueOf('\u2204'));
        NamedCharReferences.r("nge", Character.valueOf('\u2271'));
        NamedCharReferences.r("ngE", Character.valueOf('\u2267'));
        NamedCharReferences.r("ngeq", Character.valueOf('\u2271'));
        NamedCharReferences.r("ngeqq", Character.valueOf('\u2267'));
        NamedCharReferences.r("ngeqslant", Character.valueOf('\u2a7e'));
        NamedCharReferences.r("nges", Character.valueOf('\u2a7e'));
        NamedCharReferences.r("nGg", Character.valueOf('\u22d9'));
        NamedCharReferences.r("ngsim", Character.valueOf('\u2275'));
        NamedCharReferences.r("ngt", Character.valueOf('\u226f'));
        NamedCharReferences.r("nGt", Character.valueOf('\u226b'));
        NamedCharReferences.r("ngtr", Character.valueOf('\u226f'));
        NamedCharReferences.r("nGtv", Character.valueOf('\u226b'));
        NamedCharReferences.r("nhArr", Character.valueOf('\u21ce'));
        NamedCharReferences.r("nharr", Character.valueOf('\u21ae'));
        NamedCharReferences.r("nhpar", Character.valueOf('\u2af2'));
        NamedCharReferences.r("ni", Character.valueOf('\u220b'));
        NamedCharReferences.r("nis", Character.valueOf('\u22fc'));
        NamedCharReferences.r("nisd", Character.valueOf('\u22fa'));
        NamedCharReferences.r("niv", Character.valueOf('\u220b'));
        NamedCharReferences.r("NJcy", Character.valueOf('\u040a'));
        NamedCharReferences.r("njcy", Character.valueOf('\u045a'));
        NamedCharReferences.r("nlArr", Character.valueOf('\u21cd'));
        NamedCharReferences.r("nlarr", Character.valueOf('\u219a'));
        NamedCharReferences.r("nldr", Character.valueOf('\u2025'));
        NamedCharReferences.r("nle", Character.valueOf('\u2270'));
        NamedCharReferences.r("nlE", Character.valueOf('\u2266'));
        NamedCharReferences.r("nLeftarrow", Character.valueOf('\u21cd'));
        NamedCharReferences.r("nleftarrow", Character.valueOf('\u219a'));
        NamedCharReferences.r("nleftrightarrow", Character.valueOf('\u21ae'));
        NamedCharReferences.r("nLeftrightarrow", Character.valueOf('\u21ce'));
        NamedCharReferences.r("nleq", Character.valueOf('\u2270'));
        NamedCharReferences.r("nleqq", Character.valueOf('\u2266'));
        NamedCharReferences.r("nleqslant", Character.valueOf('\u2a7d'));
        NamedCharReferences.r("nles", Character.valueOf('\u2a7d'));
        NamedCharReferences.r("nless", Character.valueOf('\u226e'));
        NamedCharReferences.r("nLl", Character.valueOf('\u22d8'));
        NamedCharReferences.r("nlsim", Character.valueOf('\u2274'));
        NamedCharReferences.r("nlt", Character.valueOf('\u226e'));
        NamedCharReferences.r("nLt", Character.valueOf('\u226a'));
        NamedCharReferences.r("nltri", Character.valueOf('\u22ea'));
        NamedCharReferences.r("nltrie", Character.valueOf('\u22ec'));
        NamedCharReferences.r("nLtv", Character.valueOf('\u226a'));
        NamedCharReferences.r("nmid", Character.valueOf('\u2224'));
        NamedCharReferences.r("NoBreak", Character.valueOf('\u2060'));
        NamedCharReferences.r("NonBreakingSpace", Character.valueOf('\u00a0'));
        NamedCharReferences.r("Nopf", Character.valueOf('\u2115'));
        NamedCharReferences.r("not", Character.valueOf('\u00ac'));
        NamedCharReferences.r("Not", Character.valueOf('\u2aec'));
        NamedCharReferences.r("NotCongruent", Character.valueOf('\u2262'));
        NamedCharReferences.r("NotCupCap", Character.valueOf('\u226d'));
        NamedCharReferences.r("NotDoubleVerticalBar", Character.valueOf('\u2226'));
        NamedCharReferences.r("NotElement", Character.valueOf('\u2209'));
        NamedCharReferences.r("NotEqual", Character.valueOf('\u2260'));
        NamedCharReferences.r("NotEqualTilde", Character.valueOf('\u2242'));
        NamedCharReferences.r("NotExists", Character.valueOf('\u2204'));
        NamedCharReferences.r("NotGreater", Character.valueOf('\u226f'));
        NamedCharReferences.r("NotGreaterEqual", Character.valueOf('\u2271'));
        NamedCharReferences.r("NotGreaterFullEqual", Character.valueOf('\u2267'));
        NamedCharReferences.r("NotGreaterGreater", Character.valueOf('\u226b'));
        NamedCharReferences.r("NotGreaterLess", Character.valueOf('\u2279'));
        NamedCharReferences.r("NotGreaterSlantEqual", Character.valueOf('\u2a7e'));
        NamedCharReferences.r("NotGreaterTilde", Character.valueOf('\u2275'));
        NamedCharReferences.r("NotHumpDownHump", Character.valueOf('\u224e'));
        NamedCharReferences.r("NotHumpEqual", Character.valueOf('\u224f'));
        NamedCharReferences.r("notin", Character.valueOf('\u2209'));
        NamedCharReferences.r("notindot", Character.valueOf('\u22f5'));
        NamedCharReferences.r("notinE", Character.valueOf('\u22f9'));
        NamedCharReferences.r("notinva", Character.valueOf('\u2209'));
        NamedCharReferences.r("notinvb", Character.valueOf('\u22f7'));
        NamedCharReferences.r("notinvc", Character.valueOf('\u22f6'));
        NamedCharReferences.r("NotLeftTriangle", Character.valueOf('\u22ea'));
        NamedCharReferences.r("NotLeftTriangleBar", Character.valueOf('\u29cf'));
        NamedCharReferences.r("NotLeftTriangleEqual", Character.valueOf('\u22ec'));
        NamedCharReferences.r("NotLess", Character.valueOf('\u226e'));
        NamedCharReferences.r("NotLessEqual", Character.valueOf('\u2270'));
        NamedCharReferences.r("NotLessGreater", Character.valueOf('\u2278'));
        NamedCharReferences.r("NotLessLess", Character.valueOf('\u226a'));
        NamedCharReferences.r("NotLessSlantEqual", Character.valueOf('\u2a7d'));
        NamedCharReferences.r("NotLessTilde", Character.valueOf('\u2274'));
        NamedCharReferences.r("NotNestedGreaterGreater", Character.valueOf('\u2aa2'));
        NamedCharReferences.r("NotNestedLessLess", Character.valueOf('\u2aa1'));
        NamedCharReferences.r("notni", Character.valueOf('\u220c'));
        NamedCharReferences.r("notniva", Character.valueOf('\u220c'));
        NamedCharReferences.r("notnivb", Character.valueOf('\u22fe'));
        NamedCharReferences.r("notnivc", Character.valueOf('\u22fd'));
        NamedCharReferences.r("NotPrecedes", Character.valueOf('\u2280'));
        NamedCharReferences.r("NotPrecedesEqual", Character.valueOf('\u2aaf'));
        NamedCharReferences.r("NotPrecedesSlantEqual", Character.valueOf('\u22e0'));
        NamedCharReferences.r("NotReverseElement", Character.valueOf('\u220c'));
        NamedCharReferences.r("NotRightTriangle", Character.valueOf('\u22eb'));
        NamedCharReferences.r("NotRightTriangleBar", Character.valueOf('\u29d0'));
        NamedCharReferences.r("NotRightTriangleEqual", Character.valueOf('\u22ed'));
        NamedCharReferences.r("NotSquareSubset", Character.valueOf('\u228f'));
        NamedCharReferences.r("NotSquareSubsetEqual", Character.valueOf('\u22e2'));
        NamedCharReferences.r("NotSquareSuperset", Character.valueOf('\u2290'));
        NamedCharReferences.r("NotSquareSupersetEqual", Character.valueOf('\u22e3'));
        NamedCharReferences.r("NotSubset", Character.valueOf('\u2282'));
        NamedCharReferences.r("NotSubsetEqual", Character.valueOf('\u2288'));
        NamedCharReferences.r("NotSucceeds", Character.valueOf('\u2281'));
        NamedCharReferences.r("NotSucceedsEqual", Character.valueOf('\u2ab0'));
        NamedCharReferences.r("NotSucceedsSlantEqual", Character.valueOf('\u22e1'));
        NamedCharReferences.r("NotSucceedsTilde", Character.valueOf('\u227f'));
        NamedCharReferences.r("NotSuperset", Character.valueOf('\u2283'));
        NamedCharReferences.r("NotSupersetEqual", Character.valueOf('\u2289'));
        NamedCharReferences.r("NotTilde", Character.valueOf('\u2241'));
        NamedCharReferences.r("NotTildeEqual", Character.valueOf('\u2244'));
        NamedCharReferences.r("NotTildeFullEqual", Character.valueOf('\u2247'));
        NamedCharReferences.r("NotTildeTilde", Character.valueOf('\u2249'));
        NamedCharReferences.r("NotVerticalBar", Character.valueOf('\u2224'));
        NamedCharReferences.r("npar", Character.valueOf('\u2226'));
        NamedCharReferences.r("nparallel", Character.valueOf('\u2226'));
        NamedCharReferences.r("nparsl", Character.valueOf('\u2afd'));
        NamedCharReferences.r("npart", Character.valueOf('\u2202'));
        NamedCharReferences.r("npolint", Character.valueOf('\u2a14'));
        NamedCharReferences.r("npr", Character.valueOf('\u2280'));
        NamedCharReferences.r("nprcue", Character.valueOf('\u22e0'));
        NamedCharReferences.r("npre", Character.valueOf('\u2aaf'));
        NamedCharReferences.r("nprec", Character.valueOf('\u2280'));
        NamedCharReferences.r("npreceq", Character.valueOf('\u2aaf'));
        NamedCharReferences.r("nrArr", Character.valueOf('\u21cf'));
        NamedCharReferences.r("nrarr", Character.valueOf('\u219b'));
        NamedCharReferences.r("nrarrc", Character.valueOf('\u2933'));
        NamedCharReferences.r("nrarrw", Character.valueOf('\u219d'));
        NamedCharReferences.r("nrightarrow", Character.valueOf('\u219b'));
        NamedCharReferences.r("nRightarrow", Character.valueOf('\u21cf'));
        NamedCharReferences.r("nrtri", Character.valueOf('\u22eb'));
        NamedCharReferences.r("nrtrie", Character.valueOf('\u22ed'));
        NamedCharReferences.r("nsc", Character.valueOf('\u2281'));
        NamedCharReferences.r("nsccue", Character.valueOf('\u22e1'));
        NamedCharReferences.r("nsce", Character.valueOf('\u2ab0'));
        NamedCharReferences.r("nshortmid", Character.valueOf('\u2224'));
        NamedCharReferences.r("nshortparallel", Character.valueOf('\u2226'));
        NamedCharReferences.r("nsim", Character.valueOf('\u2241'));
        NamedCharReferences.r("nsime", Character.valueOf('\u2244'));
        NamedCharReferences.r("nsimeq", Character.valueOf('\u2244'));
        NamedCharReferences.r("nsmid", Character.valueOf('\u2224'));
        NamedCharReferences.r("nspar", Character.valueOf('\u2226'));
        NamedCharReferences.r("nsqsube", Character.valueOf('\u22e2'));
        NamedCharReferences.r("nsqsupe", Character.valueOf('\u22e3'));
        NamedCharReferences.r("nsub", Character.valueOf('\u2284'));
        NamedCharReferences.r("nsube", Character.valueOf('\u2288'));
        NamedCharReferences.r("nsubE", Character.valueOf('\u2ac5'));
        NamedCharReferences.r("nsubset", Character.valueOf('\u2282'));
        NamedCharReferences.r("nsubseteq", Character.valueOf('\u2288'));
        NamedCharReferences.r("nsubseteqq", Character.valueOf('\u2ac5'));
        NamedCharReferences.r("nsucc", Character.valueOf('\u2281'));
        NamedCharReferences.r("nsucceq", Character.valueOf('\u2ab0'));
        NamedCharReferences.r("nsup", Character.valueOf('\u2285'));
        NamedCharReferences.r("nsupE", Character.valueOf('\u2ac6'));
        NamedCharReferences.r("nsupe", Character.valueOf('\u2289'));
        NamedCharReferences.r("nsupset", Character.valueOf('\u2283'));
        NamedCharReferences.r("nsupseteq", Character.valueOf('\u2289'));
        NamedCharReferences.r("nsupseteqq", Character.valueOf('\u2ac6'));
        NamedCharReferences.r("ntgl", Character.valueOf('\u2279'));
        NamedCharReferences.r("ntilde", Character.valueOf('\u00f1'));
        NamedCharReferences.r("Ntilde", Character.valueOf('\u00d1'));
        NamedCharReferences.r("ntlg", Character.valueOf('\u2278'));
        NamedCharReferences.r("ntriangleleft", Character.valueOf('\u22ea'));
        NamedCharReferences.r("ntrianglelefteq", Character.valueOf('\u22ec'));
        NamedCharReferences.r("ntriangleright", Character.valueOf('\u22eb'));
        NamedCharReferences.r("ntrianglerighteq", Character.valueOf('\u22ed'));
        NamedCharReferences.r("Nu", Character.valueOf('\u039d'));
        NamedCharReferences.r("nu", Character.valueOf('\u03bd'));
        NamedCharReferences.r("num", Character.valueOf('#'));
        NamedCharReferences.r("numero", Character.valueOf('\u2116'));
        NamedCharReferences.r("numsp", Character.valueOf('\u2007'));
        NamedCharReferences.r("nvap", Character.valueOf('\u224d'));
        NamedCharReferences.r("nvdash", Character.valueOf('\u22ac'));
        NamedCharReferences.r("nvDash", Character.valueOf('\u22ad'));
        NamedCharReferences.r("nVdash", Character.valueOf('\u22ae'));
        NamedCharReferences.r("nVDash", Character.valueOf('\u22af'));
        NamedCharReferences.r("nvge", Character.valueOf('\u2265'));
        NamedCharReferences.r("nvgt", Character.valueOf('>'));
        NamedCharReferences.r("nvHarr", Character.valueOf('\u2904'));
        NamedCharReferences.r("nvinfin", Character.valueOf('\u29de'));
        NamedCharReferences.r("nvlArr", Character.valueOf('\u2902'));
        NamedCharReferences.r("nvle", Character.valueOf('\u2264'));
        NamedCharReferences.r("nvlt", Character.valueOf('<'));
        NamedCharReferences.r("nvltrie", Character.valueOf('\u22b4'));
        NamedCharReferences.r("nvrArr", Character.valueOf('\u2903'));
        NamedCharReferences.r("nvrtrie", Character.valueOf('\u22b5'));
        NamedCharReferences.r("nvsim", Character.valueOf('\u223c'));
        NamedCharReferences.r("nwarhk", Character.valueOf('\u2923'));
        NamedCharReferences.r("nwArr", Character.valueOf('\u21d6'));
        NamedCharReferences.r("nwarr", Character.valueOf('\u2196'));
        NamedCharReferences.r("nwarrow", Character.valueOf('\u2196'));
        NamedCharReferences.r("nwnear", Character.valueOf('\u2927'));
        NamedCharReferences.r("oacute", Character.valueOf('\u00f3'));
        NamedCharReferences.r("Oacute", Character.valueOf('\u00d3'));
        NamedCharReferences.r("oast", Character.valueOf('\u229b'));
        NamedCharReferences.r("ocir", Character.valueOf('\u229a'));
        NamedCharReferences.r("ocirc", Character.valueOf('\u00f4'));
        NamedCharReferences.r("Ocirc", Character.valueOf('\u00d4'));
        NamedCharReferences.r("Ocy", Character.valueOf('\u041e'));
        NamedCharReferences.r("ocy", Character.valueOf('\u043e'));
        NamedCharReferences.r("odash", Character.valueOf('\u229d'));
        NamedCharReferences.r("Odblac", Character.valueOf('\u0150'));
        NamedCharReferences.r("odblac", Character.valueOf('\u0151'));
        NamedCharReferences.r("odiv", Character.valueOf('\u2a38'));
        NamedCharReferences.r("odot", Character.valueOf('\u2299'));
        NamedCharReferences.r("odsold", Character.valueOf('\u29bc'));
        NamedCharReferences.r("oelig", Character.valueOf('\u0153'));
        NamedCharReferences.r("OElig", Character.valueOf('\u0152'));
        NamedCharReferences.r("ofcir", Character.valueOf('\u29bf'));
        NamedCharReferences.r("ogon", Character.valueOf('\u02db'));
        NamedCharReferences.r("Ograve", Character.valueOf('\u00d2'));
        NamedCharReferences.r("ograve", Character.valueOf('\u00f2'));
        NamedCharReferences.r("ogt", Character.valueOf('\u29c1'));
        NamedCharReferences.r("ohbar", Character.valueOf('\u29b5'));
        NamedCharReferences.r("ohm", Character.valueOf('\u03a9'));
        NamedCharReferences.r("oint", Character.valueOf('\u222e'));
        NamedCharReferences.r("olarr", Character.valueOf('\u21ba'));
        NamedCharReferences.r("olcir", Character.valueOf('\u29be'));
        NamedCharReferences.r("olcross", Character.valueOf('\u29bb'));
        NamedCharReferences.r("oline", Character.valueOf('\u203e'));
        NamedCharReferences.r("olt", Character.valueOf('\u29c0'));
        NamedCharReferences.r("Omacr", Character.valueOf('\u014c'));
        NamedCharReferences.r("omacr", Character.valueOf('\u014d'));
        NamedCharReferences.r("Omega", Character.valueOf('\u03a9'));
        NamedCharReferences.r("omega", Character.valueOf('\u03c9'));
        NamedCharReferences.r("omicron", Character.valueOf('\u03bf'));
        NamedCharReferences.r("Omicron", Character.valueOf('\u039f'));
        NamedCharReferences.r("omid", Character.valueOf('\u29b6'));
        NamedCharReferences.r("ominus", Character.valueOf('\u2296'));
        NamedCharReferences.r("opar", Character.valueOf('\u29b7'));
        NamedCharReferences.r("OpenCurlyDoubleQuote", Character.valueOf('\u201c'));
        NamedCharReferences.r("OpenCurlyQuote", Character.valueOf('\u2018'));
        NamedCharReferences.r("operp", Character.valueOf('\u29b9'));
        NamedCharReferences.r("oplus", Character.valueOf('\u2295'));
        NamedCharReferences.r("Or", Character.valueOf('\u2a54'));
        NamedCharReferences.r("or", Character.valueOf('\u2228'));
        NamedCharReferences.r("orarr", Character.valueOf('\u21bb'));
        NamedCharReferences.r("ord", Character.valueOf('\u2a5d'));
        NamedCharReferences.r("order", Character.valueOf('\u2134'));
        NamedCharReferences.r("orderof", Character.valueOf('\u2134'));
        NamedCharReferences.r("ordf", Character.valueOf('\u00aa'));
        NamedCharReferences.r("ordm", Character.valueOf('\u00ba'));
        NamedCharReferences.r("origof", Character.valueOf('\u22b6'));
        NamedCharReferences.r("oror", Character.valueOf('\u2a56'));
        NamedCharReferences.r("orslope", Character.valueOf('\u2a57'));
        NamedCharReferences.r("orv", Character.valueOf('\u2a5b'));
        NamedCharReferences.r("oS", Character.valueOf('\u24c8'));
        NamedCharReferences.r("oscr", Character.valueOf('\u2134'));
        NamedCharReferences.r("oslash", Character.valueOf('\u00f8'));
        NamedCharReferences.r("Oslash", Character.valueOf('\u00d8'));
        NamedCharReferences.r("osol", Character.valueOf('\u2298'));
        NamedCharReferences.r("Otilde", Character.valueOf('\u00d5'));
        NamedCharReferences.r("otilde", Character.valueOf('\u00f5'));
        NamedCharReferences.r("otimes", Character.valueOf('\u2297'));
        NamedCharReferences.r("Otimes", Character.valueOf('\u2a37'));
        NamedCharReferences.r("otimesas", Character.valueOf('\u2a36'));
        NamedCharReferences.r("ouml", Character.valueOf('\u00f6'));
        NamedCharReferences.r("Ouml", Character.valueOf('\u00d6'));
        NamedCharReferences.r("ovbar", Character.valueOf('\u233d'));
        NamedCharReferences.r("OverBar", Character.valueOf('\u203e'));
        NamedCharReferences.r("OverBrace", Character.valueOf('\u23de'));
        NamedCharReferences.r("OverBracket", Character.valueOf('\u23b4'));
        NamedCharReferences.r("OverParenthesis", Character.valueOf('\u23dc'));
        NamedCharReferences.r("par", Character.valueOf('\u2225'));
        NamedCharReferences.r("para", Character.valueOf('\u00b6'));
        NamedCharReferences.r("parallel", Character.valueOf('\u2225'));
        NamedCharReferences.r("parsim", Character.valueOf('\u2af3'));
        NamedCharReferences.r("parsl", Character.valueOf('\u2afd'));
        NamedCharReferences.r("part", Character.valueOf('\u2202'));
        NamedCharReferences.r("PartialD", Character.valueOf('\u2202'));
        NamedCharReferences.r("pcy", Character.valueOf('\u043f'));
        NamedCharReferences.r("Pcy", Character.valueOf('\u041f'));
        NamedCharReferences.r("percnt", Character.valueOf('%'));
        NamedCharReferences.r("period", Character.valueOf('.'));
        NamedCharReferences.r("permil", Character.valueOf('\u2030'));
        NamedCharReferences.r("perp", Character.valueOf('\u22a5'));
        NamedCharReferences.r("pertenk", Character.valueOf('\u2031'));
        NamedCharReferences.r("Phi", Character.valueOf('\u03a6'));
        NamedCharReferences.r("phi", Character.valueOf('\u03c6'));
        NamedCharReferences.r("phiv", Character.valueOf('\u03d5'));
        NamedCharReferences.r("phmmat", Character.valueOf('\u2133'));
        NamedCharReferences.r("phone", Character.valueOf('\u260e'));
        NamedCharReferences.r("Pi", Character.valueOf('\u03a0'));
        NamedCharReferences.r("pi", Character.valueOf('\u03c0'));
        NamedCharReferences.r("pitchfork", Character.valueOf('\u22d4'));
        NamedCharReferences.r("piv", Character.valueOf('\u03d6'));
        NamedCharReferences.r("planck", Character.valueOf('\u210f'));
        NamedCharReferences.r("planckh", Character.valueOf('\u210e'));
        NamedCharReferences.r("plankv", Character.valueOf('\u210f'));
        NamedCharReferences.r("plus", Character.valueOf('+'));
        NamedCharReferences.r("plusacir", Character.valueOf('\u2a23'));
        NamedCharReferences.r("plusb", Character.valueOf('\u229e'));
        NamedCharReferences.r("pluscir", Character.valueOf('\u2a22'));
        NamedCharReferences.r("plusdo", Character.valueOf('\u2214'));
        NamedCharReferences.r("plusdu", Character.valueOf('\u2a25'));
        NamedCharReferences.r("pluse", Character.valueOf('\u2a72'));
        NamedCharReferences.r("PlusMinus", Character.valueOf('\u00b1'));
        NamedCharReferences.r("plusmn", Character.valueOf('\u00b1'));
        NamedCharReferences.r("plussim", Character.valueOf('\u2a26'));
        NamedCharReferences.r("plustwo", Character.valueOf('\u2a27'));
        NamedCharReferences.r("pm", Character.valueOf('\u00b1'));
        NamedCharReferences.r("Poincareplane", Character.valueOf('\u210c'));
        NamedCharReferences.r("pointint", Character.valueOf('\u2a15'));
        NamedCharReferences.r("Popf", Character.valueOf('\u2119'));
        NamedCharReferences.r("pound", Character.valueOf('\u00a3'));
        NamedCharReferences.r("Pr", Character.valueOf('\u2abb'));
        NamedCharReferences.r("pr", Character.valueOf('\u227a'));
        NamedCharReferences.r("prap", Character.valueOf('\u2ab7'));
        NamedCharReferences.r("prcue", Character.valueOf('\u227c'));
        NamedCharReferences.r("prE", Character.valueOf('\u2ab3'));
        NamedCharReferences.r("pre", Character.valueOf('\u2aaf'));
        NamedCharReferences.r("prec", Character.valueOf('\u227a'));
        NamedCharReferences.r("precapprox", Character.valueOf('\u2ab7'));
        NamedCharReferences.r("preccurlyeq", Character.valueOf('\u227c'));
        NamedCharReferences.r("Precedes", Character.valueOf('\u227a'));
        NamedCharReferences.r("PrecedesEqual", Character.valueOf('\u2aaf'));
        NamedCharReferences.r("PrecedesSlantEqual", Character.valueOf('\u227c'));
        NamedCharReferences.r("PrecedesTilde", Character.valueOf('\u227e'));
        NamedCharReferences.r("preceq", Character.valueOf('\u2aaf'));
        NamedCharReferences.r("precnapprox", Character.valueOf('\u2ab9'));
        NamedCharReferences.r("precneqq", Character.valueOf('\u2ab5'));
        NamedCharReferences.r("precnsim", Character.valueOf('\u22e8'));
        NamedCharReferences.r("precsim", Character.valueOf('\u227e'));
        NamedCharReferences.r("prime", Character.valueOf('\u2032'));
        NamedCharReferences.r("Prime", Character.valueOf('\u2033'));
        NamedCharReferences.r("primes", Character.valueOf('\u2119'));
        NamedCharReferences.r("prnap", Character.valueOf('\u2ab9'));
        NamedCharReferences.r("prnE", Character.valueOf('\u2ab5'));
        NamedCharReferences.r("prnsim", Character.valueOf('\u22e8'));
        NamedCharReferences.r("prod", Character.valueOf('\u220f'));
        NamedCharReferences.r("Product", Character.valueOf('\u220f'));
        NamedCharReferences.r("profalar", Character.valueOf('\u232e'));
        NamedCharReferences.r("profline", Character.valueOf('\u2312'));
        NamedCharReferences.r("profsurf", Character.valueOf('\u2313'));
        NamedCharReferences.r("prop", Character.valueOf('\u221d'));
        NamedCharReferences.r("Proportion", Character.valueOf('\u2237'));
        NamedCharReferences.r("Proportional", Character.valueOf('\u221d'));
        NamedCharReferences.r("propto", Character.valueOf('\u221d'));
        NamedCharReferences.r("prsim", Character.valueOf('\u227e'));
        NamedCharReferences.r("prurel", Character.valueOf('\u22b0'));
        NamedCharReferences.r("psi", Character.valueOf('\u03c8'));
        NamedCharReferences.r("Psi", Character.valueOf('\u03a8'));
        NamedCharReferences.r("puncsp", Character.valueOf('\u2008'));
        NamedCharReferences.r("qint", Character.valueOf('\u2a0c'));
        NamedCharReferences.r("Qopf", Character.valueOf('\u211a'));
        NamedCharReferences.r("qprime", Character.valueOf('\u2057'));
        NamedCharReferences.r("quaternions", Character.valueOf('\u210d'));
        NamedCharReferences.r("quatint", Character.valueOf('\u2a16'));
        NamedCharReferences.r("quest", Character.valueOf('?'));
        NamedCharReferences.r("questeq", Character.valueOf('\u225f'));
        NamedCharReferences.r("rAarr", Character.valueOf('\u21db'));
        NamedCharReferences.r("race", Character.valueOf('\u223d'));
        NamedCharReferences.r("racute", Character.valueOf('\u0155'));
        NamedCharReferences.r("Racute", Character.valueOf('\u0154'));
        NamedCharReferences.r("radic", Character.valueOf('\u221a'));
        NamedCharReferences.r("raemptyv", Character.valueOf('\u29b3'));
        NamedCharReferences.r("rang", Character.valueOf('\u27e9'));
        NamedCharReferences.r("Rang", Character.valueOf('\u27eb'));
        NamedCharReferences.r("rangd", Character.valueOf('\u2992'));
        NamedCharReferences.r("range", Character.valueOf('\u29a5'));
        NamedCharReferences.r("rangle", Character.valueOf('\u27e9'));
        NamedCharReferences.r("raquo", Character.valueOf('\u00bb'));
        NamedCharReferences.r("rarr", Character.valueOf('\u2192'));
        NamedCharReferences.r("Rarr", Character.valueOf('\u21a0'));
        NamedCharReferences.r("rArr", Character.valueOf('\u21d2'));
        NamedCharReferences.r("rarrap", Character.valueOf('\u2975'));
        NamedCharReferences.r("rarrb", Character.valueOf('\u21e5'));
        NamedCharReferences.r("rarrbfs", Character.valueOf('\u2920'));
        NamedCharReferences.r("rarrc", Character.valueOf('\u2933'));
        NamedCharReferences.r("rarrfs", Character.valueOf('\u291e'));
        NamedCharReferences.r("rarrhk", Character.valueOf('\u21aa'));
        NamedCharReferences.r("rarrlp", Character.valueOf('\u21ac'));
        NamedCharReferences.r("rarrpl", Character.valueOf('\u2945'));
        NamedCharReferences.r("rarrsim", Character.valueOf('\u2974'));
        NamedCharReferences.r("rarrtl", Character.valueOf('\u21a3'));
        NamedCharReferences.r("Rarrtl", Character.valueOf('\u2916'));
        NamedCharReferences.r("rarrw", Character.valueOf('\u219d'));
        NamedCharReferences.r("rAtail", Character.valueOf('\u291c'));
        NamedCharReferences.r("ratail", Character.valueOf('\u291a'));
        NamedCharReferences.r("ratio", Character.valueOf('\u2236'));
        NamedCharReferences.r("rationals", Character.valueOf('\u211a'));
        NamedCharReferences.r("rbarr", Character.valueOf('\u290d'));
        NamedCharReferences.r("rBarr", Character.valueOf('\u290f'));
        NamedCharReferences.r("RBarr", Character.valueOf('\u2910'));
        NamedCharReferences.r("rbbrk", Character.valueOf('\u2773'));
        NamedCharReferences.r("rbrace", Character.valueOf('}'));
        NamedCharReferences.r("rbrack", Character.valueOf(']'));
        NamedCharReferences.r("rbrke", Character.valueOf('\u298c'));
        NamedCharReferences.r("rbrksld", Character.valueOf('\u298e'));
        NamedCharReferences.r("rbrkslu", Character.valueOf('\u2990'));
        NamedCharReferences.r("Rcaron", Character.valueOf('\u0158'));
        NamedCharReferences.r("rcaron", Character.valueOf('\u0159'));
        NamedCharReferences.r("Rcedil", Character.valueOf('\u0156'));
        NamedCharReferences.r("rcedil", Character.valueOf('\u0157'));
        NamedCharReferences.r("rceil", Character.valueOf('\u2309'));
        NamedCharReferences.r("rcub", Character.valueOf('}'));
        NamedCharReferences.r("rcy", Character.valueOf('\u0440'));
        NamedCharReferences.r("Rcy", Character.valueOf('\u0420'));
        NamedCharReferences.r("rdca", Character.valueOf('\u2937'));
        NamedCharReferences.r("rdldhar", Character.valueOf('\u2969'));
        NamedCharReferences.r("rdquo", Character.valueOf('\u201d'));
        NamedCharReferences.r("rdquor", Character.valueOf('\u201d'));
        NamedCharReferences.r("rdsh", Character.valueOf('\u21b3'));
        NamedCharReferences.r("Re", Character.valueOf('\u211c'));
        NamedCharReferences.r("real", Character.valueOf('\u211c'));
        NamedCharReferences.r("realine", Character.valueOf('\u211b'));
        NamedCharReferences.r("realpart", Character.valueOf('\u211c'));
        NamedCharReferences.r("reals", Character.valueOf('\u211d'));
        NamedCharReferences.r("rect", Character.valueOf('\u25ad'));
        NamedCharReferences.r("reg", Character.valueOf('\u00ae'));
        NamedCharReferences.r("REG", Character.valueOf('\u00ae'));
        NamedCharReferences.r("ReverseElement", Character.valueOf('\u220b'));
        NamedCharReferences.r("ReverseEquilibrium", Character.valueOf('\u21cb'));
        NamedCharReferences.r("ReverseUpEquilibrium", Character.valueOf('\u296f'));
        NamedCharReferences.r("rfisht", Character.valueOf('\u297d'));
        NamedCharReferences.r("rfloor", Character.valueOf('\u230b'));
        NamedCharReferences.r("Rfr", Character.valueOf('\u211c'));
        NamedCharReferences.r("rHar", Character.valueOf('\u2964'));
        NamedCharReferences.r("rhard", Character.valueOf('\u21c1'));
        NamedCharReferences.r("rharu", Character.valueOf('\u21c0'));
        NamedCharReferences.r("rharul", Character.valueOf('\u296c'));
        NamedCharReferences.r("rho", Character.valueOf('\u03c1'));
        NamedCharReferences.r("Rho", Character.valueOf('\u03a1'));
        NamedCharReferences.r("rhov", Character.valueOf('\u03f1'));
        NamedCharReferences.r("RightAngleBracket", Character.valueOf('\u27e9'));
        NamedCharReferences.r("rightarrow", Character.valueOf('\u2192'));
        NamedCharReferences.r("Rightarrow", Character.valueOf('\u21d2'));
        NamedCharReferences.r("RightArrow", Character.valueOf('\u2192'));
        NamedCharReferences.r("RightArrowBar", Character.valueOf('\u21e5'));
        NamedCharReferences.r("RightArrowLeftArrow", Character.valueOf('\u21c4'));
        NamedCharReferences.r("rightarrowtail", Character.valueOf('\u21a3'));
        NamedCharReferences.r("RightCeiling", Character.valueOf('\u2309'));
        NamedCharReferences.r("RightDoubleBracket", Character.valueOf('\u27e7'));
        NamedCharReferences.r("RightDownTeeVector", Character.valueOf('\u295d'));
        NamedCharReferences.r("RightDownVector", Character.valueOf('\u21c2'));
        NamedCharReferences.r("RightDownVectorBar", Character.valueOf('\u2955'));
        NamedCharReferences.r("RightFloor", Character.valueOf('\u230b'));
        NamedCharReferences.r("rightharpoondown", Character.valueOf('\u21c1'));
        NamedCharReferences.r("rightharpoonup", Character.valueOf('\u21c0'));
        NamedCharReferences.r("rightleftarrows", Character.valueOf('\u21c4'));
        NamedCharReferences.r("rightleftharpoons", Character.valueOf('\u21cc'));
        NamedCharReferences.r("rightrightarrows", Character.valueOf('\u21c9'));
        NamedCharReferences.r("rightsquigarrow", Character.valueOf('\u219d'));
        NamedCharReferences.r("RightTee", Character.valueOf('\u22a2'));
        NamedCharReferences.r("RightTeeArrow", Character.valueOf('\u21a6'));
        NamedCharReferences.r("RightTeeVector", Character.valueOf('\u295b'));
        NamedCharReferences.r("rightthreetimes", Character.valueOf('\u22cc'));
        NamedCharReferences.r("RightTriangle", Character.valueOf('\u22b3'));
        NamedCharReferences.r("RightTriangleBar", Character.valueOf('\u29d0'));
        NamedCharReferences.r("RightTriangleEqual", Character.valueOf('\u22b5'));
        NamedCharReferences.r("RightUpDownVector", Character.valueOf('\u294f'));
        NamedCharReferences.r("RightUpTeeVector", Character.valueOf('\u295c'));
        NamedCharReferences.r("RightUpVector", Character.valueOf('\u21be'));
        NamedCharReferences.r("RightUpVectorBar", Character.valueOf('\u2954'));
        NamedCharReferences.r("RightVector", Character.valueOf('\u21c0'));
        NamedCharReferences.r("RightVectorBar", Character.valueOf('\u2953'));
        NamedCharReferences.r("ring", Character.valueOf('\u02da'));
        NamedCharReferences.r("risingdotseq", Character.valueOf('\u2253'));
        NamedCharReferences.r("rlarr", Character.valueOf('\u21c4'));
        NamedCharReferences.r("rlhar", Character.valueOf('\u21cc'));
        NamedCharReferences.r("rlm", Character.valueOf('\u200f'));
        NamedCharReferences.r("rmoust", Character.valueOf('\u23b1'));
        NamedCharReferences.r("rmoustache", Character.valueOf('\u23b1'));
        NamedCharReferences.r("rnmid", Character.valueOf('\u2aee'));
        NamedCharReferences.r("roang", Character.valueOf('\u27ed'));
        NamedCharReferences.r("roarr", Character.valueOf('\u21fe'));
        NamedCharReferences.r("robrk", Character.valueOf('\u27e7'));
        NamedCharReferences.r("ropar", Character.valueOf('\u2986'));
        NamedCharReferences.r("Ropf", Character.valueOf('\u211d'));
        NamedCharReferences.r("roplus", Character.valueOf('\u2a2e'));
        NamedCharReferences.r("rotimes", Character.valueOf('\u2a35'));
        NamedCharReferences.r("RoundImplies", Character.valueOf('\u2970'));
        NamedCharReferences.r("rpar", Character.valueOf(')'));
        NamedCharReferences.r("rpargt", Character.valueOf('\u2994'));
        NamedCharReferences.r("rppolint", Character.valueOf('\u2a12'));
        NamedCharReferences.r("rrarr", Character.valueOf('\u21c9'));
        NamedCharReferences.r("Rrightarrow", Character.valueOf('\u21db'));
        NamedCharReferences.r("rsaquo", Character.valueOf('\u203a'));
        NamedCharReferences.r("Rscr", Character.valueOf('\u211b'));
        NamedCharReferences.r("rsh", Character.valueOf('\u21b1'));
        NamedCharReferences.r("Rsh", Character.valueOf('\u21b1'));
        NamedCharReferences.r("rsqb", Character.valueOf(']'));
        NamedCharReferences.r("rsquo", Character.valueOf('\u2019'));
        NamedCharReferences.r("rsquor", Character.valueOf('\u2019'));
        NamedCharReferences.r("rthree", Character.valueOf('\u22cc'));
        NamedCharReferences.r("rtimes", Character.valueOf('\u22ca'));
        NamedCharReferences.r("rtri", Character.valueOf('\u25b9'));
        NamedCharReferences.r("rtrie", Character.valueOf('\u22b5'));
        NamedCharReferences.r("rtrif", Character.valueOf('\u25b8'));
        NamedCharReferences.r("rtriltri", Character.valueOf('\u29ce'));
        NamedCharReferences.r("RuleDelayed", Character.valueOf('\u29f4'));
        NamedCharReferences.r("ruluhar", Character.valueOf('\u2968'));
        NamedCharReferences.r("rx", Character.valueOf('\u211e'));
        NamedCharReferences.r("Sacute", Character.valueOf('\u015a'));
        NamedCharReferences.r("sacute", Character.valueOf('\u015b'));
        NamedCharReferences.r("sbquo", Character.valueOf('\u201a'));
        NamedCharReferences.r("Sc", Character.valueOf('\u2abc'));
        NamedCharReferences.r("sc", Character.valueOf('\u227b'));
        NamedCharReferences.r("scap", Character.valueOf('\u2ab8'));
        NamedCharReferences.r("scaron", Character.valueOf('\u0161'));
        NamedCharReferences.r("Scaron", Character.valueOf('\u0160'));
        NamedCharReferences.r("sccue", Character.valueOf('\u227d'));
        NamedCharReferences.r("scE", Character.valueOf('\u2ab4'));
        NamedCharReferences.r("sce", Character.valueOf('\u2ab0'));
        NamedCharReferences.r("scedil", Character.valueOf('\u015f'));
        NamedCharReferences.r("Scedil", Character.valueOf('\u015e'));
        NamedCharReferences.r("scirc", Character.valueOf('\u015d'));
        NamedCharReferences.r("Scirc", Character.valueOf('\u015c'));
        NamedCharReferences.r("scnap", Character.valueOf('\u2aba'));
        NamedCharReferences.r("scnE", Character.valueOf('\u2ab6'));
        NamedCharReferences.r("scnsim", Character.valueOf('\u22e9'));
        NamedCharReferences.r("scpolint", Character.valueOf('\u2a13'));
        NamedCharReferences.r("scsim", Character.valueOf('\u227f'));
        NamedCharReferences.r("Scy", Character.valueOf('\u0421'));
        NamedCharReferences.r("scy", Character.valueOf('\u0441'));
        NamedCharReferences.r("sdot", Character.valueOf('\u22c5'));
        NamedCharReferences.r("sdotb", Character.valueOf('\u22a1'));
        NamedCharReferences.r("sdote", Character.valueOf('\u2a66'));
        NamedCharReferences.r("searhk", Character.valueOf('\u2925'));
        NamedCharReferences.r("searr", Character.valueOf('\u2198'));
        NamedCharReferences.r("seArr", Character.valueOf('\u21d8'));
        NamedCharReferences.r("searrow", Character.valueOf('\u2198'));
        NamedCharReferences.r("sect", Character.valueOf('\u00a7'));
        NamedCharReferences.r("semi", Character.valueOf(';'));
        NamedCharReferences.r("seswar", Character.valueOf('\u2929'));
        NamedCharReferences.r("setminus", Character.valueOf('\u2216'));
        NamedCharReferences.r("setmn", Character.valueOf('\u2216'));
        NamedCharReferences.r("sext", Character.valueOf('\u2736'));
        NamedCharReferences.r("sfrown", Character.valueOf('\u2322'));
        NamedCharReferences.r("sharp", Character.valueOf('\u266f'));
        NamedCharReferences.r("SHCHcy", Character.valueOf('\u0429'));
        NamedCharReferences.r("shchcy", Character.valueOf('\u0449'));
        NamedCharReferences.r("SHcy", Character.valueOf('\u0428'));
        NamedCharReferences.r("shcy", Character.valueOf('\u0448'));
        NamedCharReferences.r("ShortDownArrow", Character.valueOf('\u2193'));
        NamedCharReferences.r("ShortLeftArrow", Character.valueOf('\u2190'));
        NamedCharReferences.r("shortmid", Character.valueOf('\u2223'));
        NamedCharReferences.r("shortparallel", Character.valueOf('\u2225'));
        NamedCharReferences.r("ShortRightArrow", Character.valueOf('\u2192'));
        NamedCharReferences.r("ShortUpArrow", Character.valueOf('\u2191'));
        NamedCharReferences.r("shy", Character.valueOf('\u00ad'));
        NamedCharReferences.r("sigma", Character.valueOf('\u03c3'));
        NamedCharReferences.r("Sigma", Character.valueOf('\u03a3'));
        NamedCharReferences.r("sigmaf", Character.valueOf('\u03c2'));
        NamedCharReferences.r("sigmav", Character.valueOf('\u03c2'));
        NamedCharReferences.r("sim", Character.valueOf('\u223c'));
        NamedCharReferences.r("simdot", Character.valueOf('\u2a6a'));
        NamedCharReferences.r("sime", Character.valueOf('\u2243'));
        NamedCharReferences.r("simeq", Character.valueOf('\u2243'));
        NamedCharReferences.r("simg", Character.valueOf('\u2a9e'));
        NamedCharReferences.r("simgE", Character.valueOf('\u2aa0'));
        NamedCharReferences.r("siml", Character.valueOf('\u2a9d'));
        NamedCharReferences.r("simlE", Character.valueOf('\u2a9f'));
        NamedCharReferences.r("simne", Character.valueOf('\u2246'));
        NamedCharReferences.r("simplus", Character.valueOf('\u2a24'));
        NamedCharReferences.r("simrarr", Character.valueOf('\u2972'));
        NamedCharReferences.r("slarr", Character.valueOf('\u2190'));
        NamedCharReferences.r("SmallCircle", Character.valueOf('\u2218'));
        NamedCharReferences.r("smallsetminus", Character.valueOf('\u2216'));
        NamedCharReferences.r("smashp", Character.valueOf('\u2a33'));
        NamedCharReferences.r("smeparsl", Character.valueOf('\u29e4'));
        NamedCharReferences.r("smid", Character.valueOf('\u2223'));
        NamedCharReferences.r("smile", Character.valueOf('\u2323'));
        NamedCharReferences.r("smt", Character.valueOf('\u2aaa'));
        NamedCharReferences.r("smte", Character.valueOf('\u2aac'));
        NamedCharReferences.r("smtes", Character.valueOf('\u2aac'));
        NamedCharReferences.r("softcy", Character.valueOf('\u044c'));
        NamedCharReferences.r("SOFTcy", Character.valueOf('\u042c'));
        NamedCharReferences.r("sol", Character.valueOf('/'));
        NamedCharReferences.r("solb", Character.valueOf('\u29c4'));
        NamedCharReferences.r("solbar", Character.valueOf('\u233f'));
        NamedCharReferences.r("spades", Character.valueOf('\u2660'));
        NamedCharReferences.r("spadesuit", Character.valueOf('\u2660'));
        NamedCharReferences.r("spar", Character.valueOf('\u2225'));
        NamedCharReferences.r("sqcap", Character.valueOf('\u2293'));
        NamedCharReferences.r("sqcaps", Character.valueOf('\u2293'));
        NamedCharReferences.r("sqcup", Character.valueOf('\u2294'));
        NamedCharReferences.r("sqcups", Character.valueOf('\u2294'));
        NamedCharReferences.r("Sqrt", Character.valueOf('\u221a'));
        NamedCharReferences.r("sqsub", Character.valueOf('\u228f'));
        NamedCharReferences.r("sqsube", Character.valueOf('\u2291'));
        NamedCharReferences.r("sqsubset", Character.valueOf('\u228f'));
        NamedCharReferences.r("sqsubseteq", Character.valueOf('\u2291'));
        NamedCharReferences.r("sqsup", Character.valueOf('\u2290'));
        NamedCharReferences.r("sqsupe", Character.valueOf('\u2292'));
        NamedCharReferences.r("sqsupset", Character.valueOf('\u2290'));
        NamedCharReferences.r("sqsupseteq", Character.valueOf('\u2292'));
        NamedCharReferences.r("squ", Character.valueOf('\u25a1'));
        NamedCharReferences.r("square", Character.valueOf('\u25a1'));
        NamedCharReferences.r("Square", Character.valueOf('\u25a1'));
        NamedCharReferences.r("SquareIntersection", Character.valueOf('\u2293'));
        NamedCharReferences.r("SquareSubset", Character.valueOf('\u228f'));
        NamedCharReferences.r("SquareSubsetEqual", Character.valueOf('\u2291'));
        NamedCharReferences.r("SquareSuperset", Character.valueOf('\u2290'));
        NamedCharReferences.r("SquareSupersetEqual", Character.valueOf('\u2292'));
        NamedCharReferences.r("SquareUnion", Character.valueOf('\u2294'));
        NamedCharReferences.r("squarf", Character.valueOf('\u25aa'));
        NamedCharReferences.r("squf", Character.valueOf('\u25aa'));
        NamedCharReferences.r("srarr", Character.valueOf('\u2192'));
        NamedCharReferences.r("ssetmn", Character.valueOf('\u2216'));
        NamedCharReferences.r("ssmile", Character.valueOf('\u2323'));
        NamedCharReferences.r("sstarf", Character.valueOf('\u22c6'));
        NamedCharReferences.r("Star", Character.valueOf('\u22c6'));
        NamedCharReferences.r("star", Character.valueOf('\u2606'));
        NamedCharReferences.r("starf", Character.valueOf('\u2605'));
        NamedCharReferences.r("straightepsilon", Character.valueOf('\u03f5'));
        NamedCharReferences.r("straightphi", Character.valueOf('\u03d5'));
        NamedCharReferences.r("strns", Character.valueOf('\u00af'));
        NamedCharReferences.r("Sub", Character.valueOf('\u22d0'));
        NamedCharReferences.r("sub", Character.valueOf('\u2282'));
        NamedCharReferences.r("subdot", Character.valueOf('\u2abd'));
        NamedCharReferences.r("sube", Character.valueOf('\u2286'));
        NamedCharReferences.r("subE", Character.valueOf('\u2ac5'));
        NamedCharReferences.r("subedot", Character.valueOf('\u2ac3'));
        NamedCharReferences.r("submult", Character.valueOf('\u2ac1'));
        NamedCharReferences.r("subnE", Character.valueOf('\u2acb'));
        NamedCharReferences.r("subne", Character.valueOf('\u228a'));
        NamedCharReferences.r("subplus", Character.valueOf('\u2abf'));
        NamedCharReferences.r("subrarr", Character.valueOf('\u2979'));
        NamedCharReferences.r("subset", Character.valueOf('\u2282'));
        NamedCharReferences.r("Subset", Character.valueOf('\u22d0'));
        NamedCharReferences.r("subseteq", Character.valueOf('\u2286'));
        NamedCharReferences.r("subseteqq", Character.valueOf('\u2ac5'));
        NamedCharReferences.r("SubsetEqual", Character.valueOf('\u2286'));
        NamedCharReferences.r("subsetneq", Character.valueOf('\u228a'));
        NamedCharReferences.r("subsetneqq", Character.valueOf('\u2acb'));
        NamedCharReferences.r("subsim", Character.valueOf('\u2ac7'));
        NamedCharReferences.r("subsub", Character.valueOf('\u2ad5'));
        NamedCharReferences.r("subsup", Character.valueOf('\u2ad3'));
        NamedCharReferences.r("succ", Character.valueOf('\u227b'));
        NamedCharReferences.r("succapprox", Character.valueOf('\u2ab8'));
        NamedCharReferences.r("succcurlyeq", Character.valueOf('\u227d'));
        NamedCharReferences.r("Succeeds", Character.valueOf('\u227b'));
        NamedCharReferences.r("SucceedsEqual", Character.valueOf('\u2ab0'));
        NamedCharReferences.r("SucceedsSlantEqual", Character.valueOf('\u227d'));
        NamedCharReferences.r("SucceedsTilde", Character.valueOf('\u227f'));
        NamedCharReferences.r("succeq", Character.valueOf('\u2ab0'));
        NamedCharReferences.r("succnapprox", Character.valueOf('\u2aba'));
        NamedCharReferences.r("succneqq", Character.valueOf('\u2ab6'));
        NamedCharReferences.r("succnsim", Character.valueOf('\u22e9'));
        NamedCharReferences.r("succsim", Character.valueOf('\u227f'));
        NamedCharReferences.r("SuchThat", Character.valueOf('\u220b'));
        NamedCharReferences.r("Sum", Character.valueOf('\u2211'));
        NamedCharReferences.r("sum", Character.valueOf('\u2211'));
        NamedCharReferences.r("sung", Character.valueOf('\u266a'));
        NamedCharReferences.r("Sup", Character.valueOf('\u22d1'));
        NamedCharReferences.r("sup", Character.valueOf('\u2283'));
        NamedCharReferences.r("sup1", Character.valueOf('\u00b9'));
        NamedCharReferences.r("sup2", Character.valueOf('\u00b2'));
        NamedCharReferences.r("sup3", Character.valueOf('\u00b3'));
        NamedCharReferences.r("supdot", Character.valueOf('\u2abe'));
        NamedCharReferences.r("supdsub", Character.valueOf('\u2ad8'));
        NamedCharReferences.r("supe", Character.valueOf('\u2287'));
        NamedCharReferences.r("supE", Character.valueOf('\u2ac6'));
        NamedCharReferences.r("supedot", Character.valueOf('\u2ac4'));
        NamedCharReferences.r("Superset", Character.valueOf('\u2283'));
        NamedCharReferences.r("SupersetEqual", Character.valueOf('\u2287'));
        NamedCharReferences.r("suphsol", Character.valueOf('\u27c9'));
        NamedCharReferences.r("suphsub", Character.valueOf('\u2ad7'));
        NamedCharReferences.r("suplarr", Character.valueOf('\u297b'));
        NamedCharReferences.r("supmult", Character.valueOf('\u2ac2'));
        NamedCharReferences.r("supnE", Character.valueOf('\u2acc'));
        NamedCharReferences.r("supne", Character.valueOf('\u228b'));
        NamedCharReferences.r("supplus", Character.valueOf('\u2ac0'));
        NamedCharReferences.r("Supset", Character.valueOf('\u22d1'));
        NamedCharReferences.r("supset", Character.valueOf('\u2283'));
        NamedCharReferences.r("supseteq", Character.valueOf('\u2287'));
        NamedCharReferences.r("supseteqq", Character.valueOf('\u2ac6'));
        NamedCharReferences.r("supsetneq", Character.valueOf('\u228b'));
        NamedCharReferences.r("supsetneqq", Character.valueOf('\u2acc'));
        NamedCharReferences.r("supsim", Character.valueOf('\u2ac8'));
        NamedCharReferences.r("supsub", Character.valueOf('\u2ad4'));
        NamedCharReferences.r("supsup", Character.valueOf('\u2ad6'));
        NamedCharReferences.r("swarhk", Character.valueOf('\u2926'));
        NamedCharReferences.r("swarr", Character.valueOf('\u2199'));
        NamedCharReferences.r("swArr", Character.valueOf('\u21d9'));
        NamedCharReferences.r("swarrow", Character.valueOf('\u2199'));
        NamedCharReferences.r("swnwar", Character.valueOf('\u292a'));
        NamedCharReferences.r("szlig", Character.valueOf('\u00df'));
        NamedCharReferences.r("Tab", Character.valueOf('\t'));
        NamedCharReferences.r("target", Character.valueOf('\u2316'));
        NamedCharReferences.r("Tau", Character.valueOf('\u03a4'));
        NamedCharReferences.r("tau", Character.valueOf('\u03c4'));
        NamedCharReferences.r("tbrk", Character.valueOf('\u23b4'));
        NamedCharReferences.r("tcaron", Character.valueOf('\u0165'));
        NamedCharReferences.r("Tcaron", Character.valueOf('\u0164'));
        NamedCharReferences.r("Tcedil", Character.valueOf('\u0162'));
        NamedCharReferences.r("tcedil", Character.valueOf('\u0163'));
        NamedCharReferences.r("Tcy", Character.valueOf('\u0422'));
        NamedCharReferences.r("tcy", Character.valueOf('\u0442'));
        NamedCharReferences.r("tdot", Character.valueOf('\u20db'));
        NamedCharReferences.r("telrec", Character.valueOf('\u2315'));
        NamedCharReferences.r("there4", Character.valueOf('\u2234'));
        NamedCharReferences.r("Therefore", Character.valueOf('\u2234'));
        NamedCharReferences.r("therefore", Character.valueOf('\u2234'));
        NamedCharReferences.r("Theta", Character.valueOf('\u0398'));
        NamedCharReferences.r("theta", Character.valueOf('\u03b8'));
        NamedCharReferences.r("thetasym", Character.valueOf('\u03d1'));
        NamedCharReferences.r("thetav", Character.valueOf('\u03d1'));
        NamedCharReferences.r("thickapprox", Character.valueOf('\u2248'));
        NamedCharReferences.r("thicksim", Character.valueOf('\u223c'));
        NamedCharReferences.r("ThickSpace", Character.valueOf('\u205f'));
        NamedCharReferences.r("thinsp", Character.valueOf('\u2009'));
        NamedCharReferences.r("ThinSpace", Character.valueOf('\u2009'));
        NamedCharReferences.r("thkap", Character.valueOf('\u2248'));
        NamedCharReferences.r("thksim", Character.valueOf('\u223c'));
        NamedCharReferences.r("THORN", Character.valueOf('\u00de'));
        NamedCharReferences.r("thorn", Character.valueOf('\u00fe'));
        NamedCharReferences.r("tilde", Character.valueOf('\u02dc'));
        NamedCharReferences.r("Tilde", Character.valueOf('\u223c'));
        NamedCharReferences.r("TildeEqual", Character.valueOf('\u2243'));
        NamedCharReferences.r("TildeFullEqual", Character.valueOf('\u2245'));
        NamedCharReferences.r("TildeTilde", Character.valueOf('\u2248'));
        NamedCharReferences.r("times", Character.valueOf('\u00d7'));
        NamedCharReferences.r("timesb", Character.valueOf('\u22a0'));
        NamedCharReferences.r("timesbar", Character.valueOf('\u2a31'));
        NamedCharReferences.r("timesd", Character.valueOf('\u2a30'));
        NamedCharReferences.r("tint", Character.valueOf('\u222d'));
        NamedCharReferences.r("toea", Character.valueOf('\u2928'));
        NamedCharReferences.r("top", Character.valueOf('\u22a4'));
        NamedCharReferences.r("topbot", Character.valueOf('\u2336'));
        NamedCharReferences.r("topcir", Character.valueOf('\u2af1'));
        NamedCharReferences.r("topfork", Character.valueOf('\u2ada'));
        NamedCharReferences.r("tosa", Character.valueOf('\u2929'));
        NamedCharReferences.r("tprime", Character.valueOf('\u2034'));
        NamedCharReferences.r("TRADE", Character.valueOf('\u2122'));
        NamedCharReferences.r("trade", Character.valueOf('\u2122'));
        NamedCharReferences.r("triangle", Character.valueOf('\u25b5'));
        NamedCharReferences.r("triangledown", Character.valueOf('\u25bf'));
        NamedCharReferences.r("triangleleft", Character.valueOf('\u25c3'));
        NamedCharReferences.r("trianglelefteq", Character.valueOf('\u22b4'));
        NamedCharReferences.r("triangleq", Character.valueOf('\u225c'));
        NamedCharReferences.r("triangleright", Character.valueOf('\u25b9'));
        NamedCharReferences.r("trianglerighteq", Character.valueOf('\u22b5'));
        NamedCharReferences.r("tridot", Character.valueOf('\u25ec'));
        NamedCharReferences.r("trie", Character.valueOf('\u225c'));
        NamedCharReferences.r("triminus", Character.valueOf('\u2a3a'));
        NamedCharReferences.r("TripleDot", Character.valueOf('\u20db'));
        NamedCharReferences.r("triplus", Character.valueOf('\u2a39'));
        NamedCharReferences.r("trisb", Character.valueOf('\u29cd'));
        NamedCharReferences.r("tritime", Character.valueOf('\u2a3b'));
        NamedCharReferences.r("trpezium", Character.valueOf('\u23e2'));
        NamedCharReferences.r("TScy", Character.valueOf('\u0426'));
        NamedCharReferences.r("tscy", Character.valueOf('\u0446'));
        NamedCharReferences.r("TSHcy", Character.valueOf('\u040b'));
        NamedCharReferences.r("tshcy", Character.valueOf('\u045b'));
        NamedCharReferences.r("Tstrok", Character.valueOf('\u0166'));
        NamedCharReferences.r("tstrok", Character.valueOf('\u0167'));
        NamedCharReferences.r("twixt", Character.valueOf('\u226c'));
        NamedCharReferences.r("twoheadleftarrow", Character.valueOf('\u219e'));
        NamedCharReferences.r("twoheadrightarrow", Character.valueOf('\u21a0'));
        NamedCharReferences.r("Uacute", Character.valueOf('\u00da'));
        NamedCharReferences.r("uacute", Character.valueOf('\u00fa'));
        NamedCharReferences.r("uarr", Character.valueOf('\u2191'));
        NamedCharReferences.r("uArr", Character.valueOf('\u21d1'));
        NamedCharReferences.r("Uarr", Character.valueOf('\u219f'));
        NamedCharReferences.r("Uarrocir", Character.valueOf('\u2949'));
        NamedCharReferences.r("Ubrcy", Character.valueOf('\u040e'));
        NamedCharReferences.r("ubrcy", Character.valueOf('\u045e'));
        NamedCharReferences.r("Ubreve", Character.valueOf('\u016c'));
        NamedCharReferences.r("ubreve", Character.valueOf('\u016d'));
        NamedCharReferences.r("Ucirc", Character.valueOf('\u00db'));
        NamedCharReferences.r("ucirc", Character.valueOf('\u00fb'));
        NamedCharReferences.r("ucy", Character.valueOf('\u0443'));
        NamedCharReferences.r("Ucy", Character.valueOf('\u0423'));
        NamedCharReferences.r("udarr", Character.valueOf('\u21c5'));
        NamedCharReferences.r("udblac", Character.valueOf('\u0171'));
        NamedCharReferences.r("Udblac", Character.valueOf('\u0170'));
        NamedCharReferences.r("udhar", Character.valueOf('\u296e'));
        NamedCharReferences.r("ufisht", Character.valueOf('\u297e'));
        NamedCharReferences.r("ugrave", Character.valueOf('\u00f9'));
        NamedCharReferences.r("Ugrave", Character.valueOf('\u00d9'));
        NamedCharReferences.r("uHar", Character.valueOf('\u2963'));
        NamedCharReferences.r("uharl", Character.valueOf('\u21bf'));
        NamedCharReferences.r("uharr", Character.valueOf('\u21be'));
        NamedCharReferences.r("uhblk", Character.valueOf('\u2580'));
        NamedCharReferences.r("ulcorn", Character.valueOf('\u231c'));
        NamedCharReferences.r("ulcorner", Character.valueOf('\u231c'));
        NamedCharReferences.r("ulcrop", Character.valueOf('\u230f'));
        NamedCharReferences.r("ultri", Character.valueOf('\u25f8'));
        NamedCharReferences.r("Umacr", Character.valueOf('\u016a'));
        NamedCharReferences.r("umacr", Character.valueOf('\u016b'));
        NamedCharReferences.r("uml", Character.valueOf('\u00a8'));
        NamedCharReferences.r("UnderBar", Character.valueOf('_'));
        NamedCharReferences.r("UnderBrace", Character.valueOf('\u23df'));
        NamedCharReferences.r("UnderBracket", Character.valueOf('\u23b5'));
        NamedCharReferences.r("UnderParenthesis", Character.valueOf('\u23dd'));
        NamedCharReferences.r("Union", Character.valueOf('\u22c3'));
        NamedCharReferences.r("UnionPlus", Character.valueOf('\u228e'));
        NamedCharReferences.r("Uogon", Character.valueOf('\u0172'));
        NamedCharReferences.r("uogon", Character.valueOf('\u0173'));
        NamedCharReferences.r("UpArrow", Character.valueOf('\u2191'));
        NamedCharReferences.r("Uparrow", Character.valueOf('\u21d1'));
        NamedCharReferences.r("uparrow", Character.valueOf('\u2191'));
        NamedCharReferences.r("UpArrowBar", Character.valueOf('\u2912'));
        NamedCharReferences.r("UpArrowDownArrow", Character.valueOf('\u21c5'));
        NamedCharReferences.r("Updownarrow", Character.valueOf('\u21d5'));
        NamedCharReferences.r("updownarrow", Character.valueOf('\u2195'));
        NamedCharReferences.r("UpDownArrow", Character.valueOf('\u2195'));
        NamedCharReferences.r("UpEquilibrium", Character.valueOf('\u296e'));
        NamedCharReferences.r("upharpoonleft", Character.valueOf('\u21bf'));
        NamedCharReferences.r("upharpoonright", Character.valueOf('\u21be'));
        NamedCharReferences.r("uplus", Character.valueOf('\u228e'));
        NamedCharReferences.r("UpperLeftArrow", Character.valueOf('\u2196'));
        NamedCharReferences.r("UpperRightArrow", Character.valueOf('\u2197'));
        NamedCharReferences.r("Upsi", Character.valueOf('\u03d2'));
        NamedCharReferences.r("upsi", Character.valueOf('\u03c5'));
        NamedCharReferences.r("upsih", Character.valueOf('\u03d2'));
        NamedCharReferences.r("upsilon", Character.valueOf('\u03c5'));
        NamedCharReferences.r("Upsilon", Character.valueOf('\u03a5'));
        NamedCharReferences.r("UpTee", Character.valueOf('\u22a5'));
        NamedCharReferences.r("UpTeeArrow", Character.valueOf('\u21a5'));
        NamedCharReferences.r("upuparrows", Character.valueOf('\u21c8'));
        NamedCharReferences.r("urcorn", Character.valueOf('\u231d'));
        NamedCharReferences.r("urcorner", Character.valueOf('\u231d'));
        NamedCharReferences.r("urcrop", Character.valueOf('\u230e'));
        NamedCharReferences.r("Uring", Character.valueOf('\u016e'));
        NamedCharReferences.r("uring", Character.valueOf('\u016f'));
        NamedCharReferences.r("urtri", Character.valueOf('\u25f9'));
        NamedCharReferences.r("utdot", Character.valueOf('\u22f0'));
        NamedCharReferences.r("Utilde", Character.valueOf('\u0168'));
        NamedCharReferences.r("utilde", Character.valueOf('\u0169'));
        NamedCharReferences.r("utri", Character.valueOf('\u25b5'));
        NamedCharReferences.r("utrif", Character.valueOf('\u25b4'));
        NamedCharReferences.r("uuarr", Character.valueOf('\u21c8'));
        NamedCharReferences.r("uuml", Character.valueOf('\u00fc'));
        NamedCharReferences.r("Uuml", Character.valueOf('\u00dc'));
        NamedCharReferences.r("uwangle", Character.valueOf('\u29a7'));
        NamedCharReferences.r("vangrt", Character.valueOf('\u299c'));
        NamedCharReferences.r("varepsilon", Character.valueOf('\u03f5'));
        NamedCharReferences.r("varkappa", Character.valueOf('\u03f0'));
        NamedCharReferences.r("varnothing", Character.valueOf('\u2205'));
        NamedCharReferences.r("varphi", Character.valueOf('\u03d5'));
        NamedCharReferences.r("varpi", Character.valueOf('\u03d6'));
        NamedCharReferences.r("varpropto", Character.valueOf('\u221d'));
        NamedCharReferences.r("vArr", Character.valueOf('\u21d5'));
        NamedCharReferences.r("varr", Character.valueOf('\u2195'));
        NamedCharReferences.r("varrho", Character.valueOf('\u03f1'));
        NamedCharReferences.r("varsigma", Character.valueOf('\u03c2'));
        NamedCharReferences.r("varsubsetneq", Character.valueOf('\u228a'));
        NamedCharReferences.r("varsubsetneqq", Character.valueOf('\u2acb'));
        NamedCharReferences.r("varsupsetneq", Character.valueOf('\u228b'));
        NamedCharReferences.r("varsupsetneqq", Character.valueOf('\u2acc'));
        NamedCharReferences.r("vartheta", Character.valueOf('\u03d1'));
        NamedCharReferences.r("vartriangleleft", Character.valueOf('\u22b2'));
        NamedCharReferences.r("vartriangleright", Character.valueOf('\u22b3'));
        NamedCharReferences.r("vBar", Character.valueOf('\u2ae8'));
        NamedCharReferences.r("Vbar", Character.valueOf('\u2aeb'));
        NamedCharReferences.r("vBarv", Character.valueOf('\u2ae9'));
        NamedCharReferences.r("vcy", Character.valueOf('\u0432'));
        NamedCharReferences.r("Vcy", Character.valueOf('\u0412'));
        NamedCharReferences.r("Vdash", Character.valueOf('\u22a9'));
        NamedCharReferences.r("vDash", Character.valueOf('\u22a8'));
        NamedCharReferences.r("VDash", Character.valueOf('\u22ab'));
        NamedCharReferences.r("vdash", Character.valueOf('\u22a2'));
        NamedCharReferences.r("Vdashl", Character.valueOf('\u2ae6'));
        NamedCharReferences.r("vee", Character.valueOf('\u2228'));
        NamedCharReferences.r("Vee", Character.valueOf('\u22c1'));
        NamedCharReferences.r("veebar", Character.valueOf('\u22bb'));
        NamedCharReferences.r("veeeq", Character.valueOf('\u225a'));
        NamedCharReferences.r("vellip", Character.valueOf('\u22ee'));
        NamedCharReferences.r("verbar", Character.valueOf('|'));
        NamedCharReferences.r("Verbar", Character.valueOf('\u2016'));
        NamedCharReferences.r("vert", Character.valueOf('|'));
        NamedCharReferences.r("Vert", Character.valueOf('\u2016'));
        NamedCharReferences.r("VerticalBar", Character.valueOf('\u2223'));
        NamedCharReferences.r("VerticalLine", Character.valueOf('|'));
        NamedCharReferences.r("VerticalSeparator", Character.valueOf('\u2758'));
        NamedCharReferences.r("VerticalTilde", Character.valueOf('\u2240'));
        NamedCharReferences.r("VeryThinSpace", Character.valueOf('\u200a'));
        NamedCharReferences.r("vltri", Character.valueOf('\u22b2'));
        NamedCharReferences.r("vnsub", Character.valueOf('\u2282'));
        NamedCharReferences.r("vnsup", Character.valueOf('\u2283'));
        NamedCharReferences.r("vprop", Character.valueOf('\u221d'));
        NamedCharReferences.r("vrtri", Character.valueOf('\u22b3'));
        NamedCharReferences.r("vsubnE", Character.valueOf('\u2acb'));
        NamedCharReferences.r("vsubne", Character.valueOf('\u228a'));
        NamedCharReferences.r("vsupne", Character.valueOf('\u228b'));
        NamedCharReferences.r("vsupnE", Character.valueOf('\u2acc'));
        NamedCharReferences.r("Vvdash", Character.valueOf('\u22aa'));
        NamedCharReferences.r("vzigzag", Character.valueOf('\u299a'));
        NamedCharReferences.r("wcirc", Character.valueOf('\u0175'));
        NamedCharReferences.r("Wcirc", Character.valueOf('\u0174'));
        NamedCharReferences.r("wedbar", Character.valueOf('\u2a5f'));
        NamedCharReferences.r("Wedge", Character.valueOf('\u22c0'));
        NamedCharReferences.r("wedge", Character.valueOf('\u2227'));
        NamedCharReferences.r("wedgeq", Character.valueOf('\u2259'));
        NamedCharReferences.r("weierp", Character.valueOf('\u2118'));
        NamedCharReferences.r("wp", Character.valueOf('\u2118'));
        NamedCharReferences.r("wr", Character.valueOf('\u2240'));
        NamedCharReferences.r("wreath", Character.valueOf('\u2240'));
        NamedCharReferences.r("xcap", Character.valueOf('\u22c2'));
        NamedCharReferences.r("xcirc", Character.valueOf('\u25ef'));
        NamedCharReferences.r("xcup", Character.valueOf('\u22c3'));
        NamedCharReferences.r("xdtri", Character.valueOf('\u25bd'));
        NamedCharReferences.r("xharr", Character.valueOf('\u27f7'));
        NamedCharReferences.r("xhArr", Character.valueOf('\u27fa'));
        NamedCharReferences.r("Xi", Character.valueOf('\u039e'));
        NamedCharReferences.r("xi", Character.valueOf('\u03be'));
        NamedCharReferences.r("xlarr", Character.valueOf('\u27f5'));
        NamedCharReferences.r("xlArr", Character.valueOf('\u27f8'));
        NamedCharReferences.r("xmap", Character.valueOf('\u27fc'));
        NamedCharReferences.r("xnis", Character.valueOf('\u22fb'));
        NamedCharReferences.r("xodot", Character.valueOf('\u2a00'));
        NamedCharReferences.r("xoplus", Character.valueOf('\u2a01'));
        NamedCharReferences.r("xotime", Character.valueOf('\u2a02'));
        NamedCharReferences.r("xrArr", Character.valueOf('\u27f9'));
        NamedCharReferences.r("xrarr", Character.valueOf('\u27f6'));
        NamedCharReferences.r("xsqcup", Character.valueOf('\u2a06'));
        NamedCharReferences.r("xuplus", Character.valueOf('\u2a04'));
        NamedCharReferences.r("xutri", Character.valueOf('\u25b3'));
        NamedCharReferences.r("xvee", Character.valueOf('\u22c1'));
        NamedCharReferences.r("xwedge", Character.valueOf('\u22c0'));
        NamedCharReferences.r("yacute", Character.valueOf('\u00fd'));
        NamedCharReferences.r("Yacute", Character.valueOf('\u00dd'));
        NamedCharReferences.r("YAcy", Character.valueOf('\u042f'));
        NamedCharReferences.r("yacy", Character.valueOf('\u044f'));
        NamedCharReferences.r("Ycirc", Character.valueOf('\u0176'));
        NamedCharReferences.r("ycirc", Character.valueOf('\u0177'));
        NamedCharReferences.r("ycy", Character.valueOf('\u044b'));
        NamedCharReferences.r("Ycy", Character.valueOf('\u042b'));
        NamedCharReferences.r("yen", Character.valueOf('\u00a5'));
        NamedCharReferences.r("YIcy", Character.valueOf('\u0407'));
        NamedCharReferences.r("yicy", Character.valueOf('\u0457'));
        NamedCharReferences.r("yucy", Character.valueOf('\u044e'));
        NamedCharReferences.r("YUcy", Character.valueOf('\u042e'));
        NamedCharReferences.r("yuml", Character.valueOf('\u00ff'));
        NamedCharReferences.r("Yuml", Character.valueOf('\u0178'));
        NamedCharReferences.r("zacute", Character.valueOf('\u017a'));
        NamedCharReferences.r("Zacute", Character.valueOf('\u0179'));
        NamedCharReferences.r("zcaron", Character.valueOf('\u017e'));
        NamedCharReferences.r("Zcaron", Character.valueOf('\u017d'));
        NamedCharReferences.r("zcy", Character.valueOf('\u0437'));
        NamedCharReferences.r("Zcy", Character.valueOf('\u0417'));
        NamedCharReferences.r("zdot", Character.valueOf('\u017c'));
        NamedCharReferences.r("Zdot", Character.valueOf('\u017b'));
        NamedCharReferences.r("zeetrf", Character.valueOf('\u2128'));
        NamedCharReferences.r("ZeroWidthSpace", Character.valueOf('\u200b'));
        NamedCharReferences.r("zeta", Character.valueOf('\u03b6'));
        NamedCharReferences.r("Zeta", Character.valueOf('\u0396'));
        NamedCharReferences.r("Zfr", Character.valueOf('\u2128'));
        NamedCharReferences.r("ZHcy", Character.valueOf('\u0416'));
        NamedCharReferences.r("zhcy", Character.valueOf('\u0436'));
        NamedCharReferences.r("zigrarr", Character.valueOf('\u21dd'));
        NamedCharReferences.r("Zopf", Character.valueOf('\u2124'));
        NamedCharReferences.r("zwj", Character.valueOf('\u200d'));
        NamedCharReferences.r("zwnj", Character.valueOf('\u200c'));
    }
}

