/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.collection.primitive.impl.standard;

import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.impl.standard.StdHelper;
import com.teacode.collection.primitive.process.IntProcessor;
import java.util.HashSet;
import java.util.Set;

public class StdIntSet
implements IntSet {
    private Set<Integer> set;

    public StdIntSet(int size) {
        this.set = new HashSet<Integer>(size);
    }

    public final void clear() {
        this.set.clear();
    }

    public final int getAny() {
        return this.set.iterator().next();
    }

    public final boolean forEach(IntProcessor processor) {
        for (Integer i : this.set) {
            if (processor.process(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean contains(int value) {
        return this.set.contains(value);
    }

    public final boolean add(int value) {
        return this.set.add(value);
    }

    public final void addAll(int[] values) {
        for (int value : values) {
            this.set.add(value);
        }
    }

    public final void retainAll(int[] values) {
        HashSet<Integer> i = new HashSet<Integer>();
        for (int value : values) {
            Integer o = value;
            if (!this.set.contains(o)) continue;
            i.add(o);
        }
        this.set = i;
    }

    public final int size() {
        return this.set.size();
    }

    public final boolean isEmpty() {
        return this.set.isEmpty();
    }

    public final void removeValue(int value) {
        this.set.remove(value);
    }

    public final int[] toArray() {
        return StdHelper.toArray(this.set);
    }
}

