/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File fromFile, File toFile) throws IOException {
        FileInputStream source = new FileInputStream(fromFile);
        try {
            FileOutputStream destination = new FileOutputStream(toFile);
            try {
                FileChannel sourceFileChannel = source.getChannel();
                FileChannel destinationFileChannel = destination.getChannel();
                sourceFileChannel.transferTo(0L, sourceFileChannel.size(), destinationFileChannel);
            }
            finally {
                destination.close();
            }
        }
        finally {
            source.close();
        }
    }

    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                FileUtil.deleteFile(f);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFullText(File file, String encoding) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            String string = FileUtil.readFullText(in, encoding);
            return string;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFullText(InputStream in, String encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, encoding);
        try {
            String string = FileUtil.readFullText(reader);
            return string;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public static String readFullText(Reader reader) throws IOException {
        int read;
        StringBuilder sb = new StringBuilder(255);
        char[] buffer = new char[70000];
        while ((read = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, read);
        }
        return sb.toString();
    }
}

