/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.hibernate.servlet;

import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

public class HibernateServlet
extends HttpServlet {
    protected String path;
    protected static final String ATTR_PATH = "com.teacode.hibernate.servlet.path";
    protected static final String ATTR_INTERCEPTOR = "com.teacode.hibernate.servlet.interceptor";
    protected static final String ATTR_SF = "com.teacode.hibernate.servlet.attr";
    protected static final String ATTR_CONNECTION_URL = "com.teacode.hibernate.servlet.derbyURL";
    private static final String DERBY_URL_START = "jdbc:derby:";
    private static final String HSQLDB_URL_START = "jdbc:hsqldb:";
    private static final String H2_URL_START = "jdbc:h2:";

    public HibernateServlet(String path) {
        this.path = path;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext app = servletConfig.getServletContext();
        app.setAttribute(ATTR_PATH, (Object)this.path);
        Interceptor interceptor = this.createInterceptor(app);
        if (interceptor != null) {
            app.setAttribute(ATTR_INTERCEPTOR, (Object)interceptor);
        }
    }

    protected Interceptor createInterceptor(ServletContext app) {
        return null;
    }

    public void destroy() {
        super.destroy();
        try {
            HibernateServlet.shutdown(this.getServletContext());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void prepareDB(ServletContext app, Configuration cfg) throws SQLException, ClassNotFoundException {
        String p;
        File dir;
        String realPath = app.getRealPath("/");
        String url = cfg.getProperty("connection.url");
        if ((url = url.replace("${realpath}", realPath)).startsWith(DERBY_URL_START) && !(dir = new File(p = url.substring(DERBY_URL_START.length()))).exists()) {
            Class.forName(cfg.getProperty("connection.driver_class"));
            DriverManager.getConnection(url + ";create=true");
        }
        app.setAttribute(ATTR_CONNECTION_URL, (Object)url);
    }

    public static Configuration getConfiguration(ServletContext app) throws SQLException, ClassNotFoundException {
        File file = new File(app.getRealPath((String)app.getAttribute(ATTR_PATH)));
        System.setProperty("realpath", app.getRealPath("/"));
        AnnotationConfiguration cfg = new AnnotationConfiguration();
        cfg.configure(file);
        Interceptor interceptor = (Interceptor)app.getAttribute(ATTR_INTERCEPTOR);
        if (interceptor != null) {
            cfg.setInterceptor(interceptor);
        }
        HibernateServlet.prepareDB(app, (Configuration)cfg);
        return cfg;
    }

    public static SessionFactory getSessionFactory(ServletContext app) throws SQLException, ClassNotFoundException {
        SessionFactory sf = (SessionFactory)app.getAttribute(ATTR_SF);
        if (sf == null) {
            sf = HibernateServlet.getConfiguration(app).buildSessionFactory();
            app.setAttribute(ATTR_SF, (Object)sf);
        }
        return sf;
    }

    public static void shutdown(ServletContext app) throws SQLException, ClassNotFoundException {
        if (app.getAttribute(ATTR_SF) != null) {
            String url = (String)app.getAttribute(ATTR_CONNECTION_URL);
            if (url == null) {
                return;
            }
            System.out.println("Shut down: " + url);
            if (url.startsWith(HSQLDB_URL_START)) {
                System.out.println("HSQLDB mode");
                SessionFactory sf = HibernateServlet.getSessionFactory(app);
                Session ses = sf.openSession();
                ses.connection().createStatement().executeUpdate("SHUTDOWN COMPACT");
                ses.close();
                sf.close();
            } else if (url.startsWith(DERBY_URL_START)) {
                System.out.println("Apache Derby mode");
                HibernateServlet.getSessionFactory(app).close();
                try {
                    DriverManager.getConnection(url + ";shutdown=true");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                app.removeAttribute(ATTR_CONNECTION_URL);
            } else {
                System.out.println("Unknown DB mode");
                HibernateServlet.getSessionFactory(app).close();
            }
            app.removeAttribute(ATTR_SF);
        }
    }
}

