/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.web;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLHelper {
    protected static final Map<String, Character> fromEntity = new HashMap<String, Character>();
    protected static final Map<Character, String> toEntity = new HashMap<Character, String>();

    protected static void addEntity(char ch, String string) {
        toEntity.put(Character.valueOf(ch), '&' + string + ";");
        fromEntity.put(string, Character.valueOf(ch));
    }

    public static String unescape(String htmlText) {
        int len = htmlText.length();
        StringBuilder sb = new StringBuilder(len);
        StringBuilder entity = null;
        for (int t = 0; t < len; ++t) {
            char ch = htmlText.charAt(t);
            if (entity != null) {
                if (ch == ';') {
                    Character entCh = fromEntity.get(entity.toString());
                    if (entCh == null) {
                        sb.append('?');
                    } else {
                        sb.append(entCh);
                    }
                    entity = null;
                    continue;
                }
                entity.append(ch);
                continue;
            }
            if (ch == '&') {
                entity = new StringBuilder();
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String escapeLight(String text) {
        int len = text.length();
        StringBuilder sb = new StringBuilder(len);
        for (int t = 0; t < len; ++t) {
            char ch = text.charAt(t);
            if (ch == '\r' || ch == '\n') {
                sb.append(ch);
                continue;
            }
            String entity = toEntity.get(Character.valueOf(ch));
            if (entity != null) {
                sb.append(entity);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String escape(String text) {
        int len = text.length();
        StringBuilder sb = new StringBuilder(len);
        for (int t = 0; t < len; ++t) {
            char ch = text.charAt(t);
            String entity = toEntity.get(Character.valueOf(ch));
            if (entity != null) {
                sb.append(entity);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void escape(Writer writer, String text) throws IOException {
        int len = text.length();
        for (int t = 0; t < len; ++t) {
            char ch = text.charAt(t);
            String entity = toEntity.get(Character.valueOf(ch));
            if (entity != null) {
                writer.write(entity);
                continue;
            }
            writer.write(ch);
        }
    }

    public static void escape(Writer writer, char[] text, int off, int len) throws IOException {
        for (int t = 0; t < len; ++t) {
            char ch = text[off + t];
            String entity = toEntity.get(Character.valueOf(ch));
            if (entity != null) {
                writer.write(entity);
                continue;
            }
            writer.write(ch);
        }
    }

    public static List<String> smartSplit(String text) {
        boolean word = false;
        String lastWord = "";
        ArrayList<String> words = new ArrayList<String>();
        for (char c : text.toCharArray()) {
            if (c == '\"') {
                word = !word;
                continue;
            }
            if (c == ' ' || c == '\t') {
                if (word) {
                    lastWord = lastWord + c;
                    continue;
                }
                if (lastWord.length() <= 0) continue;
                words.add(lastWord);
                lastWord = "";
                continue;
            }
            lastWord = lastWord + c;
        }
        if (lastWord.length() > 0) {
            words.add(lastWord);
        }
        return words;
    }

    public static void main(String[] args) throws Exception {
        String text = "\u041f\u0440\u0438\u0432\u0435\u0442! abc";
        System.out.println(text);
        String t = "\u0422\u0435\u043a\u0441, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u0439 <> \u0438 \"'&, \n\r \u0007";
        System.out.println(t);
        System.out.println(HTMLHelper.escape(t));
        System.out.println(HTMLHelper.unescape(HTMLHelper.escape(t)));
        System.out.println(HTMLHelper.unescape("&"));
        System.out.println(HTMLHelper.unescape("1&lll;2"));
        System.out.println(HTMLHelper.smartSplit("\"first word\"   second \"third"));
    }

    static {
        HTMLHelper.addEntity('<', "lt");
        HTMLHelper.addEntity('>', "gt");
        HTMLHelper.addEntity('\'', "apos");
        HTMLHelper.addEntity('\"', "quot");
        HTMLHelper.addEntity('&', "amp");
        for (int c = 0; c < 32; c = (int)((short)(c + 1))) {
            char ch = (char)c;
            String s = Integer.toHexString(c & 0xFF);
            if (s.length() == 1) {
                s = '0' + s;
            }
            HTMLHelper.addEntity(ch, "#x" + s);
        }
    }
}

