/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.collection.primitive.impl.standard;

import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.impl.standard.StdHelper;
import com.teacode.collection.primitive.process.IntProcessor;
import java.util.ArrayList;
import java.util.List;

public class StdIntList
implements IntList {
    private final List<Integer> list;

    public StdIntList(int size) {
        this.list = new ArrayList<Integer>(size);
    }

    public final void clear() {
        this.list.clear();
    }

    public final void insert(int index, int value) {
        this.list.add(index, value);
    }

    public final int indexOf(int index, int value) {
        int size = this.list.size();
        for (int t = index; t < size; ++t) {
            if (this.list.get(t) != value) continue;
            return t;
        }
        return -1;
    }

    public final int get(int index) {
        return this.list.get(index);
    }

    public final boolean forEach(IntProcessor processor) {
        for (Integer i : this.list) {
            if (processor.process(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean contains(int value) {
        return this.list.contains(value);
    }

    public final boolean add(int value) {
        this.list.add(value);
        return true;
    }

    public final void addAll(int[] values) {
        for (int value : values) {
            this.list.add(value);
        }
    }

    public final int size() {
        return this.list.size();
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    public final void removeValue(int value) {
        this.list.remove((Object)value);
    }

    public final void removeIndex(int index) {
        this.list.remove(index);
    }

    public final int[] toArray() {
        return StdHelper.toArray(this.list);
    }
}

