/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BorderedPanel
extends JPanel {
    protected Map<Object, JComponent> constraints = new HashMap<Object, JComponent>();

    public BorderedPanel() {
        super(new BorderLayout());
    }

    public void setComponent(JComponent comp, Object constraint) {
        JComponent oldComp = this.constraints.get(constraint);
        if (oldComp != null) {
            this.remove(oldComp);
        }
        this.add((Component)comp, constraint);
        this.constraints.put(constraint, comp);
        if (oldComp != null) {
            this.refresh();
        }
    }

    public void refresh() {
        this.revalidate();
    }

    public void setCenter(JComponent comp) {
        this.setComponent(comp, "Center");
    }

    public void setPageStart(JComponent comp) {
        this.setComponent(comp, "First");
    }

    public void setPageEnd(JComponent comp) {
        this.setComponent(comp, "Last");
    }

    public void setLineStart(JComponent comp) {
        this.setComponent(comp, "Before");
    }

    public void setLineEnd(JComponent comp) {
        this.setComponent(comp, "After");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        final BorderedPanel p = new BorderedPanel();
        p.setCenter(new JLabel("old center"));
        JButton btn = new JButton("do!");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                p.setCenter(new JLabel("new center - " + new Date()));
            }
        });
        p.setPageStart(btn);
        frame.getContentPane().add(p);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

