/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboPopup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollablePopupMenu
extends BasicComboPopup {
    private JComboBox combo;

    private ScrollablePopupMenu(JComboBox combo) {
        super(combo);
        this.combo = combo;
    }

    @Override
    protected JScrollPane createScroller() {
        return new JScrollPane(this.list, 20, 30);
    }

    public static ScrollablePopupMenu getInstance(List<JMenuItem> items) {
        Vector<ComboItem> v = new Vector<ComboItem>(items.size());
        for (JMenuItem item : items) {
            v.add(new ComboItem(item));
        }
        final JComboBox combo = new JComboBox(v);
        final ScrollablePopupMenu menu = new ScrollablePopupMenu(combo);
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object obj = combo.getSelectedItem();
                if (obj instanceof ComboItem) {
                    ((ComboItem)obj).execute();
                }
                menu.hide();
            }
        });
        return menu;
    }

    private static class ComboItem {
        final JMenuItem item;

        private ComboItem(JMenuItem item) {
            this.item = item;
        }

        public void execute() {
            this.item.doClick();
        }

        public String toString() {
            return this.item.getText();
        }
    }
}

