/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.dialog;

import com.teacode.swing.CommonRB;
import com.teacode.swing.component.ButtonPanel;
import com.teacode.swing.tool.EscapeCanceler;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OkCancelDialog
extends JDialog {
    public static final String OK_ACTION_COMMAND = "OK";
    protected Frame frame;
    protected JButton ok;
    protected JButton cancel;
    protected boolean okPressed;

    public OkCancelDialog(Frame frame, String title, String okTitle) {
        super(frame, title, true);
        this.frame = frame;
        this.ok = new JButton(okTitle);
        this.ok.setActionCommand(OK_ACTION_COMMAND);
        this.cancel = new JButton(CommonRB.get("dialog.cancel"));
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OkCancelDialog.this.okPressed = OkCancelDialog.OK_ACTION_COMMAND.equals(e.getActionCommand());
                OkCancelDialog.this.dispose();
            }
        };
        this.ok.addActionListener(listener);
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel.addActionListener(listener);
        this.getContentPane().add((Component)new ButtonPanel(this.ok, this.cancel), "South");
        EscapeCanceler.install(this);
    }

    public void setMainPanel(JComponent comp) {
        this.getContentPane().add((Component)comp, "Center");
    }

    public void packAndCenter() {
        this.pack();
        this.setLocationRelativeTo(this.frame);
    }

    public void pressOK() {
        this.okPressed = true;
        this.dispose();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public JButton getOkButton() {
        return this.ok;
    }

    public static void main(String[] args) {
        OkCancelDialog dialog = new OkCancelDialog(null, "test title", OK_ACTION_COMMAND);
        JPanel panel = new JPanel();
        JTextField textField = new JTextField(20);
        panel.add(textField);
        dialog.setMainPanel(panel);
        dialog.packAndCenter();
        dialog.setVisible(true);
    }
}

