/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.table;

import com.teacode.swing.table.BaseTableModel;
import com.teacode.swing.table.StringWithToolTip;
import com.teacode.swing.table.TablePacker;
import com.teacode.swing.table.TablePackerMode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ROTable
extends JTable {
    public ROTable(TableModel dm) {
        super(dm);
        this.getSelectionModel().setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            Object value = this.getValueAt(rowIndex, vColIndex);
            if (value instanceof StringWithToolTip) {
                StringWithToolTip s = (StringWithToolTip)value;
                jc.setToolTipText(s.getToolTip());
            } else {
                jc.setToolTipText(String.valueOf(value));
            }
        }
        return c;
    }

    public static void main(String[] args) {
        BaseTableModel<String> model = new BaseTableModel<String>("\u0441\u0442\u0440\u043e\u043a\u04301", new String[]{"\u0441\u0442\u0440\u043e\u043a\u04302"}){

            @Override
            protected List<?> convertToRow(int index, String s) {
                return Arrays.asList(s, s);
            }
        };
        model.addData("1");
        model.addData("2");
        model.addData("3");
        final ROTable table = new ROTable(model);
        TablePacker.pack(table, TablePackerMode.ALL_ROWS, false);
        JButton button = new JButton("pack");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TablePacker.pack(table, TablePackerMode.ALL_ROWS, false);
            }
        });
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)new JScrollPane(table), "Center");
        frame.getContentPane().add((Component)button, "First");
        frame.setSize(640, 480);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

