/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.xhtml;

import com.teacode.swing.component.PreviewArea;
import com.teacode.swing.dialog.CloseButtonDialog;
import com.teacode.swing.dialog.DialogSize;
import com.teacode.swing.tool.SelectTextMouseListener;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.w3c.dom.Element;
import org.w3c.dom.ranges.Range;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.xhtmlrenderer.swing.BasicPanel;
import org.xhtmlrenderer.swing.FSMouseListener;
import org.xhtmlrenderer.swing.ImageReplacedElement;
import org.xhtmlrenderer.swing.LinkListener;
import org.xhtmlrenderer.swing.SelectionHighlighter;
import org.xhtmlrenderer.swing.SwingReplacedElement;
import org.xhtmlrenderer.swing.SwingReplacedElementFactory;

public class XHTMLPanel
extends org.xhtmlrenderer.simple.XHTMLPanel {
    protected String text;
    protected static final String DOCTYPE = "<!DOCTYPE";
    protected static final String DOCTYPE_STRICT = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n";

    public XHTMLPanel() {
        this.getSharedContext().setReplacedElementFactory((ReplacedElementFactory)new ImageFactory());
        this.getSharedContext().getTextRenderer().setSmoothingLevel(3);
        this.getSharedContext().getTextRenderer().setSmoothingThreshold(6.0f);
        this.setLinkListener(new HrefLinkListener());
        final SelectionHighlighter caret = new SelectionHighlighter();
        caret.install((org.xhtmlrenderer.simple.XHTMLPanel)this);
        SelectTextMouseListener.Copyable copyable = new SelectTextMouseListener.Copyable(){

            public JComponent getJComponent() {
                return XHTMLPanel.this;
            }

            public boolean isEditable() {
                return false;
            }

            public boolean isSelectAllSupported() {
                return false;
            }

            public boolean isSelected() {
                return caret.getSelectionRange() != null;
            }

            public void copy() {
                Range range = caret.getSelectionRange();
                if (range == null) {
                    return;
                }
                String str = ((Object)range).toString();
                Clipboard clip = XHTMLPanel.this.getToolkit().getSystemClipboard();
                if (clip != null) {
                    try {
                        clip.setContents(new StringSelection(str), null);
                    }
                    catch (IllegalStateException ise) {
                        // empty catch block
                    }
                }
            }

            public void cut() {
                throw new UnsupportedOperationException();
            }

            public void paste() {
                throw new UnsupportedOperationException();
            }

            public void selectAll() {
                throw new UnsupportedOperationException();
            }
        };
        JPopupMenu popupMenu = SelectTextMouseListener.install(copyable);
        JMenuItem viewSource = new JMenuItem("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442");
        viewSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CloseButtonDialog dia = new CloseButtonDialog(null, "\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442", new JScrollPane(new PreviewArea(XHTMLPanel.this.text)));
                dia.setSize(DialogSize.calcViewSize());
                dia.setLocationRelativeTo(null);
                dia.setVisible(true);
            }
        });
        popupMenu.addSeparator();
        popupMenu.add(viewSource);
    }

    public void setLinkListener(LinkListener linkListener) {
        List trackingListeners = this.getMouseTrackingListeners();
        for (Object o : trackingListeners) {
            if (!(o instanceof LinkListener)) continue;
            this.removeMouseTrackingListener((FSMouseListener)o);
        }
        this.addMouseTrackingListener((FSMouseListener)linkListener);
    }

    public void setXHTML(String xhtml) {
        String d = "<html><body>" + xhtml + "</body></html>";
        this.setXHTMLFull(d);
    }

    public void setXHTMLFull(String xhtml) {
        if (!xhtml.contains(DOCTYPE)) {
            xhtml = DOCTYPE_STRICT + xhtml;
        }
        this.text = xhtml;
        this.setDocumentFromString(xhtml, "", (NamespaceHandler)new XhtmlNamespaceHandler());
        this.resetFontSize();
        this.incrementFontSize();
    }

    protected static class HrefLinkListener
    extends LinkListener {
        protected HrefLinkListener() {
        }

        public void onMouseUp(BasicPanel basicPanel, Box box) {
            Element el = box.getElement();
            if ("a".equalsIgnoreCase(el.getLocalName())) {
                String href = el.getAttribute("href");
                if (href != null) {
                    try {
                        Desktop.getDesktop().browse(new URI(href));
                        return;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                JOptionPane.showMessageDialog(null, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u0441\u0441\u044b\u043b\u043a\u0430");
            }
        }
    }

    protected static class ImageFactory
    extends SwingReplacedElementFactory {
        protected Map<String, Image> url2image;

        protected ImageFactory() {
        }

        public ReplacedElement createReplacedElement(LayoutContext layoutContext, BlockBox blockBox, UserAgentCallback userAgentCallback, int i, int i1) {
            String src;
            Element el = blockBox.getElement();
            if ("img".equalsIgnoreCase(el.getLocalName()) && (src = el.getAttribute("src")) != null) {
                Image image;
                if (this.url2image == null) {
                    this.url2image = new HashMap<String, Image>();
                }
                if ((image = this.url2image.get(src)) == null) {
                    try {
                        image = ImageIO.read(new URL(src));
                        if (image == null) {
                            throw new Exception("404: " + src);
                        }
                        this.url2image.put(src, image);
                    }
                    catch (Exception e) {
                        String message = e.toString();
                        return new SwingReplacedElement((JComponent)new JLabel(message));
                    }
                }
                return new ImageReplacedElement(image, -1, -1);
            }
            return super.createReplacedElement(layoutContext, blockBox, userAgentCallback, i, i1);
        }

        public void reset() {
            super.reset();
        }

        public void remove(Element element) {
            super.remove(element);
        }
    }
}

