/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.bml.test;

import com.teacode.bml.BML;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import junit.framework.TestCase;

public class BMLTest
extends TestCase {
    private static void printBytes(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        sb.append("new byte[] {");
        boolean first = true;
        for (byte b : bytes) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append("0x");
            String s = Integer.toHexString(0xFF & b);
            if (s.length() == 1) {
                sb.append('0').append(s);
                continue;
            }
            sb.append(s);
        }
        sb.append('}');
        System.out.println(sb);
    }

    private static void saveAndLoad(Object obj, byte[] bytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BML.save(obj, out);
        byte[] buf = out.toByteArray();
        BMLTest.printBytes(buf);
        BMLTest.assertEquals((int)bytes.length, (int)buf.length);
        for (int t = 0; t < buf.length; ++t) {
            BMLTest.assertEquals((byte)buf[t], (byte)bytes[t]);
        }
        Object obj2 = BML.load(new ByteArrayInputStream(buf));
        out = new ByteArrayOutputStream();
        BML.save(obj2, out);
        byte[] buf2 = out.toByteArray();
        BMLTest.assertEquals((int)buf.length, (int)buf2.length);
        for (int t = 0; t < buf.length; ++t) {
            BMLTest.assertEquals((byte)buf[t], (byte)buf2[t]);
        }
    }

    public void testSaveLoad() throws IOException {
        BMLTest.saveAndLoad(null, new byte[]{52, 18, 0, 0});
        BMLTest.saveAndLoad(true, new byte[]{52, 18, 0, -127});
        BMLTest.saveAndLoad(false, new byte[]{52, 18, 0, -128});
        BMLTest.saveAndLoad("123", new byte[]{52, 18, 0, 5, 3, 0, 0, 0, 49, 0, 50, 0, 51, 0});
        BMLTest.saveAndLoad("\uffff\u0000\uff00", new byte[]{52, 18, 0, 5, 3, 0, 0, 0, -1, -1, 0, 0, 0, -1});
        BMLTest.saveAndLoad("\u0420\u0423\u0421", new byte[]{52, 18, 0, 5, 3, 0, 0, 0, 32, 4, 35, 4, 33, 4});
        BMLTest.saveAndLoad(new String[]{"A", "b"}, new byte[]{52, 18, 0, 3, 2, 0, 0, 0, 5, 1, 0, 0, 0, 65, 0, 5, 1, 0, 0, 0, 98, 0});
        LinkedList<String> list = new LinkedList<String>();
        list.add(null);
        list.add("\u0410\u0411\u0412");
        BMLTest.saveAndLoad(list, new byte[]{52, 18, 0, 3, 2, 0, 0, 0, 0, 5, 3, 0, 0, 0, 16, 4, 17, 4, 18, 4});
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("test", Collections.emptyList());
        map.put(Character.valueOf('a'), Character.valueOf('b'));
        BMLTest.saveAndLoad(map, new byte[]{52, 18, 0, 1, 2, 0, 0, 0, 5, 4, 0, 0, 0, 116, 0, 101, 0, 115, 0, 116, 0, 3, 0, 0, 0, 0, 9, 97, 0, 9, 98, 0});
        BMLTest.saveAndLoad(Collections.emptySet(), new byte[]{52, 18, 0, 3, 0, 0, 0, 0});
        BMLTest.saveAndLoad((short)7777, new byte[]{52, 18, 0, 16, 97, 30});
        BMLTest.saveAndLoad((short)-1, new byte[]{52, 18, 0, 16, -1, -1});
        BMLTest.saveAndLoad((byte)127, new byte[]{52, 18, 0, 8, 127});
        BMLTest.saveAndLoad((byte)-1, new byte[]{52, 18, 0, 8, -1});
        BMLTest.saveAndLoad(777777777, new byte[]{52, 18, 0, 32, 113, -14, 91, 46});
        BMLTest.saveAndLoad(-1, new byte[]{52, 18, 0, 32, -1, -1, -1, -1});
        BMLTest.saveAndLoad(7777777777777777777L, new byte[]{52, 18, 0, 64, 113, 28, 95, 50, -82, 55, -16, 107});
        BMLTest.saveAndLoad(-1L, new byte[]{52, 18, 0, 64, -1, -1, -1, -1, -1, -1, -1, -1});
    }

    public void testParseInvalid() {
        try {
            BML.load(new ByteArrayInputStream(new byte[]{0, 1, 2}));
            BMLTest.fail((String)"should raise an exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            BML.load(new ByteArrayInputStream(new byte[]{52, 18, 2}));
            BMLTest.fail((String)"should raise an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLoad() {
    }

    public void testString() throws IOException {
        String s = "4\u0012\u0000\u0003\u0002\u0000\u0000\u0000\u0003\u0002\u0000\u0000\u0000@\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000@\u0002\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0003\u0001\u0000\u0000\u0000@\u00ff-\u0015\u00d6=\u0001\u0000\u0000";
        byte[] b = s.getBytes("Latin1");
        System.out.println(BML.load(new ByteArrayInputStream(b)));
    }
}

