/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.code.java;

public class JavaString {
    public static String javaString(String str) {
        if (str == null) {
            return "null";
        }
        return '\"' + JavaString.escape(str) + '\"';
    }

    public static String escapeToUnicode(char c) {
        String hex = Integer.toHexString(c);
        String leadingZeroes = "0000".substring(hex.length());
        return "\\u" + leadingZeroes + hex;
    }

    public static String escape(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        block8: for (char c : str.toCharArray()) {
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                default: {
                    if ('\u0000' <= c && c < ' ') {
                        sb.append(JavaString.escapeToUnicode(c));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

